/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.echain.server.web.rest;

import cn.com.yusys.yusp.commons.mapper.QueryModel;
import cn.com.yusys.yusp.commons.web.rest.dto.ResultDto;
import cn.com.yusys.yusp.echain.client.dto.core.GetNodeListDTO;
import cn.com.yusys.yusp.echain.client.dto.core.GetPropertyDTO;
import cn.com.yusys.yusp.echain.server.domain.AdminSmOrg;
import cn.com.yusys.yusp.echain.server.domain.WfiWorkflowBiz;
import cn.com.yusys.yusp.echain.server.domain.WfiWorkflowNode;
import cn.com.yusys.yusp.echain.server.domain.WfiWorkflowOrg;
import cn.com.yusys.yusp.echain.server.service.EchainCoreService;
import cn.com.yusys.yusp.echain.server.service.EchainJoinBizService;
import com.ecc.echain.workflow.model.WFINodeVO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/joinbiz"})
public class EchainJoinBizResource {
    @Autowired
    private EchainJoinBizService echainJoinBizService;
    @Autowired
    private EchainCoreService echainCoreService;

    @GetMapping(value={"/queryWfiWorkflowBizList"})
    public ResultDto<List<WfiWorkflowBiz>> queryWfiWorkflowBizList(QueryModel model, String applType) {
        model.getCondition().put("applType", applType);
        List<WfiWorkflowBiz> list = this.echainJoinBizService.queryWfiWorkflowBizListByParam(model);
        return new ResultDto(list);
    }

    @GetMapping(value={"/verifyWfiWorkflowBizList"})
    public ResultDto<Map<String, Object>> verifyWfiWorkflowBizList(QueryModel model) {
        List<WfiWorkflowBiz> list = this.echainJoinBizService.queryWfiWorkflowBizListByParam(model);
        HashMap<String, String> map = new HashMap<String, String>();
        String opType = (String)model.getCondition().get("opType");
        if (list.size() > 0) {
            if ("add".equals(opType)) {
                map.put("flag", "1");
            } else if ("update".equals(opType)) {
                if (list.get(0).getPkvalue().equals(model.getCondition().get("pkvalue"))) {
                    map.put("flag", "0");
                } else {
                    map.put("flag", "1");
                }
            }
        } else {
            map.put("flag", "0");
        }
        return new ResultDto(map);
    }

    @PostMapping(value={"/addWfiWorkflowBiz"})
    public ResultDto<Map<String, Object>> addWfiWorkflowBiz(@RequestBody WfiWorkflowBiz wfiWorkflowBiz) {
        Boolean result = this.echainJoinBizService.addWfiWorkflowBiz(wfiWorkflowBiz);
        HashMap<String, String> map = new HashMap<String, String>();
        if (result.booleanValue()) {
            map.put("message", "\u65b0\u589e\u6210\u529f");
            map.put("flag", "success");
            map.put("pkvalue", wfiWorkflowBiz.getPkvalue());
        } else {
            map.put("message", "\u65b0\u589e\u5931\u8d25");
            map.put("flag", "error");
        }
        return new ResultDto(map);
    }

    @PostMapping(value={"/updateWfiWorkflowBiz"})
    public ResultDto<Map<String, Object>> updateWfiWorkflowBiz(@RequestBody WfiWorkflowBiz wfiWorkflowBiz) {
        Boolean result = this.echainJoinBizService.updateWfiWorkflowBiz(wfiWorkflowBiz);
        HashMap<String, String> map = new HashMap<String, String>();
        if (result.booleanValue()) {
            map.put("message", "\u66f4\u65b0\u6210\u529f");
            map.put("flag", "success");
        } else {
            map.put("message", "\u66f4\u65b0\u5931\u8d25");
            map.put("flag", "error");
        }
        return new ResultDto(map);
    }

    @PostMapping(value={"/deleteWfiWorkflowBiz"})
    public ResultDto<Map<String, Object>> deleteWfiWorkflowBiz(String pkvalue) {
        List<WfiWorkflowNode> list = this.echainJoinBizService.queryWfiNodeBizListByParam(pkvalue);
        if (list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                WfiWorkflowNode wfiWorkflowNode = list.get(i);
                this.echainJoinBizService.deleteWfiNodeBizByPrimaryKey(wfiWorkflowNode.getPkvallue());
            }
        }
        boolean result = this.echainJoinBizService.deleteWfiWorkflowBizByPrimaryKey(pkvalue);
        HashMap<String, String> map = new HashMap<String, String>();
        if (result) {
            map.put("message", "\u5220\u9664\u6210\u529f");
            map.put("flag", "success");
        } else {
            map.put("message", "\u5220\u9664\u5931\u8d25");
            map.put("flag", "error");
        }
        return new ResultDto(map);
    }

    @GetMapping(value={"/queryWfiNode2bizList"})
    public ResultDto<List<WfiWorkflowNode>> queryWfiNode2bizList(QueryModel model, String apkvalue) {
        List<WfiWorkflowNode> list = this.echainJoinBizService.queryPageWfiNodeBizListByParam(model, apkvalue);
        return new ResultDto(list);
    }

    @GetMapping(value={"/queryWFINodeVOList"})
    public ResultDto<List<WFINodeVO>> queryWFINodeVOList(String awfsign, @RequestParam(value="sessionInstuCde") String instuCde, QueryModel model) {
        GetPropertyDTO getPropertyDTO = new GetPropertyDTO(awfsign, null, "wfid");
        getPropertyDTO.setInstuCde(instuCde);
        String wfId = this.echainCoreService.wfGetPropertyByWfSign(getPropertyDTO);
        GetNodeListDTO dto = new GetNodeListDTO(wfId, null);
        dto.setInstuCde(instuCde);
        Map map = this.echainCoreService.wfGetNodeList(dto);
        ArrayList<WFINodeVO> queryList = new ArrayList<WFINodeVO>();
        ArrayList<WFINodeVO> list = new ArrayList<WFINodeVO>();
        Iterator it = map.keySet().iterator();
        while (it.hasNext()) {
            WFINodeVO vo = new WFINodeVO();
            String key = it.next().toString();
            vo.setNodeId(key);
            vo.setNodeName((String)map.get(key));
            queryList.add(vo);
        }
        if (queryList != null && queryList.size() > 0) {
            int size = queryList.size();
            int begin = 0;
            int end = 0;
            if (model.getPage() == 0) {
                list = queryList;
            } else if (size < model.getSize()) {
                list = queryList;
            } else {
                begin = (model.getPage() - 1) * model.getSize();
                end = model.getSize() * model.getPage() > size ? size : model.getSize() * model.getPage();
            }
            for (int i = begin; i < end; ++i) {
                WFINodeVO vo = (WFINodeVO)queryList.get(i);
                list.add(vo);
            }
        }
        ResultDto result = new ResultDto(list);
        result.setTotal((long)queryList.size());
        return result;
    }

    @PostMapping(value={"/addWfiWorkflowNode"})
    public ResultDto<Map<String, Object>> addWfiWorkflowNode(@RequestBody WfiWorkflowNode wfiWorkflowNode) {
        wfiWorkflowNode.setPkvallue(UUID.randomUUID().toString().replaceAll("-", ""));
        Boolean result = this.echainJoinBizService.addWfiWorkflowNode(wfiWorkflowNode);
        HashMap<String, String> map = new HashMap<String, String>();
        if (result.booleanValue()) {
            map.put("message", "\u65b0\u589e\u6210\u529f");
            map.put("flag", "success");
        } else {
            map.put("message", "\u65b0\u589e\u5931\u8d25");
            map.put("flag", "error");
        }
        return new ResultDto(map);
    }

    @PostMapping(value={"/updateWfiWorkflowNode"})
    public ResultDto<Map<String, Object>> updateWfiWorkflowNode(@RequestBody WfiWorkflowNode wfiWorkflowNode) {
        Boolean result = this.echainJoinBizService.updateWfiWorkflowNode(wfiWorkflowNode);
        HashMap<String, String> map = new HashMap<String, String>();
        if (result.booleanValue()) {
            map.put("message", "\u4fee\u6539\u6210\u529f");
            map.put("flag", "success");
        } else {
            map.put("message", "\u4fee\u6539\u5931\u8d25");
            map.put("flag", "error");
        }
        return new ResultDto(map);
    }

    @PostMapping(value={"/deleteWfiWorkflowNode"})
    public ResultDto<Map<String, Object>> deleteWfiWorkflowNode(String pkvallue) {
        Boolean result = this.echainJoinBizService.deleteWfiNodeBizByPrimaryKey(pkvallue);
        HashMap<String, String> map = new HashMap<String, String>();
        if (result.booleanValue()) {
            map.put("message", "\u5220\u9664\u6210\u529f");
            map.put("flag", "success");
        } else {
            map.put("message", "\u5220\u9664\u5931\u8d25");
            map.put("flag", "error");
        }
        return new ResultDto(map);
    }

    @GetMapping(value={"/queryWfiWorkflowOrgByParam"})
    public ResultDto<List<WfiWorkflowOrg>> queryWfiWorkflowOrgByParam(QueryModel model) {
        List<WfiWorkflowOrg> list = this.echainJoinBizService.queryWfiWorkflowOrgByParam(model);
        return new ResultDto(list);
    }

    @GetMapping(value={"/queryAllOrgs"})
    public ResultDto<List<AdminSmOrg>> queryAllOrgs(QueryModel model, @RequestParam(value="sessionInstuCde") String instuCde) {
        List<AdminSmOrg> list = this.echainJoinBizService.queryAdminSmOrgByParam(model, instuCde);
        return new ResultDto(list);
    }

    @PostMapping(value={"/addWfiWorkflowOrg"})
    public ResultDto<Map<String, Object>> addWfiWorkflowOrg(@RequestBody WfiWorkflowOrg wfiWorkflowOrg) {
        wfiWorkflowOrg.setPkvalue(UUID.randomUUID().toString().replaceAll("-", ""));
        Boolean result = this.echainJoinBizService.addWfiWorkflowOrg(wfiWorkflowOrg);
        HashMap<String, String> map = new HashMap<String, String>();
        if (result.booleanValue()) {
            map.put("message", "\u65b0\u589e\u6210\u529f");
            map.put("flag", "success");
        } else {
            map.put("message", "\u65b0\u589e\u5931\u8d25");
            map.put("flag", "error");
        }
        return new ResultDto(map);
    }

    @PostMapping(value={"/updateWfiWorkflowOrg"})
    public ResultDto<Map<String, Object>> updateWfiWorkflowOrg(@RequestBody WfiWorkflowOrg wfiWorkflowOrg) {
        Boolean result = this.echainJoinBizService.updateWfiWorkflowOrg(wfiWorkflowOrg);
        HashMap<String, String> map = new HashMap<String, String>();
        if (result.booleanValue()) {
            map.put("message", "\u4fee\u6539\u6210\u529f");
            map.put("flag", "success");
        } else {
            map.put("message", "\u4fee\u6539\u5931\u8d25");
            map.put("flag", "error");
        }
        return new ResultDto(map);
    }

    @PostMapping(value={"/deleteWfiWorkflowOrg"})
    public ResultDto<Map<String, Object>> deleteWfiWorkflowOrgByPrimaryKey(String pkvalue) {
        Boolean result = this.echainJoinBizService.deleteWfiWorkflowOrgByPrimaryKey(pkvalue);
        HashMap<String, String> map = new HashMap<String, String>();
        if (result.booleanValue()) {
            map.put("message", "\u5220\u9664\u6210\u529f");
            map.put("flag", "success");
        } else {
            map.put("message", "\u5220\u9664\u5931\u8d25");
            map.put("flag", "error");
        }
        return new ResultDto(map);
    }
}

