/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.echain.server.web.rest;

import cn.com.yusys.yusp.commons.mapper.QueryModel;
import cn.com.yusys.yusp.commons.web.rest.dto.ResultDto;
import cn.com.yusys.yusp.echain.server.domain.AdminSmUser;
import cn.com.yusys.yusp.echain.server.domain.WfHumanstates;
import cn.com.yusys.yusp.echain.server.service.EchainJoinAgentService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/joinagent"})
public class EchainJoinAgentResource {
    @Autowired
    private EchainJoinAgentService echainJoinAgentService;

    @PostMapping(value={"/addWfHumanstates"})
    public ResultDto<Map<String, Object>> addWfHumanstates(@RequestBody WfHumanstates wfHumanstates) {
        String instuCde = wfHumanstates.getSysid();
        wfHumanstates.setPkey(UUID.randomUUID().toString().replaceAll("-", ""));
        Boolean success = this.echainJoinAgentService.addWfHumanstates(instuCde, wfHumanstates);
        HashMap<String, String> map = new HashMap<String, String>();
        if (success.booleanValue()) {
            map.put("message", "\u65b0\u589e\u6210\u529f");
            map.put("flag", "success");
        } else {
            map.put("message", "\u65b0\u589e\u5931\u8d25");
            map.put("flag", "error");
        }
        return new ResultDto(map);
    }

    @PostMapping(value={"/updateWfHumanstates"})
    public ResultDto<Map<String, Object>> updateWfHumanstates(@RequestBody WfHumanstates wfHumanstates) {
        Boolean success = this.echainJoinAgentService.updateWFHumanstates(wfHumanstates);
        HashMap<String, String> map = new HashMap<String, String>();
        if (success.booleanValue()) {
            map.put("message", "\u4fee\u6539\u6210\u529f");
            map.put("flag", "success");
        } else {
            map.put("message", "\u4fee\u6539\u5931\u8d25");
            map.put("flag", "error");
        }
        return new ResultDto(map);
    }

    @PostMapping(value={"/deleteWfHumanstates"})
    public ResultDto<Map<String, Object>> deleteWfHumanstates(String pkey) {
        Boolean success = this.echainJoinAgentService.deleteWFHumanstates(pkey);
        HashMap<String, String> map = new HashMap<String, String>();
        if (success.booleanValue()) {
            map.put("message", "\u5220\u9664\u6210\u529f");
            map.put("flag", "success");
        } else {
            map.put("message", "\u5220\u9664\u5931\u8d25");
            map.put("flag", "error");
        }
        return new ResultDto(map);
    }

    @GetMapping(value={"/queryWFHumanstatesList"})
    public ResultDto<List<WfHumanstates>> queryWFHumanstatesList(@RequestParam(value="sessionInstuCde") String instuCde, QueryModel queryModel) {
        if (instuCde == null) {
            instuCde = (String)queryModel.getCondition().get(instuCde);
        }
        List<WfHumanstates> list = this.echainJoinAgentService.queryWFHumanstatesList(instuCde, queryModel);
        return new ResultDto(list);
    }

    @GetMapping(value={"/querySUsrPopList"})
    public ResultDto<List<AdminSmUser>> queryAllUsrsByParamForPop(@RequestParam(value="sessionOrgCode") String orgCode, QueryModel queryModel) {
        List<AdminSmUser> list = this.echainJoinAgentService.queryAllUsrsByParamForPop(orgCode, queryModel);
        return new ResultDto(list);
    }

    @GetMapping(value={"/queryWfHumanstatsByTime"})
    public ResultDto<Map<String, Object>> queryWfHumanstatsByTime(QueryModel queryModel) {
        List<WfHumanstates> list = this.echainJoinAgentService.queryWfHumanstatsByTime(queryModel);
        HashMap<String, String> map = new HashMap<String, String>();
        WfHumanstates wfHum = new WfHumanstates();
        String pkeyQuery = null;
        String retBeginTime = null;
        String retEndTime = null;
        String flag = "0";
        String pkey = (String)queryModel.getCondition().get("pKey");
        String optype = (String)queryModel.getCondition().get("opType");
        if (list.size() == 0) {
            flag = "0";
        } else {
            if (list.size() == 1) {
                wfHum = list.get(0);
                flag = "update".equals(optype) ? (pkey.equals(pkeyQuery = wfHum.getPkey()) ? "0" : "1") : "1";
            } else {
                flag = "1";
                for (int i = 0; i < list.size(); ++i) {
                    WfHumanstates wfHumTmp = list.get(i);
                    pkeyQuery = wfHumTmp.getPkey();
                    if (pkeyQuery.equals(pkey)) continue;
                    wfHum = wfHumTmp;
                    break;
                }
            }
            retBeginTime = wfHum.getBegintime();
            retEndTime = wfHum.getEndtime();
        }
        map.put("beginTime", retBeginTime);
        map.put("endTime", retEndTime);
        map.put("flag", flag);
        return new ResultDto(map);
    }
}

