/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.echain.server.web.rest;

import cn.com.yusys.yusp.commons.mapper.QueryModel;
import cn.com.yusys.yusp.commons.web.rest.dto.ResultDto;
import cn.com.yusys.yusp.echain.server.domain.AdminSmInstu;
import cn.com.yusys.yusp.echain.server.domain.WfClient;
import cn.com.yusys.yusp.echain.server.domain.WfClientInstu;
import cn.com.yusys.yusp.echain.server.domain.WfInstanceEnd;
import cn.com.yusys.yusp.echain.server.domain.WfWorklist;
import cn.com.yusys.yusp.echain.server.service.EchainBenchService;
import com.ecc.echain.workflow.cache.WFClientInstuCache;
import com.ecc.echain.workflow.engine.EVO;
import com.ecc.echain.workflow.engine.WorkFlowClient;
import com.ecc.echain.workflow.model.WFIVO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/bench"})
public class EchainBenchResource {
    @Autowired
    private EchainBenchService echainBenchService;

    @GetMapping(value={"/queryWfInstanceToDo"})
    public ResultDto<List<WfWorklist>> getWfInstanceToDo(QueryModel queryModel) {
        String sysId = WFClientInstuCache.getInstance().getClientSign("" + queryModel.getCondition().get("sessionInstuCde"));
        List<WfWorklist> wfWorklist = this.echainBenchService.queryAllToDoWorkList(sysId, queryModel);
        return new ResultDto(wfWorklist);
    }

    @GetMapping(value={"/queryWfInstanceHang"})
    public ResultDto<List<WfWorklist>> getWfInstanceHang(QueryModel queryModel) {
        String sysId = WFClientInstuCache.getInstance().getClientSign("" + queryModel.getCondition().get("sessionInstuCde"));
        List<WfWorklist> wfWorklist = this.echainBenchService.queryHangWorkList(sysId, queryModel);
        return new ResultDto(wfWorklist);
    }

    @GetMapping(value={"/queryWfInstanceEnd"})
    public ResultDto<List<WfInstanceEnd>> getWfInstanceEnd(QueryModel queryModel) {
        String sysId = WFClientInstuCache.getInstance().getClientSign("" + queryModel.getCondition().get("sessionInstuCde"));
        List<WfInstanceEnd> wfInstanceEnd = this.echainBenchService.queryWfInstanceEnd(sysId, queryModel);
        return new ResultDto(wfInstanceEnd);
    }

    @GetMapping(value={"/queryWfList"})
    public ResultDto<List<WFIVO>> getWfList(@RequestParam(value="sessionOrgCode") String orgCode, @RequestParam(value="sessionLoginCode") String loginCode, QueryModel model) {
        String queryWfSign = (String)model.getCondition().get("wfSign");
        String queryWfName = (String)model.getCondition().get("wfName");
        String orgId = orgCode;
        String currentUserId = loginCode;
        List<WFIVO> wfivoList = this.getWFNameList(currentUserId, orgId, null);
        ArrayList<WFIVO> queryList = new ArrayList<WFIVO>();
        ArrayList<WFIVO> list = new ArrayList<WFIVO>();
        for (WFIVO vo : wfivoList) {
            String wfSignTmp = vo.getWfSign();
            String wfNameTmp = vo.getWfName();
            boolean isExist1 = false;
            boolean isExist2 = false;
            try {
                isExist1 = null == queryWfSign || "".equals(queryWfSign) ? true : wfSignTmp.contains(queryWfSign);
            }
            catch (Exception e) {
                isExist1 = true;
            }
            try {
                isExist2 = null == queryWfName || "".equals(queryWfName) ? true : wfNameTmp.contains(queryWfName);
            }
            catch (Exception e) {
                isExist2 = true;
            }
            if (!isExist1 || !isExist2) continue;
            queryList.add(vo);
        }
        if (queryList != null && queryList.size() > 0) {
            int size = queryList.size();
            int begin = 0;
            int end = 0;
            if (model.getPage() == 0) {
                list = queryList;
            } else if (size < model.getSize()) {
                list = queryList;
            } else {
                begin = (model.getPage() - 1) * model.getSize();
                end = model.getSize() * model.getPage() > size ? size : model.getSize() * model.getPage();
            }
            for (int i = begin; i < end; ++i) {
                WFIVO vo = (WFIVO)queryList.get(i);
                list.add(vo);
            }
        }
        ResultDto result = new ResultDto(list);
        result.setTotal((long)queryList.size());
        return result;
    }

    public List<WFIVO> getWFNameList(@RequestParam(value="sessionLoginCode") String currentuserid, @RequestParam(value="sessionOrgCode") String orgid, @RequestParam(value="sessionInstuCde") String instuCde) {
        String sysId = WFClientInstuCache.getInstance().getClientSign(instuCde);
        ArrayList<WFIVO> list = new ArrayList<WFIVO>();
        WorkFlowClient wfc = WorkFlowClient.getInstance();
        EVO evo = new EVO();
        evo.setCurrentUserID(currentuserid);
        evo.setOrgid(orgid);
        evo.setSysid(sysId);
        Vector wfList = wfc.getWFNameList(evo);
        for (int i = 0; i < wfList.size(); ++i) {
            EVO evoTmp = (EVO)wfList.elementAt(i);
            WFIVO wfivo = new WFIVO();
            wfivo.setWfId(evoTmp.getWFID());
            wfivo.setWfName(evoTmp.getWFName());
            wfivo.setWfSign(evoTmp.getWFSign());
            wfivo.setWfVer(evoTmp.getTip());
            wfivo.setWfAppId(evoTmp.getAppID());
            wfivo.setWfAppName(evoTmp.getAppName());
            wfivo.setWfmainformid(evoTmp.getWFMainForm());
            wfivo.setWfAdmin(evoTmp.getWFAdmin());
            wfivo.setWfReaders(evoTmp.getWFReaders());
            wfivo.setAuthor(evoTmp.getAuthor());
            list.add(wfivo);
        }
        return list;
    }

    @GetMapping(value={"/queryAllWfClient"})
    public ResultDto<List<WfClient>> queryAllWfClient(QueryModel model) {
        List<WfClient> wfClient = this.echainBenchService.queryWfClientInstuOption(model);
        return new ResultDto(wfClient);
    }

    @GetMapping(value={"/queryWfClientInstuOption"})
    public ResultDto<List<WfClient>> getWfClientInstuOption() {
        List<WfClient> wfClient = this.echainBenchService.queryWfClientInstuOption();
        return new ResultDto(wfClient);
    }

    @GetMapping(value={"/queryInstuOrgOption"})
    public ResultDto<List<AdminSmInstu>> getInstuOrgOption(QueryModel queryModel) {
        List<AdminSmInstu> list = this.echainBenchService.getInstuOrgOption(queryModel);
        return new ResultDto(list);
    }

    @GetMapping(value={"/queryWfClientInstuList"})
    public ResultDto<List<WfClientInstu>> getWfClientInstuList(QueryModel model) {
        List<WfClientInstu> wfClientInstu = this.echainBenchService.queryWfClientInstuList(model);
        for (WfClientInstu item : wfClientInstu) {
            AdminSmInstu adminSmInstu = this.echainBenchService.queryByInstuCde(item.getInstuCde());
            item.setAdminSmInstu(adminSmInstu);
        }
        return new ResultDto(wfClientInstu);
    }

    @PostMapping(value={"/updateWfClientInstu"})
    public ResultDto<Map<String, Object>> updateWfClientInstu(@RequestBody WfClientInstu wfClientInstu) {
        int i;
        HashMap<String, String> result = new HashMap<String, String>();
        String message = null;
        String flag = null;
        boolean canUpdate = true;
        QueryModel model = new QueryModel();
        model.getCondition().put("instuCde", wfClientInstu.getInstuCde());
        List<WfClientInstu> list = this.echainBenchService.queryWfClientInstuList(model);
        if (list.size() > 0) {
            flag = "error";
            message = "\u91d1\u878d\u673a\u6784\u5df2\u5b58\u5728";
            canUpdate = false;
        }
        if (canUpdate && (i = this.echainBenchService.updateByPrimaryKey(wfClientInstu)) > 0) {
            flag = "success";
            message = "\u4fee\u6539\u6210\u529f";
        }
        result.put("flag", flag);
        result.put("message", message);
        ResultDto resultDto = new ResultDto(result);
        resultDto.setMessage(message);
        return resultDto;
    }

    @PostMapping(value={"/addWfClientInstu"})
    public ResultDto<Map<String, Object>> addWfClientInstu(@RequestBody WfClientInstu wfClientInstu) {
        HashMap<String, String> map = new HashMap<String, String>();
        String message = null;
        String flag = null;
        List<WfClientInstu> list = this.echainBenchService.queryWfClientInstuDetail(wfClientInstu);
        if (list.size() > 0) {
            flag = "error";
            message = "\u6570\u636e\u5df2\u5b58\u5728";
        } else {
            Boolean result = this.echainBenchService.addWfClientInstu(wfClientInstu);
            if (result.booleanValue()) {
                flag = "success";
                message = "\u65b0\u589e\u6210\u529f";
            }
        }
        map.put("flag", flag);
        map.put("message", message);
        ResultDto resultDto = new ResultDto(map);
        resultDto.setMessage("\u65b0\u589e\u6210\u529f!");
        return resultDto;
    }

    @GetMapping(value={"/checkWfClientInstu"})
    public ResultDto<Map<String, Object>> checkWfClientInstu(QueryModel queryModel) {
        HashMap<String, String> map = new HashMap<String, String>();
        String flag = null;
        List<WfClientInstu> list = this.echainBenchService.queryWfClientInstuList(queryModel);
        flag = list.size() > 0 ? "no" : "ok";
        map.put("flag", flag);
        return new ResultDto(map);
    }

    @GetMapping(value={"/delete"})
    public ResultDto<Boolean> deleteWorkflowInfo(String bizNo) {
        this.echainBenchService.deleteWorkflowInfo(bizNo);
        return new ResultDto((Object)true);
    }
}

