/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.echain.server.util;

import com.ecc.echain.ext.FreeDate;
import com.ecc.echain.workflow.cache.WFCache;
import com.ecc.echain.workflow.model.VO_wf_node_property;
import com.ecc.echain.workflow.model.VO_wf_whole_property;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkFlowClientExt {
    private static final Logger LOGGER = LoggerFactory.getLogger(WorkFlowClientExt.class);
    private static WorkFlowClientExt thisObj;

    private WorkFlowClientExt() {
    }

    public static WorkFlowClientExt getInstance() {
        if (thisObj == null) {
            thisObj = new WorkFlowClientExt();
        }
        return thisObj;
    }

    public Object getWFNodeProperty(String nodeId, String key) {
        Field[] fields;
        Object value = null;
        if (nodeId == null || nodeId.trim().equals("") || key == null || key.trim().equals("")) {
            return null;
        }
        VO_wf_node_property nodeProperty = WFCache.getInstance().getNodeProperty(nodeId);
        for (Field field : fields = nodeProperty.getClass().getFields()) {
            String fieldName = field.getName();
            if (!fieldName.toLowerCase().equals(key.toLowerCase())) continue;
            try {
                value = field.get(nodeProperty);
                break;
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
        return value;
    }

    public Object getWFNodeExtProperty(String nodeId, String extKey) {
        Object value = null;
        if (nodeId == null || nodeId.trim().equals("") || extKey == null || extKey.trim().equals("")) {
            return null;
        }
        VO_wf_node_property nodeProperty = WFCache.getInstance().getNodeProperty(nodeId);
        Map extMap = nodeProperty.hmAppExtProperty;
        for (String keyTmp : extMap.keySet()) {
            if (!keyTmp.toLowerCase().equals(extKey.toLowerCase())) continue;
            value = extMap.get(keyTmp);
            break;
        }
        return value;
    }

    public String getWFExtPropertyByWfId(String wfid, String extKey) {
        String value = null;
        if (wfid == null || wfid.trim().equals("") || extKey == null || extKey.trim().equals("")) {
            return null;
        }
        VO_wf_whole_property wholeProperty = WFCache.getInstance().getCacheWFObj(wfid);
        Map extMap = wholeProperty.hmAppExtProperty;
        for (String keyTmp : extMap.keySet()) {
            if (!keyTmp.toLowerCase().equals(extKey.toLowerCase())) continue;
            value = (String)extMap.get(keyTmp);
            break;
        }
        return value;
    }

    public String getWFExtPropertyByWfSign(String wfsign, String key) {
        String value = null;
        if (wfsign == null || wfsign.trim().equals("") || key == null || key.trim().equals("")) {
            return null;
        }
        VO_wf_whole_property wholeProperty = WFCache.getInstance().getCacheWFObjByWFSign(wfsign);
        Map extMap = wholeProperty.hmAppExtProperty;
        for (String keyTmp : extMap.keySet()) {
            if (!keyTmp.toLowerCase().equals(key.toLowerCase())) continue;
            value = (String)extMap.get(keyTmp);
            break;
        }
        return value;
    }

    public Object getWFPropertyByWfId(String wfid, String key) {
        Field[] fields;
        Object value = null;
        if (wfid == null || wfid.trim().equals("") || key == null || key.trim().equals("")) {
            return null;
        }
        VO_wf_whole_property wholeProperty = WFCache.getInstance().getCacheWFObj(wfid);
        for (Field field : fields = wholeProperty.getClass().getFields()) {
            String fieldName = field.getName();
            if (!fieldName.toLowerCase().equals(key.toLowerCase())) continue;
            try {
                value = field.get(wholeProperty);
                break;
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
        return value;
    }

    public Object getWFPropertyByWfSign(String wfsign, String key) {
        Field[] fields;
        Object value = null;
        if (wfsign == null || wfsign.trim().equals("") || key == null || key.trim().equals("")) {
            return null;
        }
        VO_wf_whole_property wholeProperty = WFCache.getInstance().getCacheWFObjByWFSign(wfsign);
        for (Field field : fields = wholeProperty.getClass().getFields()) {
            String fieldName = field.getName();
            if (!fieldName.toLowerCase().equals(key.toLowerCase())) continue;
            try {
                value = field.get(wholeProperty);
                break;
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
        return value;
    }

    public List<Map<String, String>> getWFNodePropertysByProp(String keyName, String keyValue, String propKeysStr) {
        List<String> propKeys = Arrays.asList(propKeysStr.split(","));
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>();
        Map nodeCache = WFCache.getInstance().getHmWFNodeCache();
        ArrayList<String> keys = new ArrayList<String>();
        keys.add(keyName);
        keys.addAll(propKeys);
        Set entrySet = nodeCache.entrySet();
        for (Map.Entry entry : entrySet) {
            String nodeId = (String)entry.getKey();
            VO_wf_node_property nodeProperty = (VO_wf_node_property)entry.getValue();
            Map<String, String> propMap = this.getNodeProp(nodeProperty, keys);
            propMap.put("_nodeid", nodeId);
            String keyValueTemp = propMap.get(keyName);
            if (keyValueTemp == null || !keyValueTemp.equals(keyValue)) continue;
            result.add(propMap);
        }
        return result;
    }

    public String freeDateGetByYear(String year) {
        String freeDate = new FreeDate().getFreeDate(year);
        return freeDate;
    }

    public String freeDateInit(String year) {
        return new FreeDate().init(year);
    }

    public String freeDateSetFreeDate(String curDate) {
        return new FreeDate().setFreeDate(curDate);
    }

    public String freeDateSetWorkDate(String curDate) {
        return new FreeDate().setWorkDate(curDate);
    }

    private Map<String, String> getNodeProp(VO_wf_node_property nodeProperty, List<String> propKeys) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (propKeys == null) {
            return result;
        }
        Field[] fields = nodeProperty.getClass().getFields();
        for (String propKey : propKeys) {
            Object value = null;
            for (Field field : fields) {
                String fieldName = field.getName();
                if (!fieldName.toLowerCase().equals(propKey.toLowerCase())) continue;
                try {
                    value = field.get(nodeProperty);
                    break;
                }
                catch (Exception e) {
                    throw new RuntimeException("\u83b7\u53d6\u6d41\u7a0b\u8282\u70b9\u5c5e\u6027\u5931\u8d25[getWFNodeProperty]\u3002\u5f02\u5e38\u4fe1\u606f\u4e3a\uff1a" + e.getMessage(), e);
                }
            }
            if (value == null) {
                Map extMap = nodeProperty.hmAppExtProperty;
                for (String keyTmp : extMap.keySet()) {
                    if (!keyTmp.equalsIgnoreCase(propKey)) continue;
                    value = (String)extMap.get(keyTmp);
                    break;
                }
            }
            if (value == null) continue;
            result.put(propKey, value.toString());
        }
        return result;
    }
}

