/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.echain.server.service;

import cn.com.yusys.yusp.commons.mapper.QueryModel;
import cn.com.yusys.yusp.echain.server.domain.AdminSmDuty;
import cn.com.yusys.yusp.echain.server.domain.WfTaskpool;
import cn.com.yusys.yusp.echain.server.domain.WfTaskpoolConfig;
import cn.com.yusys.yusp.echain.server.repository.mapper.WfAdminSmDutyMapper;
import cn.com.yusys.yusp.echain.server.repository.mapper.WfTaskpoolConfigMapper;
import cn.com.yusys.yusp.echain.server.repository.mapper.WfTaskpoolMapper;
import com.ecc.echain.workflow.cache.WFClientInstuCache;
import com.github.pagehelper.PageHelper;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class EchainJoinTaskPoolService {
    public static final String SYSID_KEY = "sysid";
    @Autowired
    private WfTaskpoolMapper wfTaskpoolMapper;
    @Autowired
    private WfTaskpoolConfigMapper wfTaskpoolConfigMapper;
    @Autowired
    private WfAdminSmDutyMapper adminSmDutyMapper;

    public Boolean addWfTaskpool(WfTaskpool taskPool) {
        taskPool.setSysid(this.getSysidByRealInstuCde(taskPool.getSysid()));
        int insert = this.wfTaskpoolMapper.insertSelective(taskPool);
        return insert > 0;
    }

    public Boolean updateWfTaskpool(WfTaskpool taskPool) {
        taskPool.setSysid(this.getSysidByRealInstuCde(taskPool.getSysid()));
        int updateByPrimaryKey = this.wfTaskpoolMapper.updateByPrimaryKey(taskPool);
        return updateByPrimaryKey > 0;
    }

    public Boolean deleteWfTaskpool(String tpid) {
        this.wfTaskpoolConfigMapper.deleteByTpid(tpid);
        int deleteByPrimaryKey = this.wfTaskpoolMapper.deleteByPrimaryKey(tpid);
        return deleteByPrimaryKey > 0;
    }

    public List<WfTaskpool> queryWfTaskpoolList(String instuCde, QueryModel queryModel) {
        queryModel.getCondition().put(SYSID_KEY, this.getSysidByRealInstuCde(instuCde));
        PageHelper.startPage((int)queryModel.getPage(), (int)queryModel.getSize());
        List<WfTaskpool> taskpoolList = this.wfTaskpoolMapper.selectTaskpoolList(queryModel);
        PageHelper.clearPage();
        return taskpoolList;
    }

    public Boolean addWfTaskpoolConfig(WfTaskpoolConfig record) {
        int insert = this.wfTaskpoolConfigMapper.insert(record);
        return insert > 0;
    }

    public Boolean deleteWfTaskpoolConfig(Object tpid) {
        int deleteByDomain = this.wfTaskpoolConfigMapper.deleteByTpid(tpid);
        return deleteByDomain > 0;
    }

    public List<WfTaskpoolConfig> queryTaskpoolConfigList(QueryModel queryModel) {
        List<WfTaskpoolConfig> selectTaskpoolConfigList = this.wfTaskpoolConfigMapper.selectTaskpoolConfigList(queryModel);
        return selectTaskpoolConfigList;
    }

    protected String getSysidByRealInstuCde(String realInstuCde) {
        String clientSign = WFClientInstuCache.getInstance().getClientSign(realInstuCde);
        return clientSign;
    }

    public List<AdminSmDuty> queryAllDutysQry(QueryModel queryModel, String instuCde) {
        queryModel.getCondition().put("instuCde", instuCde);
        List<AdminSmDuty> list = this.adminSmDutyMapper.selectAllDutysQry(queryModel);
        return list;
    }
}

