/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.echain.server.service;

import cn.com.yusys.yusp.echain.server.exception.EchainException;
import cn.com.yusys.yusp.echain.server.service.EchainCoreMessageService;
import cn.com.yusys.yusp.echain.server.util.WorkFlowClientExt;
import com.ecc.echain.util.WfPropertyManager;
import com.ecc.echain.workflow.cache.WFClientInstuCache;
import com.ecc.echain.workflow.engine.EVO;
import com.ecc.echain.workflow.engine.WorkFlowClient;
import com.ecc.echain.workflow.model.CommentVO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class EchainCoreComponent {
    private static final Logger LOGGER = LoggerFactory.getLogger(EchainCoreComponent.class);
    private static final String SYSID_KEY = "sysid";
    private WorkFlowClient wfc = WorkFlowClient.getInstance();
    private WorkFlowClientExt wfcExt = WorkFlowClientExt.getInstance();
    @Autowired
    private EchainCoreMessageService messageService;

    public EVO initializeWFWholeDocUNID(String instuCde, EVO paramEVO) {
        EVO retEVO = null;
        try {
            if (!this.checkInstu4WF(instuCde, paramEVO.getWFSign())) {
                String instuSysid = WFClientInstuCache.getInstance().getClientSign(instuCde);
                Object wfSysid = this.wfcExt.getWFPropertyByWfSign(paramEVO.getWFSign(), SYSID_KEY);
                throw new EchainException("\u6d41\u7a0b(" + paramEVO.getWFSign() + ")\u7684\u6240\u5c5e\u7cfb\u7edf(" + wfSysid + ")\u4e0e\u5f53\u524d\u91d1\u878d\u673a\u6784(" + instuCde + ")\u5bf9\u5e94\u7684\u7cfb\u7edf(" + instuSysid + ")\u4e0d\u4e00\u81f4!");
            }
            paramEVO.setSysid(this.getSysidByRealInstuCde(instuCde));
            retEVO = this.wfc.initializeWFWholeDocUNID(paramEVO);
            this.messageService.sendMessage("init", true, retEVO);
        }
        catch (Exception e) {
            throw new EchainException(e);
        }
        return retEVO;
    }

    public EVO wfSaveJob(EVO paramEVO) {
        EVO retEVO = null;
        try {
            retEVO = this.wfc.wfSaveJob(paramEVO);
        }
        catch (Exception e) {
            throw new EchainException(e);
        }
        return retEVO;
    }

    public EVO wfCompleteJob(EVO paramEVO) {
        EVO retEVO = null;
        try {
            String flag = "submit";
            String nextNodeId = paramEVO.getNextNodeID();
            if (null != nextNodeId) {
                if ("e0000".equals(nextNodeId)) {
                    paramEVO.setSPStatus("2");
                    flag = "refuse";
                } else if (nextNodeId.contains("e")) {
                    flag = "end";
                    paramEVO.setSPStatus("1");
                }
            }
            retEVO = this.wfc.wfCompleteJob(paramEVO);
            retEVO.paramMap = paramEVO.paramMap;
            this.messageService.sendMessage(flag, true, retEVO);
        }
        catch (Exception e) {
            throw new EchainException(e);
        }
        return retEVO;
    }

    public EVO wfUrge(EVO paramEVO) {
        EVO retEVO = null;
        try {
            retEVO = this.wfc.wfUrge(paramEVO);
        }
        catch (Exception e) {
            throw new EchainException(e);
        }
        return retEVO;
    }

    public EVO instanceSignIn(EVO paramEVO) {
        EVO retEVO = null;
        try {
            retEVO = this.wfc.instanceSignIn(paramEVO);
            this.messageService.sendMessage("signIn", true, retEVO);
        }
        catch (Exception e) {
            throw new EchainException(e);
        }
        return retEVO;
    }

    public EVO instanceSignOff(EVO paramEVO) {
        EVO retEVO = null;
        try {
            retEVO = this.wfc.instanceSignOff(paramEVO);
            this.messageService.sendMessage("signOff", true, retEVO);
        }
        catch (Exception e) {
            throw new EchainException(e);
        }
        return retEVO;
    }

    public EVO getChangeUser(EVO paramEVO) {
        EVO retEVO = null;
        try {
            retEVO = this.wfc.getChangeUser(paramEVO);
        }
        catch (Exception e) {
            throw new EchainException(e);
        }
        return retEVO;
    }

    public EVO wfChange(EVO paramEVO) {
        EVO retEVO = null;
        try {
            retEVO = this.wfc.wfChange(paramEVO);
            retEVO.paramMap = paramEVO.paramMap;
            this.messageService.sendMessage("change", true, retEVO);
        }
        catch (Exception e) {
            throw new EchainException(e);
        }
        return retEVO;
    }

    public Map getWFNodeList(EVO paramEVO) {
        HashMap wfNodeList = null;
        try {
            wfNodeList = this.wfc.getWFNodeList(paramEVO);
        }
        catch (Exception e) {
            throw new EchainException(e);
        }
        return wfNodeList;
    }

    public List getWFTreatedNodeList(EVO paramEVO) {
        List wfTreatedNodeList = null;
        try {
            wfTreatedNodeList = this.wfc.getWFTreatedNodeList(paramEVO);
        }
        catch (Exception e) {
            throw new EchainException(e);
        }
        return wfTreatedNodeList;
    }

    public EVO wfJump(EVO paramEVO) {
        EVO retEVO = null;
        try {
            retEVO = this.wfc.wfJump(paramEVO);
            retEVO.paramMap = paramEVO.paramMap;
            this.messageService.sendMessage("jump", true, retEVO);
        }
        catch (Exception e) {
            throw new EchainException(e);
        }
        return retEVO;
    }

    public EVO wfEnd(EVO paramEVO) {
        EVO retEVO = null;
        try {
            retEVO = this.wfc.wfEnd(paramEVO);
            this.messageService.sendMessage("end", true, retEVO);
        }
        catch (Exception e) {
            throw new EchainException(e);
        }
        return retEVO;
    }

    public EVO wfReturnBack(EVO paramEVO) {
        EVO retEVO = null;
        try {
            boolean wfReturnBackPlus = WfPropertyManager.getInstance().wfReturnBackPlus;
            retEVO = wfReturnBackPlus ? this.wfc.wfRetrunBackPlus(paramEVO) : this.wfc.wfReturnBack(paramEVO);
            String nextNodeId = retEVO.getNodeID();
            if (null != nextNodeId) {
                boolean isFirstNode = (Boolean)this.wfcExt.getWFNodeProperty(nextNodeId, "isFirstNode");
                if (isFirstNode) {
                    paramEVO.paramMap.put("isFirstNode", "1");
                } else {
                    paramEVO.paramMap.put("isFirstNode", "0");
                }
            }
            this.messageService.sendMessage("returnBack", true, paramEVO);
        }
        catch (Exception e) {
            throw new EchainException(e);
        }
        return retEVO;
    }

    public EVO wfCallBack(EVO paramEVO) {
        EVO retEVO = null;
        try {
            retEVO = this.wfc.wfCallBack(paramEVO);
            String nextNodeId = retEVO.getNextNodeID();
            boolean isFirstNode = (Boolean)this.wfcExt.getWFNodeProperty(nextNodeId, "isFirstNode");
            if (isFirstNode) {
                paramEVO.paramMap.put("isFirstNode", "1");
            } else {
                paramEVO.paramMap.put("isFirstNode", "0");
            }
            this.messageService.sendMessage("callBack", true, paramEVO);
        }
        catch (Exception e) {
            throw new EchainException(e);
        }
        return retEVO;
    }

    public EVO wfTakeBack(EVO paramEVO) {
        EVO retEVO = null;
        try {
            retEVO = this.wfc.wfTakeBack(paramEVO);
            retEVO.setInstanceID(paramEVO.getInstanceID());
            retEVO.setNodeID(paramEVO.getNodeID());
            String nextNodeId = retEVO.getNextNodeID();
            boolean isFirstNode = (Boolean)this.wfcExt.getWFNodeProperty(nextNodeId, "isFirstNode");
            if (isFirstNode) {
                paramEVO.paramMap.put("isFirstNode", "1");
            } else {
                paramEVO.paramMap.put("isFirstNode", "0");
            }
            this.messageService.sendMessage("takeBack", true, retEVO);
        }
        catch (Exception e) {
            throw new EchainException(e);
        }
        return retEVO;
    }

    public EVO wfJump2First(EVO paramEVO) {
        EVO retEVO = null;
        try {
            retEVO = this.wfc.wfJump2First(paramEVO);
            paramEVO.paramMap.put("isFirstNode", "1");
        }
        catch (Exception e) {
            throw new EchainException(e);
        }
        return retEVO;
    }

    public EVO wfCancel(EVO paramEVO) {
        EVO retEVO = null;
        try {
            retEVO = this.wfc.wfCancel(paramEVO);
            this.messageService.sendMessage("cancel", true, retEVO);
        }
        catch (Exception e) {
            throw new EchainException(e);
        }
        return retEVO;
    }

    public EVO wfHang(EVO paramEVO) {
        EVO retEVO = null;
        try {
            retEVO = this.wfc.wfHang(paramEVO);
            retEVO.setInstanceID(paramEVO.getInstanceID());
            retEVO.setNodeID(paramEVO.getNodeID());
            this.messageService.sendMessage("hang", true, retEVO);
        }
        catch (Exception e) {
            throw new EchainException(e);
        }
        return retEVO;
    }

    public EVO wfWake(EVO paramEVO) {
        EVO retEVO = null;
        try {
            retEVO = this.wfc.wfWake(paramEVO);
            retEVO.setInstanceID(paramEVO.getInstanceID());
            retEVO.setNodeID(paramEVO.getNodeID());
            this.messageService.sendMessage("wake", true, retEVO);
        }
        catch (Exception e) {
            throw new EchainException(e);
        }
        return retEVO;
    }

    public EVO wfWithdrawUser(EVO paramEVO) {
        EVO retEVO = null;
        try {
            retEVO = this.wfc.wfWithdrawUser(paramEVO);
        }
        catch (Exception e) {
            throw new EchainException(e);
        }
        return retEVO;
    }

    public EVO wfDelInstance(EVO paramEVO) {
        EVO retEVO = null;
        try {
            retEVO = this.wfc.wfDelInstance(paramEVO);
        }
        catch (Exception e) {
            throw new EchainException(e);
        }
        return retEVO;
    }

    public EVO wfAssist(EVO paramEVO) {
        EVO retEVO = null;
        try {
            retEVO = this.wfc.wfAssist(paramEVO);
        }
        catch (Exception e) {
            throw new EchainException(e);
        }
        return retEVO;
    }

    public EVO getNextNodeList(EVO paramEVO) {
        EVO retEVO = null;
        try {
            retEVO = this.wfc.getNextNodeList(paramEVO);
        }
        catch (Exception e) {
            throw new EchainException(e);
        }
        return retEVO;
    }

    public EVO getNodeUserList(EVO paramEVO) {
        EVO retEVO = null;
        try {
            retEVO = this.wfc.getNodeUserList(paramEVO);
        }
        catch (Exception e) {
            throw new EchainException(e);
        }
        return retEVO;
    }

    public EVO getAnnounceUserList(EVO paramEVO) {
        EVO retEVO = null;
        try {
            retEVO = this.wfc.getAnnounceUserList(paramEVO);
        }
        catch (Exception e) {
            throw new EchainException(e);
        }
        return retEVO;
    }

    public List<CommentVO> getAllComments(EVO paramEVO) {
        ArrayList<CommentVO> comments = null;
        try {
            Vector commentsVector = this.wfc.getAllComments(paramEVO);
            comments = new ArrayList<CommentVO>(commentsVector);
        }
        catch (Exception e) {
            throw new EchainException(e);
        }
        return comments;
    }

    public EVO getInstanceInfo(EVO paramEVO) {
        EVO retEVO = null;
        try {
            retEVO = this.wfc.getInstanceInfo(paramEVO);
        }
        catch (Exception e) {
            throw new EchainException(e);
        }
        return retEVO;
    }

    public EVO getInstanceNodeUserList(EVO paramEVO) {
        EVO retEVO = null;
        try {
            retEVO = this.wfc.getInstanceNodeUserList(paramEVO);
        }
        catch (Exception e) {
            throw new EchainException(e);
        }
        return retEVO;
    }

    public boolean setComment(EVO paramEVO) {
        boolean retData = false;
        try {
            retData = this.wfc.setComment(paramEVO);
        }
        catch (Exception e) {
            throw new EchainException(e);
        }
        return retData;
    }

    public List<EVO> getWFNameList(String instuCde, EVO paramEVO) {
        ArrayList<EVO> wfNameList = null;
        try {
            paramEVO.setSysid(this.getSysidByRealInstuCde(instuCde));
            Vector NameVvector = this.wfc.getWFNameList(paramEVO);
            wfNameList = new ArrayList<EVO>(NameVvector);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new EchainException(e);
        }
        return wfNameList;
    }

    public List<EVO> getWorkFlowHistory(EVO paramEVO) {
        ArrayList<EVO> historyList = null;
        try {
            Vector workFlowHistory = this.wfc.getWorkFlowHistory(paramEVO);
            historyList = new ArrayList<EVO>(workFlowHistory);
        }
        catch (Exception e) {
            throw new EchainException(e);
        }
        return historyList;
    }

    public EVO synSubFlowSetSubmit(String instuCde, EVO paramEVO) {
        EVO retEVO = null;
        try {
            String wfSign = (String)this.getWFPropertyByWfId(paramEVO.getWFID(), "WFSign");
            if (!this.checkInstu4WF(instuCde, wfSign)) {
                String instuSysid = WFClientInstuCache.getInstance().getClientSign(instuCde);
                Object wfSysid = this.wfcExt.getWFPropertyByWfSign(paramEVO.getWFSign(), SYSID_KEY);
                throw new EchainException("\u5b50\u6d41\u7a0b\u6807\u8bc6(" + wfSign + ")\u7684\u6240\u5c5e\u7cfb\u7edf(" + wfSysid + ")\u4e0e\u5f53\u524d\u91d1\u878d\u673a\u6784(" + instuCde + ")\u5bf9\u5e94\u7684\u7cfb\u7edf(" + instuSysid + ")\u4e0d\u4e00\u81f4!");
            }
            paramEVO.setSysid(this.getSysidByRealInstuCde(instuCde));
            retEVO = this.wfc.synSubFlowSetSubmit(paramEVO);
        }
        catch (Exception e) {
            throw new EchainException(e);
        }
        return retEVO;
    }

    public EVO asynSubFlowSetSubmit(String instuCde, EVO paramEVO) {
        EVO retEVO = null;
        try {
            String wfSign = (String)this.getWFPropertyByWfId(paramEVO.getWFID(), "WFSign");
            if (!this.checkInstu4WF(instuCde, wfSign)) {
                String instuSysid = WFClientInstuCache.getInstance().getClientSign(instuCde);
                Object wfSysid = this.wfcExt.getWFPropertyByWfSign(paramEVO.getWFSign(), SYSID_KEY);
                throw new EchainException("\u5b50\u6d41\u7a0b\u6807\u8bc6(" + wfSign + ")\u7684\u6240\u5c5e\u7cfb\u7edf(" + wfSysid + ")\u4e0e\u5f53\u524d\u91d1\u878d\u673a\u6784(" + instuCde + ")\u5bf9\u5e94\u7684\u7cfb\u7edf(" + instuSysid + ")\u4e0d\u4e00\u81f4!");
            }
            paramEVO.setSysid(this.getSysidByRealInstuCde(instuCde));
            EVO paramEVOT = new EVO();
            paramEVOT.setInstanceID(paramEVO.getInstanceID());
            EVO instanceInfo = this.wfc.getInstanceInfo(paramEVOT);
            String bizSeqNo = instanceInfo.getBizseqno();
            String custID = instanceInfo.getCustID();
            String custName = instanceInfo.getCustName();
            paramEVO.setBizseqno(bizSeqNo);
            paramEVO.setCustID(custID);
            paramEVO.setCustName(custName);
            retEVO = this.wfc.asynSubFlowSetSubmit(paramEVO);
        }
        catch (Exception e) {
            throw new EchainException(e);
        }
        return retEVO;
    }

    public EVO setSPStatus(EVO paramEVO) {
        EVO retEVO = null;
        try {
            retEVO = this.wfc.setSPStatus(paramEVO);
        }
        catch (Exception e) {
            throw new EchainException(e);
        }
        return retEVO;
    }

    public String getWorkFlowVersion() {
        String retData = null;
        try {
            retData = this.wfc.getWorkFlowVersion();
        }
        catch (Exception e) {
            throw new EchainException(e);
        }
        return retData;
    }

    public EVO resetUrgentTreat(EVO paramEVO) {
        EVO retEVO = null;
        try {
            retEVO = this.wfc.resetUrgentTreat(paramEVO);
        }
        catch (Exception e) {
            throw new EchainException(e);
        }
        return retEVO;
    }

    public EVO taskSignIn(EVO paramEVO) {
        EVO retEVO = null;
        try {
            retEVO = this.wfc.taskSignIn(paramEVO);
        }
        catch (Exception e) {
            throw new EchainException(e);
        }
        return retEVO;
    }

    public EVO taskSignOff(EVO paramEVO) {
        EVO retEVO = null;
        try {
            retEVO = this.wfc.taskSignOff(paramEVO);
        }
        catch (Exception e) {
            throw new EchainException(e);
        }
        return retEVO;
    }

    public EVO resetCurrentNodeUser(EVO paramEVO) {
        EVO retEVO = null;
        try {
            retEVO = this.wfc.resetCurrentNodeUser(paramEVO);
        }
        catch (Exception e) {
            throw new EchainException(e);
        }
        return retEVO;
    }

    public Object getWFNodeProperty(String nodeId, String key) {
        Object rtData = null;
        try {
            rtData = this.wfcExt.getWFNodeProperty(nodeId, key);
        }
        catch (Exception e) {
            throw new EchainException(e);
        }
        return rtData;
    }

    public Object getWFNodeExtProperty(String nodeId, String extKey) {
        Object rtData = null;
        try {
            rtData = this.wfcExt.getWFNodeExtProperty(nodeId, extKey);
        }
        catch (Exception e) {
            throw new EchainException(e);
        }
        return rtData;
    }

    public String getWFExtPropertyByWfId(String wfid, String extKey) {
        String rtData = null;
        try {
            rtData = this.wfcExt.getWFExtPropertyByWfId(wfid, extKey);
        }
        catch (Exception e) {
            throw new EchainException(e);
        }
        return rtData;
    }

    public String getWFExtPropertyByWfSign(String wfsign, String key) {
        String rtData = null;
        try {
            rtData = this.wfcExt.getWFExtPropertyByWfSign(wfsign, key);
        }
        catch (Exception e) {
            throw new EchainException(e);
        }
        return rtData;
    }

    public Object getWFPropertyByWfId(String wfid, String key) {
        Object rtData = null;
        try {
            rtData = this.wfcExt.getWFPropertyByWfId(wfid, key);
        }
        catch (Exception e) {
            throw new EchainException(e);
        }
        return rtData;
    }

    public Object getWFPropertyByWfSign(String wfsign, String key) {
        Object rtData = null;
        try {
            rtData = this.wfcExt.getWFPropertyByWfSign(wfsign, key);
        }
        catch (Exception e) {
            throw new EchainException(e);
        }
        return rtData;
    }

    public List<Map<String, String>> getWFNodePropertysByProp(String keyName, String keyValue, String propKeysStr) {
        List<Map<String, String>> rtData = null;
        try {
            rtData = this.wfcExt.getWFNodePropertysByProp(keyName, keyValue, propKeysStr);
        }
        catch (Exception e) {
            throw new EchainException(e);
        }
        return rtData;
    }

    public String freeDateGetByYear(String year) {
        String rtData = null;
        try {
            rtData = this.wfcExt.freeDateGetByYear(year);
        }
        catch (Exception e) {
            throw new EchainException(e);
        }
        return rtData;
    }

    public String freeDateInit(String year) {
        String rtData = null;
        try {
            rtData = this.wfcExt.freeDateInit(year);
        }
        catch (Exception e) {
            throw new EchainException(e);
        }
        return rtData;
    }

    public String freeDateSetFreeDate(String curDate) {
        String rtData = null;
        try {
            rtData = this.wfcExt.freeDateSetFreeDate(curDate);
        }
        catch (Exception e) {
            throw new EchainException(e);
        }
        return rtData;
    }

    public String freeDateSetWorkDate(String curDate) {
        String rtData = null;
        try {
            rtData = this.wfcExt.freeDateSetWorkDate(curDate);
        }
        catch (Exception e) {
            throw new EchainException(e);
        }
        return rtData;
    }

    protected String getSysidByRealInstuCde(String realInstuCde) {
        String clientSign = WFClientInstuCache.getInstance().getClientSign(realInstuCde);
        return clientSign;
    }

    protected boolean checkInstu4WF(String realInstuCde, String wfsign) {
        String clientSign = WFClientInstuCache.getInstance().getClientSign(realInstuCde);
        Object sysid = this.wfcExt.getWFPropertyByWfSign(wfsign, SYSID_KEY);
        if (clientSign == null || sysid == null) {
            return false;
        }
        return sysid.toString().equals(clientSign);
    }
}

