/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.echain.server.echain.organization;

import cn.com.yusys.yusp.echain.server.echain.EChainRuntimeContext;
import cn.com.yusys.yusp.echain.server.echain.organization.SqlUtil;
import com.ecc.echain.org.OrgIF;
import com.ecc.echain.org.model.DepModel;
import com.ecc.echain.org.model.GroupModel;
import com.ecc.echain.org.model.OrgModel;
import com.ecc.echain.org.model.RoleModel;
import com.ecc.echain.org.model.UserModel;
import com.ecc.echain.workflow.cache.OUCache;
import com.ecc.echain.workflow.model.WFClient;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;

public class YuspOrgImpl
implements OrgIF {
    private static final Logger LOGGER = LoggerFactory.getLogger(YuspOrgImpl.class);

    public OrgModel getRootOrg(Connection con) {
        LOGGER.error("\u65b9\u6cd5[getRootOrg]\u6ca1\u6709\u505a\u5b9e\u73b0");
        return null;
    }

    public List getAllBaseOrgs(Connection con) {
        ArrayList list = new ArrayList();
        LOGGER.error("\u65b9\u6cd5[getAllBaseOrgs]\u6ca1\u6709\u505a\u5b9e\u73b0");
        return list;
    }

    public List getDirectSubOrgs(String orgid, Connection con) {
        ArrayList<OrgModel> list = new ArrayList<OrgModel>();
        try {
            String instuCde = this.getCurrentInstuCde();
            PreparedStatement ps = con.prepareStatement("SELECT T0.* FROM ADMIN_SM_ORG T0 JOIN ADMIN_SM_INSTU T1 ON(T0.INSTU_ID=T1.INSTU_ID) WHERE T1.INSTU_CDE=? AND T0.UP_ORG_ID=?");
            ps.setString(1, instuCde);
            ps.setString(2, orgid);
            ResultSet rs = ps.executeQuery();
            List<Map<String, String>> datas = SqlUtil.rsToStrMap(rs);
            rs.close();
            ps.close();
            if (datas != null) {
                for (Map<String, String> org : datas) {
                    OrgModel orgModel = this.toOrgModel(org);
                    list.add(orgModel);
                }
            }
        }
        catch (Exception e1) {
            LOGGER.error(e1.getMessage(), (Throwable)e1);
        }
        return list;
    }

    public List getAllSubOrgs(String orgid, Connection con) {
        ArrayList<OrgModel> list = new ArrayList<OrgModel>();
        try {
            String instuCde = this.getCurrentInstuCde();
            PreparedStatement ps = con.prepareStatement("SELECT T0.* FROM (SELECT * FROM ADMIN_SM_ORG START WITH ORG_CODE=? CONNECT BY NOCYCLE PRIOR ORG_ID=UP_ORG_ID) T0 JOIN ADMIN_SM_INSTU T1 ON(T0.INSTU_ID=T1.INSTU_ID) WHERE T0.ORG_CODE <> ? AND T1.INSTU_CDE=? ORDER BY T0.ORG_LEVEL,T0.ORG_CODE");
            ps.setString(1, orgid);
            ps.setString(2, orgid);
            ps.setString(3, instuCde);
            ResultSet rs = ps.executeQuery();
            List<Map<String, String>> datas = SqlUtil.rsToStrMap(rs);
            rs.close();
            ps.close();
            if (datas != null && !datas.isEmpty()) {
                for (Map<String, String> org : datas) {
                    OrgModel orgModel = this.toOrgModel(org);
                    list.add(orgModel);
                }
            }
        }
        catch (Exception e1) {
            LOGGER.error(e1.getMessage(), (Throwable)e1);
        }
        return list;
    }

    public OrgModel getParentOrg(String orgid, Connection con) {
        OrgModel supOrgModel = null;
        try {
            String instuCde = this.getCurrentInstuCde();
            PreparedStatement ps = con.prepareStatement("SELECT T0.* FROM ADMIN_SM_ORG T0 JOIN ADMIN_SM_INSTU T1 ON(T0.INSTU_ID=T1.INSTU_ID) WHERE T1.INSTU_CDE=? AND T0.ORG_ID=(SELECT UP_ORG_ID FROM ADMIN_SM_ORG WHERE ORG_CODE=?)");
            ps.setString(1, instuCde);
            ps.setString(2, orgid);
            ResultSet rs = ps.executeQuery();
            List<Map<String, String>> datas = SqlUtil.rsToStrMap(rs);
            rs.close();
            ps.close();
            if (null != datas && !datas.isEmpty()) {
                supOrgModel = this.toOrgModel(datas.get(0));
            }
        }
        catch (Exception e1) {
            LOGGER.error(e1.getMessage(), (Throwable)e1);
        }
        return supOrgModel;
    }

    public OrgModel getOrgModel(String orgid, Connection con) {
        OrgModel model = new OrgModel();
        try {
            String instuCde = this.getCurrentInstuCde();
            PreparedStatement ps = con.prepareStatement("SELECT T0.* FROM ADMIN_SM_ORG T0 JOIN ADMIN_SM_INSTU T1 ON(T0.INSTU_ID=T1.INSTU_ID) WHERE T1.INSTU_CDE=? AND T0.ORG_CODE=?");
            ps.setString(1, instuCde);
            ps.setString(2, orgid);
            ResultSet rs = ps.executeQuery();
            List<Map<String, String>> datas = SqlUtil.rsToStrMap(rs);
            rs.close();
            ps.close();
            if (null != datas && !datas.isEmpty()) {
                model = this.toOrgModel(datas.get(0));
            }
        }
        catch (Exception e1) {
            LOGGER.error(e1.getMessage(), (Throwable)e1);
        }
        return model;
    }

    public List getAllOrgs(Connection con) {
        ArrayList<OrgModel> list = new ArrayList<OrgModel>();
        try {
            String instuCde = this.getCurrentInstuCde();
            PreparedStatement ps = con.prepareStatement("SELECT T0.* FROM ADMIN_SM_ORG T0 JOIN ADMIN_SM_INSTU T1 ON(T0.INSTU_ID=T1.INSTU_ID) WHERE T1.INSTU_CDE=? ORDER BY ORG_LEVEL,ORG_CODE");
            ps.setString(1, instuCde);
            ResultSet rs = ps.executeQuery();
            List<Map<String, String>> datas = SqlUtil.rsToStrMap(rs);
            if (datas != null && !datas.isEmpty()) {
                for (Map<String, String> org : datas) {
                    OrgModel orgModel = this.toOrgModel(org);
                    list.add(orgModel);
                }
            }
            rs.close();
            ps.close();
        }
        catch (Exception e1) {
            LOGGER.error(e1.getMessage(), (Throwable)e1);
        }
        System.out.println(list);
        return list;
    }

    public List getDirectDepsByOrg(String orgid, Connection con) {
        LOGGER.error("\u65b9\u6cd5[getDirectDepsByOrg]\u6ca1\u6709\u505a\u5b9e\u73b0");
        return new ArrayList();
    }

    public List getAllDepsByOrg(String orgid, Connection con) {
        LOGGER.error("\u65b9\u6cd5[getAllDepsByOrg]\u6ca1\u6709\u505a\u5b9e\u73b0");
        return new ArrayList();
    }

    public List getDirectSubDepsByDep(String orgid, String depid, Connection con) {
        LOGGER.error("\u65b9\u6cd5[getDirectSubDepsByDep]\u6ca1\u6709\u505a\u5b9e\u73b0");
        return new ArrayList();
    }

    public List getAllSubDepsByDep(String orgid, String depid, Connection con) {
        LOGGER.error("\u65b9\u6cd5[getAllSubDepsByDep]\u6ca1\u6709\u505a\u5b9e\u73b0");
        return new ArrayList();
    }

    public DepModel getParentDep(String orgid, String depid, Connection con) {
        LOGGER.error("\u65b9\u6cd5[getParentDep]\u6ca1\u6709\u505a\u5b9e\u73b0");
        return null;
    }

    public DepModel getDepModel(String orgid, String depid, Connection con) {
        LOGGER.error("\u65b9\u6cd5[getDepModel]\u6ca1\u6709\u505a\u5b9e\u73b0");
        return null;
    }

    public List getDirectUsersByOrg(String orgid, Connection con) {
        ArrayList<UserModel> list = new ArrayList<UserModel>();
        try {
            String instuCde = this.getCurrentInstuCde();
            PreparedStatement ps = con.prepareStatement("SELECT T0.* FROM ADMIN_SM_USER T0 JOIN ADMIN_SM_ORG T1 ON(T0.ORG_ID=T1.ORG_ID) JOIN ADMIN_SM_INSTU T2 ON(T1.INSTU_ID=T2.INSTU_ID) WHERE T0.USER_STS='A' AND T2.INSTU_CDE=? AND T1.ORG_CODE=?");
            ps.setString(1, instuCde);
            ps.setString(2, orgid);
            ResultSet rs = ps.executeQuery();
            List<Map<String, String>> datas = SqlUtil.rsToStrMap(rs);
            if (datas != null && !datas.isEmpty()) {
                for (Map<String, String> user : datas) {
                    UserModel userModel = this.toUserModel(user);
                    list.add(userModel);
                }
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return list;
    }

    public List getAllUsersByOrg(String orgid, Connection con) {
        ArrayList<UserModel> list = new ArrayList<UserModel>();
        try {
            String instuCde = this.getCurrentInstuCde();
            PreparedStatement ps = con.prepareStatement("SELECT T0.* FROM ADMIN_SM_USER T0 JOIN ADMIN_SM_ORG T1 ON(T0.ORG_ID=T1.ORG_ID) JOIN ADMIN_SM_INSTU T2 ON(T1.INSTU_ID=T2.INSTU_ID) WHERE T0.USER_STS='A' AND  T2.INSTU_CDE=? AND T1.ORG_CODE=?");
            ps.setString(1, instuCde);
            ps.setString(2, orgid);
            ResultSet rs = ps.executeQuery();
            List<Map<String, String>> datas = SqlUtil.rsToStrMap(rs);
            if (datas != null && !datas.isEmpty()) {
                for (Map<String, String> user : datas) {
                    UserModel userModel = this.toUserModel(user);
                    list.add(userModel);
                }
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return list;
    }

    public List getDirectUsersByDep(String orgid, String depid, Connection con) {
        LOGGER.error("\u65b9\u6cd5[getDirectUsersByDep]\u6ca1\u6709\u505a\u5b9e\u73b0");
        return new ArrayList();
    }

    public List getAllUsersByDep(String orgid, String depid, Connection con) {
        LOGGER.error("\u65b9\u6cd5[getAllUsersByDep]\u6ca1\u6709\u505a\u5b9e\u73b0");
        return new ArrayList();
    }

    public UserModel getUserModel(String orgid, String userid, Connection con) {
        return this.getUserModel(userid, con);
    }

    public UserModel getUserModel(String userid, Connection con) {
        UserModel userModel = null;
        try {
            String instuCde = this.getCurrentInstuCde();
            PreparedStatement ps = con.prepareStatement("SELECT T0.* FROM ADMIN_SM_USER T0 JOIN ADMIN_SM_ORG T1 ON(T0.ORG_ID=T1.ORG_ID) JOIN ADMIN_SM_INSTU T2 ON(T1.INSTU_ID=T2.INSTU_ID) WHERE T2.INSTU_CDE=? AND T0.LOGIN_CODE=?");
            ps.setString(1, instuCde);
            ps.setString(2, userid);
            ResultSet rs = ps.executeQuery();
            List<Map<String, String>> datas = SqlUtil.rsToStrMap(rs);
            if (datas != null && !datas.isEmpty()) {
                userModel = this.toUserModel(datas.get(0));
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return userModel;
    }

    public String getOrgIdByUser(String userid, Connection con) {
        String orgid = null;
        if (this.getSignUser().equals(userid) || userid.startsWith("T.")) {
            return orgid;
        }
        try {
            String instuCde = this.getCurrentInstuCde();
            PreparedStatement ps = con.prepareStatement("SELECT T1.ORG_CODE FROM ADMIN_SM_USER T0 JOIN ADMIN_SM_ORG T1 ON(T0.ORG_ID=T1.ORG_ID) JOIN ADMIN_SM_INSTU T2 ON(T1.INSTU_ID=T2.INSTU_ID) WHERE T2.INSTU_CDE=? AND T0.LOGIN_CODE=?");
            ps.setString(1, instuCde);
            ps.setString(2, userid);
            ResultSet rs = ps.executeQuery();
            List<Map<String, String>> datas = SqlUtil.rsToStrMap(rs);
            if (datas != null && !datas.isEmpty()) {
                orgid = datas.get(0).get("ORG_CODE");
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return orgid;
    }

    public UserModel isValidUser(String orgid, String userid, String password, Connection con) {
        Map userInfoMap;
        BCryptPasswordEncoder passwordEncoder;
        boolean matches;
        UserModel model = null;
        List<Object> datas = new ArrayList();
        try {
            PreparedStatement ps = con.prepareStatement("SELECT T0.*,T1.ORG_CODE FROM ADMIN_SM_USER T0 JOIN ADMIN_SM_ORG T1 ON(T0.ORG_ID=T1.ORG_ID) WHERE T0.LOGIN_CODE=?");
            ps.setString(1, userid);
            ResultSet rs = ps.executeQuery();
            datas = SqlUtil.rsToStrMap(rs);
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        if (datas != null && !datas.isEmpty() && (matches = (passwordEncoder = new BCryptPasswordEncoder()).matches((CharSequence)password, (String)(userInfoMap = (Map)datas.get(0)).get("USER_PASSWORD")))) {
            model = this.toUserModel(userInfoMap);
            model.setUserstatus(1);
            model.setAdminflag(true);
            model.setWfadminflag(true);
            model.setSaflag(true);
            model.setPassword(password);
        }
        return model;
    }

    public List getOrgLeaders(String orgid, Connection con) {
        LOGGER.error("\u65b9\u6cd5[getOrgLeaders]\u6ca1\u6709\u505a\u5b9e\u73b0");
        return new ArrayList();
    }

    public List getOrgDirectors(String orgid, Connection con) {
        LOGGER.error("\u65b9\u6cd5[getOrgDirectors]\u6ca1\u6709\u505a\u5b9e\u73b0");
        return new ArrayList();
    }

    public List getDepLeaders(String orgid, String depid, Connection con) {
        LOGGER.error("\u65b9\u6cd5[getDepLeaders]\u6ca1\u6709\u505a\u5b9e\u73b0");
        return new ArrayList();
    }

    public List getDepDirectors(String orgid, String depid, Connection con) {
        LOGGER.error("\u65b9\u6cd5[getDepDirectors]\u6ca1\u6709\u505a\u5b9e\u73b0");
        return new ArrayList();
    }

    public List getAllBaseRoles(Connection con) {
        return this.getAllRoles(con);
    }

    public List getAllRoles(Connection con) {
        return this.getAllRoles(null, con);
    }

    public List getAllRoles(String orgid, Connection con) {
        ArrayList<RoleModel> list = new ArrayList<RoleModel>();
        String instuCde = this.getCurrentInstuCde();
        try {
            PreparedStatement ps = con.prepareStatement("SELECT T0.* FROM ADMIN_SM_ROLE T0 JOIN ADMIN_SM_ORG T1 ON(T0.ORG_ID=T1.ORG_ID) JOIN ADMIN_SM_INSTU T2 ON(T1.INSTU_ID=T2.INSTU_ID) WHERE T2.INSTU_CDE=? ");
            ps.setString(1, instuCde);
            ResultSet rs = ps.executeQuery();
            List<Map<String, String>> datas = SqlUtil.rsToStrMap(rs);
            if (datas != null && !datas.isEmpty()) {
                for (Map<String, String> role : datas) {
                    RoleModel model = this.toRoleModel(role);
                    list.add(model);
                }
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return list;
    }

    public List getRolesByName(String orgid, String roleName, Connection con) {
        ArrayList<RoleModel> list = new ArrayList<RoleModel>();
        try {
            String instuCde = this.getCurrentInstuCde();
            PreparedStatement ps = con.prepareStatement("SELECT T0.* FROM ADMIN_SM_ROLE T0 JOIN ADMIN_SM_ORG T1 ON(T0.ORG_ID=T1.ORG_ID) JOIN ADMIN_SM_INSTU T2 ON(T1.INSTU_ID=T2.INSTU_ID) WHERE T2.INSTU_CDE=? AND T0.ROLE_NAME LIKE ?");
            ps.setString(1, instuCde);
            ps.setString(2, "%" + roleName + "%");
            ResultSet rs = ps.executeQuery();
            List<Map<String, String>> datas = SqlUtil.rsToStrMap(rs);
            if (datas != null && !datas.isEmpty()) {
                for (Map<String, String> role : datas) {
                    RoleModel roleModel = this.toRoleModel(role);
                    list.add(roleModel);
                }
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return list;
    }

    public List getAllRoles(String orgid, String depid, Connection con) {
        return this.getAllRoles(null, con);
    }

    public RoleModel getRoleModel(String orgid, String roleid, Connection con) {
        RoleModel result = null;
        try {
            String instuCde = this.getCurrentInstuCde();
            PreparedStatement ps = con.prepareStatement("SELECT T0.* FROM ADMIN_SM_ROLE T0 JOIN ADMIN_SM_ORG T1 ON(T0.ORG_ID=T1.ORG_ID) JOIN ADMIN_SM_INSTU T2 ON(T1.INSTU_ID=T2.INSTU_ID) WHERE T2.INSTU_CDE=? AND T0.ROLE_CODE=?");
            ps.setString(1, instuCde);
            ps.setString(2, roleid);
            ResultSet rs = ps.executeQuery();
            List<Map<String, String>> datas = SqlUtil.rsToStrMap(rs);
            if (datas != null && !datas.isEmpty()) {
                result = this.toRoleModel(datas.get(0));
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public List getUsersByRole(String orgid, String roleid, Connection con) {
        ArrayList<UserModel> list = new ArrayList<UserModel>();
        try {
            String instuCde = this.getCurrentInstuCde();
            PreparedStatement ps = con.prepareStatement("SELECT DISTINCT T0.* FROM ADMIN_SM_USER T0 JOIN ADMIN_SM_USER_ROLE_REL T1 ON(T0.USER_ID=T1.USER_ID) JOIN ADMIN_SM_ROLE T2 ON(T1.ROLE_ID=T2.ROLE_ID) JOIN ADMIN_SM_ORG T3 ON(T2.ORG_ID=T3.ORG_ID) JOIN ADMIN_SM_INSTU T4 ON(T3.INSTU_ID=T4.INSTU_ID) WHERE T0.USER_STS='A' AND T4.INSTU_CDE=? AND T2.ROLE_CODE=?");
            ps.setString(1, instuCde);
            ps.setString(2, roleid);
            ResultSet rs = ps.executeQuery();
            List<Map<String, String>> datas = SqlUtil.rsToStrMap(rs);
            if (datas != null && !datas.isEmpty()) {
                for (Map<String, String> user : datas) {
                    UserModel userModel = this.toUserModel(user);
                    list.add(userModel);
                }
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return list;
    }

    public List getRolesByUser(String orgid, String userid, Connection con) {
        ArrayList<RoleModel> list = new ArrayList<RoleModel>();
        try {
            String instuCde = this.getCurrentInstuCde();
            PreparedStatement ps = con.prepareStatement("SELECT DISTINCT T0.* FROM ADMIN_SM_ROLE T0 JOIN ADMIN_SM_USER_ROLE_REL T1 ON(T0.ROLE_ID=T1.ROLE_ID) JOIN ADMIN_SM_USER T2 ON(T1.USER_ID=T2.USER_ID) JOIN ADMIN_SM_ORG T3 ON(T2.ORG_ID=T3.ORG_ID) JOIN ADMIN_SM_INSTU T4 ON(T3.INSTU_ID=T4.INSTU_ID) WHERE T4.INSTU_CDE=? AND T2.LOGIN_CODE=?");
            ps.setString(1, instuCde);
            ps.setString(2, userid);
            ResultSet rs = ps.executeQuery();
            List<Map<String, String>> datas = SqlUtil.rsToStrMap(rs);
            if (datas != null && !datas.isEmpty()) {
                for (Map<String, String> role : datas) {
                    RoleModel model = this.toRoleModel(role);
                    list.add(model);
                }
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return list;
    }

    public List getAllBaseGroups(Connection con) {
        return this.getAllGroups(con);
    }

    public List getAllGroups(Connection con) {
        ArrayList<GroupModel> list = new ArrayList<GroupModel>();
        try {
            String instuCde = this.getCurrentInstuCde();
            PreparedStatement ps = con.prepareStatement("SELECT T0.* FROM ADMIN_SM_DUTY T0 JOIN ADMIN_SM_ORG T1 ON(T0.BELONG_ORG_ID=T1.ORG_ID) JOIN ADMIN_SM_INSTU T2 ON(T1.INSTU_ID=T2.INSTU_ID) WHERE T2.INSTU_CDE=?");
            ps.setString(1, instuCde);
            ResultSet rs = ps.executeQuery();
            List<Map<String, String>> datas = SqlUtil.rsToStrMap(rs);
            rs.close();
            ps.close();
            if (datas != null && !datas.isEmpty()) {
                for (int i = 0; i < datas.size(); ++i) {
                    GroupModel groupmodel = this.toGroupModel(datas.get(i));
                    list.add(groupmodel);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return list;
    }

    public List getAllGroups(String orgid, Connection con) {
        ArrayList<GroupModel> list = new ArrayList<GroupModel>();
        try {
            String instuCde = this.getCurrentInstuCde();
            PreparedStatement ps = con.prepareStatement("SELECT T0.* FROM ADMIN_SM_DUTY T0 JOIN ADMIN_SM_ORG T1 ON(T0.BELONG_ORG_ID=T1.ORG_ID) JOIN ADMIN_SM_INSTU T2 ON(T1.INSTU_ID=T2.INSTU_ID) WHERE T2.INSTU_CDE=?");
            ps.setString(1, instuCde);
            ResultSet rs = ps.executeQuery();
            List<Map<String, String>> datas = SqlUtil.rsToStrMap(rs);
            rs.close();
            ps.close();
            if (datas != null && !datas.isEmpty()) {
                for (int i = 0; i < datas.size(); ++i) {
                    Map<String, String> duty = datas.get(i);
                    GroupModel groupmodel = this.toGroupModel(duty);
                    list.add(groupmodel);
                }
            }
        }
        catch (Exception e1) {
            LOGGER.error(e1.getMessage(), (Throwable)e1);
        }
        return list;
    }

    public List getAllGroups(String orgid, String depid, Connection con) {
        return this.getAllGroups(orgid, con);
    }

    public GroupModel getGroupModel(String orgid, String groupid, Connection con) {
        GroupModel groupModel = null;
        try {
            String instuCde = this.getCurrentInstuCde();
            PreparedStatement ps = con.prepareStatement("SELECT T0.* FROM ADMIN_SM_DUTY T0 JOIN ADMIN_SM_ORG T1 ON(T0.BELONG_ORG_ID=T1.ORG_ID) JOIN ADMIN_SM_INSTU T2 ON(T1.INSTU_ID=T2.INSTU_ID) WHERE T2.INSTU_CDE=? AND DUTY_CDE=?");
            ps.setString(1, instuCde);
            ps.setString(2, groupid);
            ResultSet rs = ps.executeQuery();
            List<Map<String, String>> datas = SqlUtil.rsToStrMap(rs);
            rs.close();
            ps.close();
            if (datas != null && !datas.isEmpty()) {
                groupModel = this.toGroupModel(datas.get(0));
            }
        }
        catch (Exception e1) {
            LOGGER.error(e1.getMessage(), (Throwable)e1);
        }
        return groupModel;
    }

    public List getUsersByGroup(String orgid, String groupid, Connection con) {
        ArrayList<UserModel> list = new ArrayList<UserModel>();
        try {
            String instuCde = this.getCurrentInstuCde();
            PreparedStatement ps = con.prepareStatement("SELECT T0.* FROM ADMIN_SM_USER T0 JOIN ADMIN_SM_USER_DUTY_REL T1 ON(T0.USER_ID=T1.USER_ID) JOIN ADMIN_SM_DUTY T2 ON(T1.DUTY_ID=T2.DUTY_ID) JOIN ADMIN_SM_ORG T3 ON(T2.BELONG_ORG_ID=T3.ORG_ID) JOIN ADMIN_SM_INSTU T4 ON(T3.INSTU_ID=T4.INSTU_ID) WHERE T0.USER_STS='A' AND T4.INSTU_CDE=? AND T2.DUTY_CDE=?");
            ps.setString(1, instuCde);
            ps.setString(2, groupid);
            ResultSet rs = ps.executeQuery();
            List<Map<String, String>> datas = SqlUtil.rsToStrMap(rs);
            rs.close();
            ps.close();
            if (datas != null && !datas.isEmpty()) {
                for (Map<String, String> user : datas) {
                    list.add(this.toUserModel(user));
                }
            }
        }
        catch (Exception e1) {
            LOGGER.error(e1.getMessage(), (Throwable)e1);
        }
        return list;
    }

    public List getGroupByUser(String orgid, String userid, Connection con) {
        ArrayList<GroupModel> list = new ArrayList<GroupModel>();
        try {
            String instuCde = this.getCurrentInstuCde();
            PreparedStatement ps = con.prepareStatement("SELECT T0.* FROM ADMIN_SM_DUTY T0 JOIN ADMIN_SM_USER_DUTY_REL T1 ON(T0.DUTY_ID=T1.DUTY_ID) JOIN ADMIN_SM_USER T2 ON(T1.USER_ID=T2.USER_ID) JOIN ADMIN_SM_ORG T3 ON(T0.BELONG_ORG_ID=T3.ORG_ID) JOIN ADMIN_SM_INSTU T4 ON(T3.INSTU_ID=T4.INSTU_ID) WHERE T4.INSTU_CDE=? AND T2.LOGIN_CODE=? ");
            ps.setString(1, instuCde);
            ps.setString(2, userid);
            ResultSet rs = ps.executeQuery();
            List<Map<String, String>> datas = SqlUtil.rsToStrMap(rs);
            rs.close();
            ps.close();
            if (datas != null && !datas.isEmpty()) {
                for (Map<String, String> duty : datas) {
                    GroupModel groupModel = this.toGroupModel(duty);
                    list.add(groupModel);
                }
            }
        }
        catch (Exception e1) {
            LOGGER.error(e1.getMessage(), (Throwable)e1);
        }
        return list;
    }

    public String getGrantor(String orgid, String userid, String appid, Connection con) {
        LOGGER.error("\u65b9\u6cd5[getGrantor]\u6ca1\u6709\u505a\u5b9e\u73b0");
        return null;
    }

    public List getSuperiorUsers(String orgid, String userid, Connection con) {
        List list = new ArrayList();
        try {
            OrgModel supOrg = this.getParentOrg(orgid, con);
            if (supOrg == null) {
                return list;
            }
            String supOrgId = supOrg.getOrgid();
            if (supOrgId != null && !supOrgId.equals(orgid)) {
                list = this.getDirectUsersByOrg(supOrgId, con);
            }
        }
        catch (Exception e1) {
            LOGGER.error(e1.getMessage(), (Throwable)e1);
        }
        return list;
    }

    public List getJuniorUsers(String orgid, String userid, Connection con) {
        ArrayList list = new ArrayList();
        try {
            List subOrgList;
            List supOrgList = this.getDirectUsersByOrg(orgid, con);
            if (supOrgList != null && !supOrgList.isEmpty()) {
                list.addAll(supOrgList);
            }
            if ((subOrgList = this.getDirectSubOrgs(orgid, con)) != null) {
                for (OrgModel subOrg : subOrgList) {
                    List listTemp = this.getDirectUsersByOrg(subOrg.getOrgid(), con);
                    list.addAll(listTemp);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return list;
    }

    public List getSameDepUsers(String orgid, String userid, Connection con) {
        LOGGER.error("\u65b9\u6cd5[getSameDepUsers]\u6ca1\u6709\u505a\u5b9e\u73b0");
        return new ArrayList();
    }

    public List getSameOrgUsers(String orgid, String userid, Connection con) {
        List list = new ArrayList();
        try {
            if (null != userid && userid.length() > 0) {
                UserModel userTmp = this.getUserModel(userid, con);
                orgid = userTmp.getOrgid();
            }
            list = this.getDirectUsersByOrg(orgid, con);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return list;
    }

    public String getUserEmail(String orgid, String userid, Connection con) {
        UserModel userModel = this.getUserModel(userid, con);
        String strResult = userModel.getEmail();
        return strResult;
    }

    public void loadOUCache(OUCache oucache, Connection con) {
        LOGGER.warn("\u4e0d\u4f7f\u7528\u7ec4\u7ec7\u673a\u6784\u7684jvm\u7f13\u5b58\uff0c\u4e0d\u505a\u7f13\u5b58\u52a0\u8f7d");
    }

    public List getAllWFClient(String status, Connection con) {
        ArrayList<WFClient> list = new ArrayList<WFClient>();
        try {
            String strSql = "SELECT PKEY,CLIENTSIGN,CLIENTNAME,IP,TYPE,INVOKETYPE,STATUS,REMARK FROM WF_CLIENT ";
            if (status != null && status.length() > 0) {
                strSql = strSql + " WHERE STATUS= ?";
            }
            PreparedStatement ps = con.prepareStatement(strSql);
            if (status != null && status.length() > 0) {
                ps.setString(1, status);
            }
            ResultSet rs = ps.executeQuery();
            List<Map<String, String>> datas = SqlUtil.rsToStrMap(rs);
            rs.close();
            ps.close();
            if (datas != null && !datas.isEmpty()) {
                for (Map<String, String> wfClientTemp : datas) {
                    WFClient wfClient = new WFClient();
                    wfClient.setPkey(wfClientTemp.get("PKEY"));
                    wfClient.setClientSign(wfClientTemp.get("CLIENTSIGN"));
                    wfClient.setClientName(wfClientTemp.get("CLIENTNAME"));
                    wfClient.setIP(wfClientTemp.get("IP"));
                    wfClient.setType(wfClientTemp.get("TYPE"));
                    wfClient.setInvokeType(wfClientTemp.get("INVOKETYPE"));
                    wfClient.setStatus(wfClientTemp.get("STATUS"));
                    wfClient.setRemark(wfClientTemp.get("REMARK"));
                    list.add(wfClient);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return list;
    }

    public List<UserModel> queryUserModelsByName(String name, Connection con) {
        ArrayList<UserModel> list = new ArrayList<UserModel>();
        try {
            String instuCde = this.getCurrentInstuCde();
            PreparedStatement ps = con.prepareStatement("SELECT * FROM ADMIN_SM_USER T0 JOIN ADMIN_SM_ORG T1 ON(T0.ORG_ID=T1.ORG_ID) JOIN ADMIN_SM_INSTU T2 ON(T1.INSTU_ID=T2.INSTU_ID)WHERE T2.INSTU_CDE=? AND T0.USER_NAME LIKE ?");
            ps.setString(1, instuCde);
            ps.setString(2, "%" + name + "%");
            ResultSet rs = ps.executeQuery();
            List<Map<String, String>> datas = SqlUtil.rsToStrMap(rs);
            for (Map<String, String> user : datas) {
                UserModel userModel = this.toUserModel(user);
                list.add(userModel);
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return list;
    }

    public List getUpUpOrgUsers(String orgid, Connection con) {
        List list = new ArrayList();
        try {
            OrgModel supOrg = this.getParentOrg(orgid, con);
            if (supOrg == null) {
                return list;
            }
            String supOrgNo = supOrg.getOrgid();
            OrgModel supSupOrg = this.getParentOrg(supOrgNo, con);
            if (supSupOrg == null) {
                return list;
            }
            String supSupOrgNo = supSupOrg.getOrgid();
            list = this.getDirectUsersByOrg(supSupOrgNo, con);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return list;
    }

    public List getUpUpOrgDownOrgUsers(String orgid, Connection con) {
        ArrayList list = new ArrayList();
        try {
            List subOrgList;
            OrgModel supOrg = this.getParentOrg(orgid, con);
            if (supOrg == null) {
                return list;
            }
            OrgModel supSupOrg = this.getParentOrg(supOrg.getOrgid(), con);
            if (supSupOrg == null) {
                return list;
            }
            if (supSupOrg != null && (subOrgList = this.getDirectSubOrgs(supSupOrg.getOrgid(), con)) != null) {
                for (OrgModel subOrg : subOrgList) {
                    List listTemp = this.getDirectUsersByOrg(subOrg.getOrgid(), con);
                    list.addAll(listTemp);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return list;
    }

    public List getUpDownOrgUsers(String orgid, Connection con) {
        ArrayList list = new ArrayList();
        try {
            List subOrgList;
            OrgModel supOrg = this.getParentOrg(orgid, con);
            if (supOrg == null) {
                return list;
            }
            String supOrgNo = supOrg.getOrgid();
            List supOrgList = this.getDirectUsersByOrg(supOrgNo, con);
            if (supOrgList != null && !supOrgList.isEmpty()) {
                list.addAll(supOrgList);
            }
            if ((subOrgList = this.getDirectSubOrgs(orgid, con)) != null) {
                for (OrgModel subOrg : subOrgList) {
                    List listTemp = this.getDirectUsersByOrg(subOrg.getOrgid(), con);
                    list.addAll(listTemp);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return list;
    }

    public List getSameOrgLine(String orgid, Connection con) {
        ArrayList<String> list = new ArrayList<String>();
        try {
            String instuCde = this.getCurrentInstuCde();
            PreparedStatement ps = con.prepareStatement("SELECT T0.* FROM(SELECT * FROM ADMIN_SM_ORG START WITH ORG_CODE=? CONNECT BY NOCYCLE PRIOR UP_ORG_ID=ORG_ID)T0 JOIN ADMIN_SM_INSTU T1 ON(T0.INSTU_ID=T1.INSTU_ID) WHERE T1.INSTU_CDE=?");
            ps.setString(1, orgid);
            ps.setString(2, instuCde);
            ResultSet rs = ps.executeQuery();
            List<Map<String, String>> datas = SqlUtil.rsToStrMap(rs);
            rs.close();
            ps.close();
            if (null != datas && !datas.isEmpty()) {
                for (Map<String, String> bch : datas) {
                    OrgModel supOrgModel = this.toOrgModel(bch);
                    list.add(supOrgModel.getOrgid());
                }
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return list;
    }

    public List getSameOrgLineUsers(String orgid, Connection con) {
        ArrayList list = new ArrayList();
        List supOrgs = this.getSameOrgLine(orgid, con);
        for (int i = 0; i < supOrgs.size(); ++i) {
            String orgidTmp = (String)supOrgs.get(i);
            try {
                List listTemp = this.getDirectUsersByOrg(orgidTmp, con);
                if (!(listTemp != null & !listTemp.isEmpty())) continue;
                list.addAll(listTemp);
                continue;
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
        return list;
    }

    public String getDeptOrgid(String orgid, Connection con) {
        LOGGER.error("\u65b9\u6cd5[getDeptOrgid]\u6ca1\u6709\u505a\u5b9e\u73b0");
        return null;
    }

    public List getSubDeptByOrgid(String orgid, Connection con) {
        LOGGER.error("\u65b9\u6cd5[getSubDeptByOrgid]\u6ca1\u6709\u505a\u5b9e\u73b0");
        return new ArrayList();
    }

    public List getUpAndUpUpOrgUsers(String orgid, Connection con) {
        ArrayList list = new ArrayList();
        try {
            OrgModel supSupOrg;
            OrgModel supOrg = this.getParentOrg(orgid, con);
            if (supOrg == null) {
                return list;
            }
            String supOrgNo = supOrg.getOrgid();
            List listTemp = this.getDirectUsersByOrg(supOrgNo, con);
            if (listTemp != null & !listTemp.isEmpty()) {
                list.addAll(listTemp);
            }
            if ((supSupOrg = this.getParentOrg(supOrgNo, con)) == null) {
                return list;
            }
            String supSupOrgNo = supSupOrg.getOrgid();
            List listTemp2 = this.getDirectUsersByOrg(supSupOrgNo, con);
            if (listTemp2 != null & !listTemp2.isEmpty()) {
                list.addAll(listTemp2);
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return list;
    }

    public List getSampeAndUpOrgUsers(String orgid, Connection con) {
        ArrayList list = new ArrayList();
        list.addAll(this.getSameOrgUsers(orgid, null, con));
        list.addAll(this.getSuperiorUsers(orgid, null, con));
        return list;
    }

    public List getSampeOrgOrDeptUsers(String orgid, Connection con) {
        return new ArrayList();
    }

    protected OrgModel toOrgModel(Map<String, String> org) {
        String supOrgId;
        OrgModel orgModel = new OrgModel();
        String orgId = org.get("ORG_ID");
        if (orgId.equals(supOrgId = org.get("UP_ORG_ID"))) {
            supOrgId = null;
        }
        orgModel.setOrgid(orgId);
        orgModel.setOrgname(org.get("ORG_NAME"));
        orgModel.setSuporgid(supOrgId);
        int orgLevel = Integer.valueOf(org.get("ORG_LEVEL"));
        orgModel.setOrglevel(orgLevel);
        if (orgLevel == 1) {
            orgModel.setSuporgid(null);
        }
        return orgModel;
    }

    protected UserModel toUserModel(Map<String, String> user) {
        UserModel userModel = new UserModel();
        userModel.setUserid(user.get("LOGIN_CODE"));
        userModel.setUsername(user.get("USER_NAME"));
        userModel.setEmail(user.get("USER_EMAIL"));
        userModel.setMobile(user.get("USR_OFFICETEL"));
        userModel.setOrgid(user.get("ORG_ID"));
        return userModel;
    }

    private GroupModel toGroupModel(Map<String, String> duty) {
        GroupModel groupModel = new GroupModel();
        groupModel.setGroupid(duty.get("DUTY_CDE"));
        groupModel.setGroupname(duty.get("DUTY_NAME"));
        groupModel.setOrgid(duty.get("BELONG_ORG_ID"));
        return groupModel;
    }

    private RoleModel toRoleModel(Map<String, String> role) {
        RoleModel roleModel = new RoleModel();
        roleModel.setRoleid(role.get("ROLE_CODE"));
        roleModel.setRolename(role.get("ROLE_NAME"));
        roleModel.setOrgid(role.get("ORG_ID"));
        return roleModel;
    }

    protected String getCurrentInstuCde() {
        EChainRuntimeContext config = EChainRuntimeContext.instance();
        String instuCde = config.getInstuCde();
        return instuCde;
    }

    protected String getSignUser() {
        EChainRuntimeContext config = EChainRuntimeContext.instance();
        String signUser = config.getSignUserName();
        return signUser;
    }
}

