/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.echain.server.echain;

import cn.com.yusys.yusp.echain.server.echain.EChainRuntimeContext;
import cn.com.yusys.yusp.echain.server.echain.cache.EChainCacheLoader;
import com.ecc.echain.db.datasource.EChainSimpleJdbcDataSource;
import com.ecc.echain.log.WfLog;
import com.ecc.echain.util.WfPropertyManager;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EchainInitializer {
    private static final Logger LOGGER = LoggerFactory.getLogger(EchainInitializer.class);
    private DataSource dataSource;

    public EchainInitializer(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void init() {
        this.eChainCoreInit();
        this.eChainCacheInit();
        this.eChainClientInit();
        LOGGER.info("echain \u521d\u59cb\u5316\u5b8c\u6bd5");
    }

    protected void eChainCoreInit() {
        String logImplClass = WfPropertyManager.getInstance().logImplClass;
        WfLog.init((String)logImplClass, null);
        LOGGER.info("echain \u65e5\u5fd7\u5b9e\u73b0\u7c7b\u4e3a" + logImplClass);
        EChainSimpleJdbcDataSource simpleJdbcDataSource = EChainSimpleJdbcDataSource.instance();
        simpleJdbcDataSource.init(this.dataSource);
    }

    public void eChainCacheInit() {
        EChainCacheLoader cacheHandler = EChainCacheLoader.instance();
        cacheHandler.loadCache(false);
    }

    public void eChainClientInit() {
        EChainRuntimeContext extConfig = EChainRuntimeContext.instance();
        extConfig.init();
    }
}

