/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.web.rest.errors;

import cn.com.yusys.yusp.commons.web.rest.dto.ErrorDto;
import cn.com.yusys.yusp.commons.web.rest.errors.CustomParameterizedException;
import cn.com.yusys.yusp.commons.web.rest.errors.ErrorVM;
import cn.com.yusys.yusp.commons.web.rest.errors.ParameterizedErrorVM;
import cn.com.yusys.yusp.commons.web.rest.exception.MessageConstans;
import cn.com.yusys.yusp.commons.web.rest.exception.YuspException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.dao.ConcurrencyFailureException;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@ControllerAdvice
public class ExceptionTranslator {
    private final Logger logger = LoggerFactory.getLogger(ExceptionTranslator.class);

    @ExceptionHandler(value={ConcurrencyFailureException.class})
    @ResponseStatus(value=HttpStatus.CONFLICT)
    @ResponseBody
    public ErrorVM processConcurrencyError(ConcurrencyFailureException ex) {
        return new ErrorVM("error.concurrencyFailure");
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    public ErrorVM processValidationError(MethodArgumentNotValidException ex) {
        BindingResult result = ex.getBindingResult();
        List fieldErrors = result.getFieldErrors();
        ErrorVM dto = new ErrorVM("error.validation");
        for (FieldError fieldError : fieldErrors) {
            dto.add(fieldError.getObjectName(), fieldError.getField(), fieldError.getCode());
        }
        return dto;
    }

    @ExceptionHandler(value={CustomParameterizedException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    public ParameterizedErrorVM processParameterizedValidationError(CustomParameterizedException ex) {
        return ex.getErrorVM();
    }

    @ExceptionHandler(value={AccessDeniedException.class})
    @ResponseStatus(value=HttpStatus.FORBIDDEN)
    @ResponseBody
    public ErrorVM processAccessDeniedException(AccessDeniedException e) {
        return new ErrorVM("error.accessDenied", e.getMessage());
    }

    @ExceptionHandler(value={HttpRequestMethodNotSupportedException.class})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.METHOD_NOT_ALLOWED)
    public ErrorVM processMethodNotSupportedException(HttpRequestMethodNotSupportedException exception) {
        return new ErrorVM("error.methodNotSupported", exception.getMessage());
    }

    @ExceptionHandler(value={YuspException.class})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public ErrorDto processBusiException(YuspException ex) {
        ErrorDto dto = new ErrorDto(ex.getCode(), ex.getMsg(), ex.getLevel());
        return dto;
    }

    @ExceptionHandler(value={DuplicateKeyException.class})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public ErrorDto processPkError(DuplicateKeyException ex) {
        this.logger.error("DuplicateKeyException Advice\uff0cMessage:{}", (Object)ex.getMessage());
        ErrorDto dto = new ErrorDto("100000", "\u6570\u636e\u9879\u5df2\u5b58\u5728\uff0c\u4e0d\u80fd\u91cd\u590d\u64cd\u4f5c", MessageConstans.MSG_LEVEL_ERROR);
        return dto;
    }

    @ExceptionHandler(value={Exception.class})
    public ResponseEntity<ErrorVM> processRuntimeException(Exception ex) {
        ErrorVM errorVM;
        ResponseEntity.BodyBuilder builder;
        this.logger.error("Exception Advice\uff0cCode:{}\uff0cMessage:{}", (Object)HttpStatus.INTERNAL_SERVER_ERROR, (Object)ex.getMessage());
        ex.printStackTrace();
        ResponseStatus responseStatus = (ResponseStatus)AnnotationUtils.findAnnotation(ex.getClass(), ResponseStatus.class);
        if (responseStatus != null) {
            builder = ResponseEntity.status((HttpStatus)responseStatus.value());
            errorVM = new ErrorVM("error." + responseStatus.value().value(), responseStatus.reason());
        } else {
            builder = ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR);
            errorVM = new ErrorVM("error.internalServerError", "Internal server error");
        }
        return builder.body((Object)errorVM);
    }
}

