/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.web.rest;

import cn.com.yusys.yusp.commons.web.rest.util.HeaderUtil;
import cn.com.yusys.yusp.commons.web.rest.util.PaginationUtil;
import com.codahale.metrics.annotation.Timed;
import io.github.jhipster.web.util.ResponseUtil;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Optional;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;

public abstract class CrudResource<T, ID extends Serializable> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    protected abstract JpaRepository<T, ID> getJpaRepository();

    protected abstract String getEntityName();

    @PostMapping(value={"/"})
    @Timed
    public ResponseEntity<T> createEntity(@Valid @RequestBody T entity) throws URISyntaxException {
        this.log.debug("REST request to save Entity : {}", entity);
        if (this.getId(entity) != null) {
            return ((ResponseEntity.BodyBuilder)ResponseEntity.badRequest().headers(HeaderUtil.createFailureAlert(this.getEntityName(), "idexists", "A new entity cannot already have an ID"))).body(null);
        }
        Object result = this.getJpaRepository().save(entity);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.created((URI)new URI("/api/" + this.getEntityName() + "/" + this.getId(result))).headers(HeaderUtil.createEntityCreationAlert(this.getEntityName(), this.getId(result).toString()))).body(result);
    }

    @PutMapping(value={"/"})
    @Timed
    public ResponseEntity<T> updateEntity(@Valid @RequestBody T entity) throws URISyntaxException {
        this.log.debug("REST request to update Entity : {}", entity);
        if (this.getId(entity) == null) {
            return this.createEntity(entity);
        }
        Object result = this.getJpaRepository().save(entity);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(HeaderUtil.createEntityUpdateAlert(this.getEntityName(), this.getId(entity).toString()))).body(result);
    }

    @GetMapping(value={"/"})
    @Timed
    public ResponseEntity<List<T>> getAllEntityS(@ApiParam Pageable pageable) {
        this.log.debug("REST request to get a page of EntityS");
        Page page = this.getJpaRepository().findAll(pageable);
        HttpHeaders headers = PaginationUtil.generatePaginationHttpHeaders(page, "/api/" + this.getEntityName());
        return new ResponseEntity((Object)page.getContent(), (MultiValueMap)headers, HttpStatus.OK);
    }

    @GetMapping(value={"/{id}"})
    @Timed
    public ResponseEntity<T> getEntity(@PathVariable ID id) {
        this.log.debug("REST request to get Entity : {}", id);
        Object entity = this.getJpaRepository().findOne(id);
        return ResponseUtil.wrapOrNotFound(Optional.ofNullable(entity));
    }

    @DeleteMapping(value={"/{id}"})
    @Timed
    public ResponseEntity<Void> deleteEntity(@PathVariable ID id) {
        this.log.debug("REST request to delete Entity : {}", id);
        this.getJpaRepository().delete(id);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(HeaderUtil.createEntityDeletionAlert(this.getEntityName(), id.toString()))).build();
    }

    public ID getId(T o) {
        Class<?> co = o.getClass();
        try {
            Method m = co.getDeclaredMethod("getId", new Class[0]);
            return (ID)((Serializable)m.invoke(o, new Object[0]));
        }
        catch (Exception e) {
            this.log.error("Crud resource getId error{}", (Object)e.getMessage());
            e.printStackTrace();
            return null;
        }
    }
}

