/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.web.rest;

import cn.com.yusys.yusp.commons.mapper.QueryModel;
import cn.com.yusys.yusp.commons.service.CommonService;
import cn.com.yusys.yusp.commons.web.rest.dto.ResultDto;
import com.codahale.metrics.annotation.Timed;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.net.URISyntaxException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

public abstract class CommonResource<T, PK extends Serializable> {
    private final Logger log = LoggerFactory.getLogger(CommonResource.class);

    @GetMapping(value={"/"})
    @Timed
    protected ResultDto<List<T>> index(QueryModel queryModel) {
        this.log.debug("REST request to query index : {}", (Object)queryModel);
        List list = this.getCommonService().selectByModel(queryModel);
        return new ResultDto(list);
    }

    @GetMapping(value={"/{id}"})
    @Timed
    protected ResultDto<Object> show(@ApiParam(value="Object of PK id", required=true) @PathVariable PK id) {
        this.log.debug("REST request to get Object : {}", id);
        Object Object2 = this.getCommonService().selectByPrimaryKey(id);
        return new ResultDto<Object>(Object2);
    }

    @PostMapping(value={"/"})
    @Timed
    protected ResultDto<T> create(@ApiParam(value="Object", required=true) @RequestBody T t) throws URISyntaxException {
        this.log.debug("REST request to save Object : {}", t);
        this.getCommonService().insert(t);
        return new ResultDto<T>(t);
    }

    @PostMapping(value={"/update"})
    @Timed
    protected ResultDto<Integer> update(@ApiParam(value="Object", required=true) @RequestBody T t) throws URISyntaxException {
        this.log.debug("REST request to update Object : {}", t);
        int result = this.getCommonService().update(t);
        return new ResultDto<Integer>(result);
    }

    @PostMapping(value={"/delete/{id}"})
    @Timed
    protected ResultDto<Integer> delete(@ApiParam(value="Object Of PK id", required=true) @PathVariable PK id) {
        this.log.debug("REST request to delete Object : {}", id);
        int result = this.getCommonService().deleteByPrimaryKey(id);
        return new ResultDto<Integer>(result);
    }

    @PostMapping(value={"/batchdelete/{ids}"})
    @Timed
    protected ResultDto<Integer> deletes(@ApiParam(value="Object Of PK id", required=true) @PathVariable String ids) {
        this.log.debug("REST request to delete Object : {}", (Object)ids);
        int result = this.getCommonService().deleteByIds(ids);
        return new ResultDto<Integer>(result);
    }

    protected abstract CommonService getCommonService();
}

