/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.web.rest;

import cn.com.yusys.yusp.commons.excel.ExcelTaskManager;
import cn.com.yusys.yusp.commons.excel.ExcelUtil;
import cn.com.yusys.yusp.commons.file.FileManagementCilentFactory;
import cn.com.yusys.yusp.commons.mapper.QueryModel;
import cn.com.yusys.yusp.commons.util.file.FileTypeUtil;
import cn.com.yusys.yusp.commons.web.rest.CommonResource;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.web.bind.annotation.GetMapping;

public abstract class CommonIoResource<T, PK extends Serializable>
extends CommonResource {
    @Autowired
    ExcelTaskManager excelTaskManager;
    @Autowired
    StringRedisTemplate stringRedisTemplate;
    @Autowired
    FileManagementCilentFactory fileManagementCilentFactory;
    @Autowired
    SqlSessionFactory sqlSessionFactory;
    private static final Logger logger = LoggerFactory.getLogger(CommonIoResource.class);

    public abstract String getExportSql();

    public abstract String getPojoClassName();

    @GetMapping(value={"/export"})
    public void export(QueryModel queryModel, HttpServletRequest request, HttpServletResponse response) {
        SqlSession sqlSession = this.sqlSessionFactory.openSession();
        List list = sqlSession.selectList(this.getExportSql(), (Object)queryModel);
        if (sqlSession != null) {
            sqlSession.clearCache();
            sqlSession.close();
        }
        StringBuffer sb = new StringBuffer();
        Workbook book = ExcelUtil.createWorkBook(list, ExcelTaskManager.BATCH_SIZE, this.getPojoClassName(), sb, true, true);
        if (StringUtils.isEmpty((CharSequence)sb)) {
            sb.append("\u7a7a");
        }
        String fileName = sb + ".xlsx";
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            response.setContentType(FileTypeUtil.getMimeType(fileName));
            response.setHeader("Content-Disposition", "attachment; filename=" + FileTypeUtil.getEncodeFileName(request, fileName));
            book.write((OutputStream)os);
            byte[] bytes = os.toByteArray();
            response.getOutputStream().write(bytes);
            response.getOutputStream().flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @GetMapping(value={"/exportasync"})
    public String asyncExport(QueryModel queryModel, Integer fetchSize) {
        logger.debug("\u5c06excel\u5bfc\u51fa\u4efb\u52a1\u6dfb\u52a0\u5230\u5f02\u6b65\u5bfc\u51fa\u4efb\u52a1\u6c60--");
        String taskId = this.excelTaskManager.addExcelExportTask(this.getExportSql(), fetchSize, queryModel, this.getPojoClassName());
        return taskId;
    }
}

