/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.util.file;

import cn.com.yusys.yusp.commons.util.file.FileTypeMeta;
import cn.com.yusys.yusp.commons.util.file.JaxbUtil;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.servlet.http.HttpServletRequest;

public class FileTypeUtil {
    private static final FileTypeMeta FILE_TYPE_META = JaxbUtil.unmarshall("file-type.xml");

    public static String getMimeType(String fileName) {
        return FILE_TYPE_META.getFileTypeBySuffix(FileTypeUtil.getExtFileName(fileName)).getMimeType();
    }

    public static String getExtFileName(String filename) {
        int i;
        if (filename != null && filename.length() > 0 && (i = filename.lastIndexOf(46)) > -1 && i < filename.length()) {
            int j;
            String extFileType = filename.substring(i, filename.length());
            if (extFileType != null && extFileType.length() > 0 && (j = extFileType.lastIndexOf(63)) > -1) {
                return extFileType.substring(0, j);
            }
            return extFileType;
        }
        return "";
    }

    public static String getEncodeFileName(HttpServletRequest request, String filename) throws UnsupportedEncodingException {
        String userAgent = request.getHeader("User-Agent").toLowerCase();
        if (userAgent.contains("msie") || userAgent.contains("trident/7.0") || userAgent.contains("edge")) {
            return URLEncoder.encode(filename, "UTF-8");
        }
        if (userAgent.contains("mozilla") || userAgent.contains("chrome")) {
            return new String(filename.getBytes(), "ISO-8859-1");
        }
        return URLEncoder.encode(filename, "UTF-8");
    }
}

