/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.util;

import cn.com.yusys.yusp.commons.util.ByteTools;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;

public class DesTools {
    private static final String DES = "DES";

    public static byte[] des1Encode(byte[] encryptData, byte[] keyData, String mode, String padding) throws Exception {
        Object[] object = DesTools.getSecretKey(keyData, mode, padding);
        SecretKey secretKey = (SecretKey)object[0];
        Cipher cipher = (Cipher)object[1];
        return DesTools.encode(encryptData, secretKey, cipher);
    }

    public static byte[] des3Encode(byte[] encryptData, byte[] keyData, String mode, String padding) throws Exception {
        if (keyData.length != 16) {
            throw new Exception("Des\u5de5\u5177\u7c7b @ Des3\u5bc6\u94a5\u957f\u5ea6\u5e94\u4e3a16\u4f4d\uff1a" + keyData.length);
        }
        byte[] forePart = new byte[8];
        byte[] nextPart = new byte[8];
        System.arraycopy(keyData, 0, forePart, 0, 8);
        System.arraycopy(keyData, 8, nextPart, 0, 8);
        int dataLength = encryptData.length;
        int length = dataLength % 8 == 0 ? dataLength : 8 * (dataLength / 8 + 1);
        byte[] tmpArray = new byte[length];
        System.arraycopy(encryptData, 0, tmpArray, 0, length);
        SecretKey secretKey = null;
        Cipher cipher = null;
        Object[] ketAndCipher = new Object[2];
        ketAndCipher = DesTools.getSecretKey(forePart, mode, padding);
        secretKey = (SecretKey)ketAndCipher[0];
        cipher = (Cipher)ketAndCipher[1];
        tmpArray = DesTools.encode(tmpArray, secretKey, cipher);
        ketAndCipher = DesTools.getSecretKey(nextPart, mode, padding);
        secretKey = (SecretKey)ketAndCipher[0];
        cipher = (Cipher)ketAndCipher[1];
        tmpArray = DesTools.decode(tmpArray, secretKey, cipher);
        ketAndCipher = DesTools.getSecretKey(forePart, mode, padding);
        secretKey = (SecretKey)ketAndCipher[0];
        cipher = (Cipher)ketAndCipher[1];
        tmpArray = DesTools.encode(tmpArray, secretKey, cipher);
        return tmpArray;
    }

    public static byte[] cirEncode(byte[] encryptData, byte[] keyData, String mode, String padding) throws Exception {
        Object[] object = DesTools.getSecretKey(keyData, mode, padding);
        SecretKey secretKey = (SecretKey)object[0];
        Cipher cipher = (Cipher)object[1];
        int dataLength = encryptData.length;
        int surplus = dataLength % 8;
        if (surplus == 0) {
            return DesTools.encodeXorCal(encryptData, secretKey, cipher);
        }
        byte[] dividedPart = new byte[dataLength - surplus];
        System.arraycopy(encryptData, 0, dividedPart, 0, dividedPart.length);
        dividedPart = DesTools.encodeXorCal(dividedPart, secretKey, cipher);
        byte[] padPart = new byte[8];
        System.arraycopy(dividedPart, dividedPart.length - (8 - surplus), padPart, 0, 8 - surplus);
        System.arraycopy(encryptData, dataLength - surplus, padPart, 8 - surplus, surplus);
        padPart = DesTools.encode(padPart, secretKey, cipher);
        byte[] retArray = new byte[dataLength];
        System.arraycopy(dividedPart, 0, retArray, 0, dataLength - 8);
        System.arraycopy(padPart, 0, retArray, dataLength - 8, 8);
        return retArray;
    }

    public static byte[] encodeXorCal(byte[] data, SecretKey secretKey, Cipher cipher) throws Exception {
        int len = data.length;
        byte[] retArray = new byte[len];
        retArray = data;
        for (int i = 0; i < len; i += 8) {
            byte[] tmpArray = new byte[8];
            if (i > 0) {
                for (int j = 0; j < 8; ++j) {
                    int n = i + j;
                    retArray[n] = (byte)(retArray[n] ^ retArray[i + j - 8]);
                    tmpArray[j] = retArray[i + j];
                }
            } else {
                System.arraycopy(retArray, 0, tmpArray, 0, 8);
            }
            tmpArray = DesTools.encode(tmpArray, secretKey, cipher);
            System.arraycopy(tmpArray, 0, retArray, i, 8);
        }
        return retArray;
    }

    public static byte[] encode(byte[] data, SecretKey secretKey, Cipher cipher) throws Exception {
        if (data.length % 8 != 0) {
            throw new Exception("Des\u5de5\u5177\u7c7b @ \u52a0\u5bc6\u6570\u636e\u957f\u5ea6\u4e3a8\u7684\u500d\u6570\uff1a " + data.length);
        }
        byte[] retArray = null;
        try {
            cipher.init(1, secretKey);
            retArray = cipher.doFinal(data);
        }
        catch (Exception e) {
            throw new Exception("DES\u5de5\u5177\u7c7b @ \u5bc6\u94a5\u52a0\u5bc6\u5931\u8d25", e);
        }
        return retArray;
    }

    public static byte[] des1Decode(byte[] decodeData, byte[] keyData, String mode, String padding) throws Exception {
        SecretKey secretKey = null;
        Cipher cipher = null;
        Object[] ketAndCipher = new Object[2];
        ketAndCipher = DesTools.getSecretKey(keyData, mode, padding);
        secretKey = (SecretKey)ketAndCipher[0];
        cipher = (Cipher)ketAndCipher[1];
        byte[] retArray = DesTools.decode(decodeData, secretKey, cipher);
        retArray = ByteTools.stripEnd(retArray, (byte)0);
        return retArray;
    }

    public static byte[] cirDecode(byte[] decodeData, byte[] keyData, String mode, String padding) throws Exception {
        SecretKey secretKey = null;
        Cipher cipher = null;
        Object[] ketAndCipher = new Object[2];
        ketAndCipher = DesTools.getSecretKey(keyData, mode, padding);
        secretKey = (SecretKey)ketAndCipher[0];
        cipher = (Cipher)ketAndCipher[1];
        int dataLength = decodeData.length;
        int surplus = dataLength % 8;
        if (surplus == 0) {
            return DesTools.decodeXorCal(decodeData, secretKey, cipher);
        }
        byte[] left = new byte[8];
        System.arraycopy(decodeData, dataLength - 8, left, 0, 8);
        left = DesTools.decode(left, secretKey, cipher);
        int length = dataLength - surplus;
        byte[] des = new byte[length];
        System.arraycopy(decodeData, 0, des, 0, length - 8 + surplus);
        System.arraycopy(left, 0, des, length - 8 + surplus, 8 - surplus);
        des = DesTools.decodeXorCal(des, secretKey, cipher);
        byte[] retArray = new byte[dataLength];
        System.arraycopy(des, 0, retArray, 0, length);
        System.arraycopy(left, 8 - surplus, retArray, length, surplus);
        return retArray;
    }

    public static byte[] des3Decode(byte[] decodeData, byte[] keyData, String mode, String padding) throws Exception {
        if (keyData.length != 16) {
            throw new Exception("Des\u5de5\u5177\u7c7b @ Des3\u5bc6\u94a5\u957f\u5ea6\u5e94\u4e3a16\uff1a " + keyData.length);
        }
        byte[] forePart = new byte[8];
        byte[] nextPart = new byte[8];
        System.arraycopy(keyData, 0, forePart, 0, 8);
        System.arraycopy(keyData, 8, nextPart, 0, 8);
        if (decodeData.length % 8 != 0) {
            throw new Exception("Des\u5de5\u5177\u7c7b@ Des3\u6570\u636e\u957f\u5ea6\u5e94\u4e3a8\u7684\u500d\u6570\uff1a " + decodeData.length);
        }
        byte[] tmpArray = new byte[decodeData.length];
        System.arraycopy(decodeData, 0, tmpArray, 0, decodeData.length);
        SecretKey secretKey = null;
        Cipher cipher = null;
        Object[] ketAndCipher = new Object[2];
        ketAndCipher = DesTools.getSecretKey(forePart, mode, padding);
        secretKey = (SecretKey)ketAndCipher[0];
        cipher = (Cipher)ketAndCipher[1];
        tmpArray = DesTools.decode(tmpArray, secretKey, cipher);
        ketAndCipher = DesTools.getSecretKey(nextPart, mode, padding);
        secretKey = (SecretKey)ketAndCipher[0];
        cipher = (Cipher)ketAndCipher[1];
        tmpArray = DesTools.encode(tmpArray, secretKey, cipher);
        ketAndCipher = DesTools.getSecretKey(forePart, mode, padding);
        secretKey = (SecretKey)ketAndCipher[0];
        cipher = (Cipher)ketAndCipher[1];
        tmpArray = DesTools.decode(tmpArray, secretKey, cipher);
        byte[] retArray = ByteTools.stripEnd(tmpArray, (byte)0);
        return retArray;
    }

    public static byte[] decodeXorCal(byte[] data, SecretKey secretKey, Cipher cipher) throws Exception {
        int length = data.length;
        byte[] retArray = new byte[length];
        System.arraycopy(data, 0, retArray, 0, length);
        for (int i = length - 8; i >= 0; i -= 8) {
            byte[] tmpArray = new byte[8];
            System.arraycopy(retArray, i, tmpArray, 0, 8);
            tmpArray = DesTools.decode(tmpArray, secretKey, cipher);
            System.arraycopy(tmpArray, 0, retArray, i, 8);
            if (i <= 0) continue;
            for (int j = 0; j < 8; ++j) {
                int n = i + j;
                retArray[n] = (byte)(retArray[n] ^ retArray[i + j - 8]);
            }
        }
        return retArray;
    }

    public static byte[] decode(byte[] data, SecretKey secretKey, Cipher cipher) throws Exception {
        if (data.length % 8 != 0) {
            throw new Exception("DES\u5de5\u5177\u7c7b @ \u5bc6\u94a5\u89e3\u5bc6\u7684\u6570\u636e\u957f\u5ea6[" + data.length + "]\u4e3a8\u7684\u500d\u6570");
        }
        byte[] retArray = null;
        try {
            cipher.init(2, secretKey);
            retArray = cipher.doFinal(data);
        }
        catch (Exception e) {
            throw new Exception("DES\u5de5\u5177\u7c7b @ \u5bc6\u94a5\u89e3\u5bc6\u5931\u8d25", e);
        }
        return retArray;
    }

    public static Object[] getSecretKey(byte[] keyData, String mode, String padding) throws Exception {
        Object[] object = new Object[2];
        try {
            DESKeySpec desKeySpec = new DESKeySpec(keyData);
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(DES);
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("DES/");
            stringBuilder.append(mode);
            stringBuilder.append("/");
            stringBuilder.append(padding);
            object[0] = keyFactory.generateSecret(desKeySpec);
            object[1] = Cipher.getInstance(stringBuilder.toString());
        }
        catch (Exception e) {
            throw new Exception("DES\u5de5\u5177\u7c7b @ \u751f\u6210\u5bc6\u94a5\u5931\u8d25", e);
        }
        return object;
    }
}

