/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.job.core.log;

import cn.com.yusys.yusp.commons.job.core.log.JobFileAppender;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobLogger {
    private static Logger logger = LoggerFactory.getLogger((String)"job logger");
    private static SimpleDateFormat jobLoggerFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    private static void logDetail(StackTraceElement callInfo, String appendLog) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(jobLoggerFormat.format(new Date())).append(" ").append("[" + callInfo.getClassName() + "#" + callInfo.getMethodName() + "]").append("-").append("[" + callInfo.getLineNumber() + "]").append("-").append("[" + Thread.currentThread().getName() + "]").append(" ").append(appendLog != null ? appendLog : "");
        String formatAppendLog = stringBuffer.toString();
        String logFileName = (String)JobFileAppender.contextHolder.get();
        if (logFileName != null && logFileName.trim().length() > 0) {
            JobFileAppender.appendLog(logFileName, formatAppendLog);
        } else {
            logger.info(">>>>>>>>>>> {}", (Object)formatAppendLog);
        }
    }

    public static void log(String appendLogPattern, Object ... appendLogArguments) {
        String appendLog = appendLogPattern;
        if (appendLogArguments != null && appendLogArguments.length > 0) {
            appendLog = MessageFormat.format(appendLogPattern, appendLogArguments);
        }
        StackTraceElement callInfo = new Throwable().getStackTrace()[1];
        JobLogger.logDetail(callInfo, appendLog);
    }

    public static void log(Throwable e) {
        StringWriter stringWriter = new StringWriter();
        e.printStackTrace(new PrintWriter(stringWriter));
        String appendLog = stringWriter.toString();
        StackTraceElement callInfo = new Throwable().getStackTrace()[1];
        JobLogger.logDetail(callInfo, appendLog);
    }
}

