/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.file;

import cn.com.yusys.yusp.commons.config.ApplicationProperties;
import cn.com.yusys.yusp.commons.file.FileManagementCilent;
import cn.com.yusys.yusp.commons.file.disk.LocalDiskClient;
import cn.com.yusys.yusp.commons.file.fastdfs.FastDFSClient;
import org.springframework.beans.factory.annotation.Autowired;

public class FileManagementCilentFactory {
    @Autowired
    ApplicationProperties applicationProperties;
    FileManagementCilent fileManagementCilent = null;

    public FileManagementCilent getFileManagementCilent() {
        String clientType = this.applicationProperties.getFileStorageType();
        return this.getFileManagementCilent(clientType);
    }

    public FileManagementCilent getFileManagementCilent(String clientType) {
        if ("fastdfs".equalsIgnoreCase(clientType)) {
            FastDFSClient fastDFSClient = new FastDFSClient();
            fastDFSClient.init(this.applicationProperties.getFastdfsTrackIp());
            return fastDFSClient;
        }
        if ("localdisk".equalsIgnoreCase(clientType)) {
            LocalDiskClient localDiskClient = new LocalDiskClient();
            localDiskClient.init(this.applicationProperties.getLocalDiskPath());
            return localDiskClient;
        }
        return null;
    }

    public FileManagementCilent getFileManagementCilent(String clientType, String connectionParam) {
        if ("fastdfs".equalsIgnoreCase(clientType)) {
            FastDFSClient fastDFSClient = new FastDFSClient();
            fastDFSClient.init(connectionParam);
            return fastDFSClient;
        }
        if ("localdisk".equalsIgnoreCase(clientType)) {
            LocalDiskClient localDiskClient = new LocalDiskClient();
            localDiskClient.init(connectionParam);
            return localDiskClient;
        }
        return null;
    }
}

