/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.excel;

import cn.com.yusys.yusp.commons.config.ApplicationProperties;
import cn.com.yusys.yusp.commons.excel.ExcelExportThread;
import cn.com.yusys.yusp.commons.excel.ExcelImportExportUtil;
import cn.com.yusys.yusp.commons.excel.ExcelImportThread;
import cn.com.yusys.yusp.commons.excel.ExcelRemoteCall;
import cn.com.yusys.yusp.commons.file.FileManagementCilentFactory;
import cn.com.yusys.yusp.commons.mapper.QueryModel;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.web.multipart.MultipartFile;

public class ExcelTaskManager
implements InitializingBean {
    public static final String DEFAULT_DATETIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final String REDIS_TASKTYPE_KEY = "taskType";
    public static final String REDIS_PERCENT_KEY = "percent";
    public static final String REDIS_FILENAME_KEY = "fileName";
    public static final String REDIS_FASTDFS_KEY = "fastDFSUuid";
    public static final String EXCEL_POSTFIX = ".xlsx";
    public static final String IMPORT_TASK_TYPE = "import";
    public static final String EXPORT_TASK_TYPE = "export";
    public static String EXCEL_FILE_DIR = System.getProperty("user.dir") + File.separator;
    public static Integer BATCH_SIZE = 10;
    @Autowired
    SqlSessionFactory sqlSessionFactory;
    @Autowired
    Executor taskExecutor;
    @Autowired
    StringRedisTemplate stringRedisTemplate;
    @Autowired
    ApplicationProperties applicationProperties;
    @Autowired
    FileManagementCilentFactory fileManagementCilentFactory;
    @Autowired(required=false)
    ExcelRemoteCall excelRemoteCall;

    public String addExcelExportTask(String sqlId, Integer fetchSize, QueryModel queryModel, String clazzName) {
        String taskId = "failure";
        taskId = ExcelImportExportUtil.addRedisTaskInfo(EXPORT_TASK_TYPE, this.stringRedisTemplate);
        try {
            Class<?> clazz = Class.forName(clazzName);
            ExcelExportThread exportTask = new ExcelExportThread(sqlId, fetchSize, queryModel, taskId, clazz, this.stringRedisTemplate, this.sqlSessionFactory, this.excelRemoteCall, this.fileManagementCilentFactory);
            this.taskExecutor.execute(exportTask);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return taskId;
    }

    public String addExcelExportTaskByDataList(List<?> dataList, Integer fetchSize, QueryModel queryModel, String clazzName) {
        String taskId = "failure";
        taskId = ExcelImportExportUtil.addRedisTaskInfo(EXPORT_TASK_TYPE, this.stringRedisTemplate);
        try {
            Class<?> clazz = Class.forName(clazzName);
            ExcelExportThread exportTask = new ExcelExportThread(dataList, taskId, clazz, this.stringRedisTemplate, this.excelRemoteCall, this.fileManagementCilentFactory);
            this.taskExecutor.execute(exportTask);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return taskId;
    }

    public String addExcelImportTask(MultipartFile file, String clazzName, String sqlId) {
        String taskId = "failure";
        try {
            String fileName = new String(file.getOriginalFilename().getBytes(), "UTF-8");
            File newFile = new File(EXCEL_FILE_DIR + fileName);
            file.transferTo(newFile);
            Class<?> clazz = Class.forName(clazzName);
            taskId = ExcelImportExportUtil.addRedisTaskInfo(IMPORT_TASK_TYPE, this.stringRedisTemplate);
            ExcelImportThread importTask = new ExcelImportThread(fileName, taskId, sqlId, clazz, this.stringRedisTemplate, this.sqlSessionFactory, this.excelRemoteCall);
            this.taskExecutor.execute(importTask);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return taskId;
    }

    public void afterPropertiesSet() throws Exception {
        File fileDir;
        String excelFileDir = this.applicationProperties.getExcel().getTempFileDir();
        if (excelFileDir != null && !(fileDir = new File(EXCEL_FILE_DIR = excelFileDir.endsWith("/") || excelFileDir.endsWith("\\") ? excelFileDir : excelFileDir + File.separator)).exists()) {
            fileDir.mkdir();
        }
        BATCH_SIZE = this.applicationProperties.getExcel().getBatchSize();
    }
}

