/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.excel;

import cn.com.yusys.yusp.commons.domain.ExcelColumnDomain;
import cn.com.yusys.yusp.commons.excel.ExcelImportExportUtil;
import cn.com.yusys.yusp.commons.excel.ExcelRemoteCall;
import cn.com.yusys.yusp.commons.excel.ExcelTaskManager;
import cn.com.yusys.yusp.commons.excel.annotation.ExcelName;
import cn.com.yusys.yusp.commons.file.FileManagementCilent;
import cn.com.yusys.yusp.commons.file.FileManagementCilentFactory;
import cn.com.yusys.yusp.commons.mapper.QueryModel;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.util.CollectionUtils;

public class ExcelExportThread
implements Runnable {
    String sqlId;
    Integer fetchSize;
    QueryModel queryModel;
    String taskId;
    Class<?> clazz;
    StringRedisTemplate redisTemplate;
    SqlSessionFactory sqlSessionFactory;
    ExcelRemoteCall excelRemoteCall;
    List<?> dataList;
    FileManagementCilentFactory fileManagementCilentFactory;

    public ExcelExportThread(List<?> dataList, String taskId, Class<?> clazz, StringRedisTemplate redisTemplate, ExcelRemoteCall excelRemoteCall, FileManagementCilentFactory fileManagementCilentFactory) {
        this.clazz = clazz;
        this.taskId = taskId;
        this.dataList = dataList;
        this.redisTemplate = redisTemplate;
        this.excelRemoteCall = excelRemoteCall;
        this.fileManagementCilentFactory = fileManagementCilentFactory;
    }

    public ExcelExportThread(String sqlId, Integer fetchSize, QueryModel queryModel, String taskId, Class<?> clazz, StringRedisTemplate redisTemplate, SqlSessionFactory sqlSessionFactory, ExcelRemoteCall excelRemoteCall, FileManagementCilentFactory fileManagementCilentFactory) {
        this.sqlId = sqlId;
        this.fetchSize = fetchSize;
        this.taskId = taskId;
        this.clazz = clazz;
        this.redisTemplate = redisTemplate;
        this.sqlSessionFactory = sqlSessionFactory;
        this.queryModel = queryModel;
        this.excelRemoteCall = excelRemoteCall;
        this.fileManagementCilentFactory = fileManagementCilentFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        SqlSession sqlSession = null;
        SXSSFWorkbook wb = null;
        FileOutputStream fileOut = null;
        File file = null;
        FileManagementCilent fastDFSClient = this.fileManagementCilentFactory.getFileManagementCilent();
        String fileName = "Excel\u5bfc\u51fa";
        String sheetName = "\u6570\u636e\u8868";
        try {
            if (this.clazz.isAnnotationPresent(ExcelName.class)) {
                ExcelName classAnnotation = this.clazz.getDeclaredAnnotation(ExcelName.class);
                fileName = classAnnotation.value();
                sheetName = classAnnotation.sheet();
            }
            if (!fileName.endsWith(".xlsx")) {
                fileName = fileName + ".xlsx";
            }
            Map<String, ExcelColumnDomain> columnMap = ExcelImportExportUtil.getColumnMap(this.clazz);
            wb = new SXSSFWorkbook(100);
            SXSSFSheet sheet = wb.createSheet(sheetName);
            Row titleRow = sheet.createRow(0);
            CellStyle cellStyle = wb.createCellStyle();
            cellStyle.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.index);
            cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            cellStyle.setBorderBottom(BorderStyle.THIN);
            cellStyle.setBorderLeft(BorderStyle.THIN);
            cellStyle.setBorderRight(BorderStyle.THIN);
            cellStyle.setBorderTop(BorderStyle.THIN);
            cellStyle.setAlignment(HorizontalAlignment.CENTER);
            ExcelImportExportUtil.assembleTitle(titleRow, cellStyle, columnMap);
            if (null != this.sqlSessionFactory && null != this.sqlId) {
                sqlSession = this.sqlSessionFactory.openSession();
                Page page = PageHelper.startPage((int)0, (int)1);
                if (this.queryModel == null) {
                    this.queryModel = new QueryModel();
                }
                sqlSession.selectList(this.sqlId, (Object)this.queryModel);
                int totalCount = new Long(page.getTotal()).intValue();
                PageHelper.clearPage();
                if (null != this.fetchSize && this.fetchSize < totalCount) {
                    totalCount = this.fetchSize;
                }
                int queryTimes = totalCount % ExcelTaskManager.BATCH_SIZE == 0 ? totalCount / ExcelTaskManager.BATCH_SIZE : totalCount / ExcelTaskManager.BATCH_SIZE + 1;
                for (int i = 0; i < queryTimes; ++i) {
                    PageHelper.startPage((int)(i + 1), (int)ExcelTaskManager.BATCH_SIZE);
                    Thread.sleep(2000L);
                    List resultBatchList = sqlSession.selectList(this.sqlId, (Object)this.queryModel);
                    PageHelper.clearPage();
                    ExcelImportExportUtil.assembleData(resultBatchList, (Sheet)sheet, i * ExcelTaskManager.BATCH_SIZE, this.fetchSize, columnMap, this.clazz, this.excelRemoteCall);
                    resultBatchList.clear();
                    int percent = ExcelImportExportUtil.getPercentInt(i + 1, queryTimes);
                    percent = percent == 100 ? 99 : percent;
                    ExcelImportExportUtil.updateRedisTaskInfo(this.taskId, "export", percent, fileName, null, this.redisTemplate);
                }
            } else if (!CollectionUtils.isEmpty(this.dataList)) {
                ExcelImportExportUtil.assembleData(this.dataList, (Sheet)sheet, 1, this.fetchSize, columnMap, this.clazz, this.excelRemoteCall);
                ExcelImportExportUtil.updateRedisTaskInfo(this.taskId, "export", 99, fileName, null, this.redisTemplate);
            }
            String completFilePath = ExcelTaskManager.EXCEL_FILE_DIR + fileName;
            fileOut = new FileOutputStream(completFilePath);
            wb.write((OutputStream)fileOut);
            file = new File(completFilePath);
            fastDFSClient.initConnection();
            String fastDFSUuid = fastDFSClient.uploadFile(file);
            ExcelImportExportUtil.updateRedisTaskInfo(this.taskId, "export", 100, fileName, fastDFSUuid, this.redisTemplate);
        }
        catch (Exception e) {
            e.printStackTrace();
            ExcelImportExportUtil.updateRedisTaskInfo(this.taskId, "export", -1, fileName, null, this.redisTemplate);
        }
        finally {
            try {
                if (null != fastDFSClient) {
                    fastDFSClient.closeConnection();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                if (null != sqlSession) {
                    sqlSession.clearCache();
                    sqlSession.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                if (null != fileOut) {
                    fileOut.close();
                }
                if (null != wb) {
                    wb.dispose();
                    wb.close();
                }
                if (null != file && file.exists()) {
                    file.delete();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

