/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.config;

import ch.qos.logback.classic.AsyncAppender;
import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.pattern.ThrowableHandlingConverter;
import ch.qos.logback.classic.spi.LoggerContextListener;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.spi.ContextAwareBase;
import io.github.jhipster.config.JHipsterProperties;
import net.logstash.logback.appender.LogstashSocketAppender;
import net.logstash.logback.stacktrace.ShortenedThrowableConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;

@Configuration
public class LoggingConfiguration {
    private final Logger log = LoggerFactory.getLogger(LoggingConfiguration.class);
    private LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
    private final String appName;
    private final String serverPort;
    private final String instanceId;
    private final JHipsterProperties jHipsterProperties;

    public LoggingConfiguration(@Value(value="${spring.application.name}") String appName, @Value(value="${server.port}") String serverPort, @Value(value="${eureka.instance.instanceId}") String instanceId, JHipsterProperties jHipsterProperties) {
        this.appName = appName;
        this.serverPort = serverPort;
        this.instanceId = instanceId;
        this.jHipsterProperties = jHipsterProperties;
        if (jHipsterProperties.getLogging().getLogstash().isEnabled()) {
            this.addLogstashAppender(this.context);
            LogbackLoggerContextListener loggerContextListener = new LogbackLoggerContextListener();
            loggerContextListener.setContext((Context)this.context);
            this.context.addListener((LoggerContextListener)loggerContextListener);
        }
    }

    public void addLogstashAppender(LoggerContext context) {
        this.log.info("Initializing Logstash logging");
        LogstashSocketAppender logstashAppender = new LogstashSocketAppender();
        logstashAppender.setName("LOGSTASH");
        logstashAppender.setContext((Context)context);
        String customFields = "{\"app_name\":\"" + this.appName + "\",\"app_port\":\"" + this.serverPort + "\"," + "\"instance_id\":\"" + this.instanceId + "\"}";
        logstashAppender.setSyslogHost(this.jHipsterProperties.getLogging().getLogstash().getHost());
        logstashAppender.setPort(this.jHipsterProperties.getLogging().getLogstash().getPort());
        logstashAppender.setCustomFields(customFields);
        ShortenedThrowableConverter throwableConverter = new ShortenedThrowableConverter();
        throwableConverter.setMaxLength(7500);
        throwableConverter.setRootCauseFirst(true);
        logstashAppender.setThrowableConverter((ThrowableHandlingConverter)throwableConverter);
        logstashAppender.start();
        AsyncAppender asyncLogstashAppender = new AsyncAppender();
        asyncLogstashAppender.setContext((Context)context);
        asyncLogstashAppender.setName("ASYNC_LOGSTASH");
        asyncLogstashAppender.setQueueSize(this.jHipsterProperties.getLogging().getLogstash().getQueueSize());
        asyncLogstashAppender.addAppender((Appender)logstashAppender);
        asyncLogstashAppender.start();
        context.getLogger("ROOT").addAppender((Appender)asyncLogstashAppender);
    }

    class LogbackLoggerContextListener
    extends ContextAwareBase
    implements LoggerContextListener {
        LogbackLoggerContextListener() {
        }

        public boolean isResetResistant() {
            return true;
        }

        public void onStart(LoggerContext context) {
            LoggingConfiguration.this.addLogstashAppender(context);
        }

        public void onReset(LoggerContext context) {
            LoggingConfiguration.this.addLogstashAppender(context);
        }

        public void onStop(LoggerContext context) {
        }

        public void onLevelChange(ch.qos.logback.classic.Logger logger, Level level) {
        }
    }
}

