/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.aop.dataauth;

import cn.com.yusys.yusp.commons.aop.dataauth.handler.DataAuthParamHander;
import cn.com.yusys.yusp.commons.mapper.interceptor.DataAuthHandler;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Map;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Aspect
public class DataAuthAspect {
    private final Logger log = LoggerFactory.getLogger(DataAuthAspect.class);
    public static final String DATAAUTH_SQLNAME = "dataAuthSqlName";
    public static final String DATAAUTH_TEMPLATE = "dataAuthTemplate";
    public static final String DATAAUTH_PARAMS = "dataAuthParams";
    public static final String DATAAUTH_HEADER_ENC = "UTF-8";
    public static final String POINTCUT_EXPRESS = "within(cn.com.yusys..*) && (@target(org.springframework.web.bind.annotation.RestController) || @target(org.springframework.stereotype.Controller))";
    private DataAuthParamHander dataAuthParamHander;

    public DataAuthAspect(DataAuthParamHander dataAuthParamHander) {
        this.dataAuthParamHander = dataAuthParamHander;
    }

    public void pointcut() {
    }

    public void before(JoinPoint point) {
    }

    public void after(JoinPoint point) {
        DataAuthHandler.dataAuthTemplate.remove();
        DataAuthHandler.dataAuthParams.remove();
    }

    protected Map<String, Object> getDataAuthParams(String dataAuthParams) throws UnsupportedEncodingException {
        String decodeDataAuthParams = URLDecoder.decode(dataAuthParams, DATAAUTH_HEADER_ENC);
        return this.dataAuthParamHander.getParams(decodeDataAuthParams);
    }
}

