/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.mapper.interceptor;

import cn.com.yusys.yusp.commons.mapper.interceptor.AbstractDataAuthHandler;
import cn.com.yusys.yusp.commons.mapper.interceptor.BeanUtil;
import cn.com.yusys.yusp.commons.mapper.interceptor.DataAuthHandler;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDataAuthHandler
extends AbstractDataAuthHandler {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    public String getTemplate(String sqlId) {
        String dataAuthTemplate = DataAuthHandler.dataAuthTemplate.get();
        return dataAuthTemplate;
    }

    @Override
    public Map<String, Object> getParams(String sqlId) {
        Map<String, Object> params = DataAuthHandler.dataAuthParams.get();
        if (params == null) {
            params = new HashMap<String, Object>();
        }
        return params;
    }

    @Override
    public String replaceTemplateParams(String sqlId, String template, Map<String, Object> params) {
        String newTemplate = template;
        String reg = "\\$\\{[a-zA-Z0-9_]+\\}";
        Pattern pattern = Pattern.compile(reg);
        Matcher matcher = pattern.matcher(newTemplate);
        while (matcher.find()) {
            String matchWord = matcher.group(0);
            String key = matchWord.substring(2, matchWord.length() - 1);
            Object value = params.get(key);
            if (value == null) continue;
            if (value instanceof String || value instanceof Character) {
                newTemplate = newTemplate.replace(matchWord, this.getSqlParam(value));
                continue;
            }
            if (value instanceof List) {
                StringBuilder authValue = new StringBuilder();
                List values = (List)value;
                for (int i = 0; i < values.size(); ++i) {
                    if (i == 0) {
                        authValue.append(this.getSqlParam(values.get(i)));
                        continue;
                    }
                    authValue.append(",").append(this.getSqlParam(values.get(i)));
                }
                continue;
            }
            newTemplate = newTemplate.replace(matchWord, this.getSqlParam(value));
        }
        return newTemplate;
    }

    private String getSqlParam(Object value) {
        if (value instanceof String || value instanceof Character) {
            return "'" + value + "'";
        }
        return value.toString();
    }

    @Override
    public boolean setDataAuthParams(Object queryParameter, String dataAuth) {
        boolean setSuccess = false;
        if (queryParameter instanceof Map) {
            Map mapParamter = (Map)queryParameter;
            mapParamter.put("dataAuth", dataAuth);
            setSuccess = true;
        } else {
            try {
                Field field = BeanUtil.findFieldWithParent(queryParameter.getClass(), "dataAuth");
                if (field != null) {
                    BeanUtil.setFieldValue(queryParameter, field, dataAuth);
                    setSuccess = true;
                } else {
                    this.log.warn("Unable to set recordset permission in parameterdataAuth");
                }
            }
            catch (Exception e) {
                this.log.error("Recordset permission setting error", (Throwable)e);
            }
        }
        return setSuccess;
    }

    @Override
    public boolean clearDataAuthField(Object queryParameter) {
        boolean setSuccess = false;
        if (queryParameter instanceof Map) {
            Map mapParamter = (Map)queryParameter;
            mapParamter.put("dataAuth", null);
            setSuccess = true;
        } else {
            try {
                Field field = BeanUtil.findFieldWithParent(queryParameter.getClass(), "dataAuth");
                if (field != null) {
                    BeanUtil.setFieldValue(queryParameter, field, null);
                    setSuccess = true;
                }
            }
            catch (Exception e) {
                this.log.debug("Error clearing recordset permission field" + e.toString());
            }
        }
        return setSuccess;
    }
}

