/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.mapper.interceptor;

import cn.com.yusys.yusp.commons.mapper.interceptor.BeanUtil;
import cn.com.yusys.yusp.commons.mapper.interceptor.DataAuthHandler;
import cn.com.yusys.yusp.commons.mapper.interceptor.ValueGenerator;
import cn.com.yusys.yusp.commons.mapper.provider.OGNLUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;

public class CommonInterceptor
implements Interceptor {
    protected boolean basic2Map = false;
    protected DataAuthHandler dataAuthHandler;
    protected List<ValueGenerator> valueGenerators = new ArrayList<ValueGenerator>();

    public CommonInterceptor() {
    }

    public CommonInterceptor(boolean basic2Map, DataAuthHandler dataAuthHandler, List<ValueGenerator> valueGenerators) {
        this.basic2Map = basic2Map;
        this.dataAuthHandler = dataAuthHandler;
        this.valueGenerators = valueGenerators;
    }

    public Object intercept(Invocation invocation) throws Throwable {
        Object parameter;
        Object[] args = invocation.getArgs();
        MappedStatement ms = (MappedStatement)args[0];
        SqlCommandType commandType = ms.getSqlCommandType();
        this.handBasic2Map(args);
        if (commandType.equals((Object)SqlCommandType.SELECT)) {
            this.handDataAuth(args);
        } else if (commandType.equals((Object)SqlCommandType.INSERT)) {
            parameter = invocation.getArgs()[1];
            this.handValueGenerate(commandType, parameter);
            this.handDataAuth(args);
        } else if (commandType.equals((Object)SqlCommandType.UPDATE)) {
            parameter = invocation.getArgs()[1];
            this.handValueGenerate(commandType, parameter);
            this.handDataAuth(args);
        } else if (commandType.equals((Object)SqlCommandType.DELETE)) {
            this.handDataAuth(args);
        }
        Object proceed = invocation.proceed();
        return proceed;
    }

    protected boolean handBasic2Map(Object[] args) {
        if (this.basic2Map) {
            MappedStatement ms = (MappedStatement)args[0];
            Object parameter = args[1];
            if (parameter == null || OGNLUtil.isBasic(parameter)) {
                HashMap newParameter = new HashMap();
                BoundSql boundSql = ms.getBoundSql(parameter);
                Object parameterObject = boundSql.getParameterObject();
                System.out.println(parameterObject);
                args[1] = newParameter;
                return true;
            }
            return false;
        }
        return false;
    }

    protected boolean handDataAuth(Object[] args) {
        if (this.dataAuthHandler != null) {
            MappedStatement ms = (MappedStatement)args[0];
            Object parameter = args[1];
            String sqlId = ms.getId();
            return this.dataAuthHandler.handDataAuth(sqlId, parameter);
        }
        return false;
    }

    protected void handValueGenerate(SqlCommandType commandType, Object domain) {
        if (this.valueGenerators == null || this.valueGenerators.isEmpty()) {
            return;
        }
        List<Field> allFields = BeanUtil.findAllFields(domain.getClass());
        for (Field field : allFields) {
            this.generateFieldValue(commandType, domain, field);
        }
    }

    protected void generateFieldValue(SqlCommandType commandType, Object domain, Field field) {
        for (ValueGenerator generator : this.valueGenerators) {
            if (!generator.check(commandType, domain, field)) continue;
            generator.generate(domain, field);
            break;
        }
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
    }
}

