/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.text.read;

import cn.com.yusys.yusp.commons.text.Record;
import cn.com.yusys.yusp.commons.text.TextExportImportConfig;
import cn.com.yusys.yusp.commons.text.TextProperties;
import cn.com.yusys.yusp.commons.text.cache.CacheManager;
import cn.com.yusys.yusp.commons.util.SpringContextUtil;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportFileConfig
extends TextExportImportConfig {
    public static Logger logger = LoggerFactory.getLogger(ImportFileConfig.class);
    private String importTemplateFilePath;
    private static final String IMPORT_TEMPLATE_FILE_CACHE_KEY = "import.template.file.cache.key";
    private static final ImportFileConfig instance = ImportFileConfigHandler.access$000();
    private static boolean loadEnd = false;

    private ImportFileConfig() {
    }

    public static final synchronized ImportFileConfig instance() {
        if (!loadEnd) {
            instance.init();
        }
        return instance;
    }

    @Override
    protected void init() {
        TextProperties textProperties = (TextProperties)SpringContextUtil.getBean(TextProperties.class);
        this.importTemplateFilePath = textProperties.getImpTempletePath();
        ConcurrentHashMap<String, List<Record>> recordConfigs = new ConcurrentHashMap<String, List<Record>>();
        try {
            this.loadConfigFile(recordConfigs, this.importTemplateFilePath);
            CacheManager.addCache(IMPORT_TEMPLATE_FILE_CACHE_KEY, recordConfigs);
        }
        catch (Exception e) {
            logger.error("Failed to export template file to cache!", (Throwable)e);
        }
        loadEnd = true;
    }

    @Override
    public List<Record> getTemplateRecords(String name) throws Exception {
        return (List)CacheManager.getCacheObject(IMPORT_TEMPLATE_FILE_CACHE_KEY, name);
    }

    private static final class ImportFileConfigHandler {
        private static final ImportFileConfig INSTANCE = new ImportFileConfig();

        private ImportFileConfigHandler() {
        }

        static /* synthetic */ ImportFileConfig access$000() {
            return INSTANCE;
        }
    }
}

