/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.text.read;

import cn.com.yusys.yusp.commons.text.Record;
import cn.com.yusys.yusp.commons.text.read.ImportFileConfig;
import cn.com.yusys.yusp.commons.util.BeanUtil;
import cn.com.yusys.yusp.commons.util.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class ImportAnalyser {
    public static <T> T getReadData(String lineText, List<Record> records, String dataSplit, boolean existKey, String keyValueSplit, Class<T> clazz) throws Exception {
        Object object = null;
        if (Objects.nonNull(clazz) && StringUtil.isNotEmpty((CharSequence)lineText) && Objects.nonNull(records) && !records.isEmpty()) {
            String[] texts = lineText.split("\\" + dataSplit, -1);
            object = BeanUtil.newInstance(clazz);
            for (int i = 0; i < texts.length; ++i) {
                if (i >= records.size()) continue;
                String text = texts[i];
                Record record = records.get(i);
                String name = record.getName();
                String value = null;
                if (existKey) {
                    String[] keyValue = text.split(keyValueSplit);
                    if (keyValue.length == 2) {
                        name = StringUtil.isNotEmpty((CharSequence)record.getAliasName()) && keyValue[0].equals(record.getAliasName()) ? keyValue[0] : record.getName();
                        value = keyValue[1];
                    }
                } else {
                    value = text;
                }
                BeanUtil.setProptery((Object)object, (String)name, (Object)value);
            }
        }
        return (T)object;
    }

    public static <T> List<T> getReadData(Collection<String> lineTexts, List<Record> records, String dataSplit, boolean existKey, String keyValueSplit, Class<T> clazz) throws Exception {
        ArrayList<T> list = new ArrayList<T>();
        if (Objects.nonNull(clazz) && Objects.nonNull(lineTexts) && !lineTexts.isEmpty() && Objects.nonNull(records) && !records.isEmpty()) {
            for (String lineText : lineTexts) {
                T dataObjct = ImportAnalyser.getReadData(lineText, records, dataSplit, existKey, keyValueSplit, clazz);
                list.add(dataObjct);
            }
        }
        return list;
    }

    public static <T> List<T> getReadData(Collection<String> lineTexts, String readTemplateName, String dataSplit, boolean existKey, String keyValueSplit, Class<T> clazz) throws Exception {
        List<Record> records = ImportFileConfig.instance().getTemplateRecords(readTemplateName);
        return ImportAnalyser.getReadData(lineTexts, records, dataSplit, existKey, keyValueSplit, clazz);
    }
}

