/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.text;

import cn.com.yusys.yusp.commons.text.Record;
import cn.com.yusys.yusp.commons.text.W3CDocumentUtil;
import cn.com.yusys.yusp.commons.util.CommonUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class TextExportImportConfig {
    public static Logger logger = LoggerFactory.getLogger(TextExportImportConfig.class);

    protected TextExportImportConfig() {
    }

    protected abstract void init();

    public abstract List<Record> getTemplateRecords(String var1) throws Exception;

    protected void loadConfigFile(Map<String, List<Record>> mapRecords, String filePath) throws Exception {
        Object[] resources = new PathMatchingResourcePatternResolver().getResources(filePath);
        if (CommonUtil.nonNullOrEmpty((Object[])resources)) {
            for (Object resource : resources) {
                this.loadXmlFileObject(mapRecords, (Resource)resource);
            }
        }
    }

    protected void loadXmlFileObject(Map<String, List<Record>> mapRecords, Resource resource) {
        Document doc = null;
        try {
            logger.info("Current file:" + resource.getFilename() + ", read start......");
            doc = W3CDocumentUtil.loadXMLDocument(resource);
            Node rootNode = doc.getElementsByTagName("file").item(0);
            NodeList nodeList = rootNode.getChildNodes();
            ArrayList<Record> entityList = new ArrayList<Record>(nodeList.getLength());
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Record record;
                Node node = nodeList.item(i);
                if (1 != node.getNodeType() || !Objects.nonNull(record = this.node2Record(node))) continue;
                entityList.add(record.getLocation() - 1, record);
            }
            logger.info("Current file:" + resource.getFilename() + ", read end......");
            mapRecords.put(W3CDocumentUtil.getNodeAttrValue(rootNode, "name"), entityList);
        }
        catch (Exception e) {
            logger.error("Read file:" + resource.getFilename() + " , exception occurred, skip loading by default!", (Throwable)e);
        }
    }

    protected Record node2Record(Node node) {
        Record record = null;
        try {
            record = new Record();
            record = W3CDocumentUtil.nodeAttr2Bean(node, record);
            if (Objects.isNull(record) || !record.check()) {
                logger.error("Current node verification failed!");
                throw new Exception("Current node verification failed!");
            }
        }
        catch (Exception e) {
            String nodeName = W3CDocumentUtil.getNodeAttrValue(node, "name");
            logger.error("Current node:" + nodeName + ", exception occurred, skip loading by default!", (Throwable)e);
        }
        return record;
    }
}

