/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.text.write;

import cn.com.yusys.yusp.commons.text.Record;
import cn.com.yusys.yusp.commons.text.TextExportImportConfig;
import cn.com.yusys.yusp.commons.text.TextProperties;
import cn.com.yusys.yusp.commons.text.cache.CacheManager;
import cn.com.yusys.yusp.commons.util.SpringContextUtil;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportFileConfig
extends TextExportImportConfig {
    public static Logger logger = LoggerFactory.getLogger(ExportFileConfig.class);
    private String exportTemplateFilePath;
    private static final String EXPORT_TEMPLATE_FILE_CACHE_KEY = "export.template.file.cache.key";
    private static final ExportFileConfig instance = ExportFileConfigHandler.access$000();
    private static boolean loadEnd = false;

    private ExportFileConfig() {
    }

    public static final synchronized ExportFileConfig instance() {
        if (!loadEnd) {
            instance.init();
        }
        return instance;
    }

    @Override
    protected void init() {
        TextProperties textProperties = (TextProperties)SpringContextUtil.getBean(TextProperties.class);
        this.exportTemplateFilePath = textProperties.getExpTempletePath();
        ConcurrentHashMap<String, List<Record>> recordConfigs = new ConcurrentHashMap<String, List<Record>>();
        try {
            this.loadConfigFile(recordConfigs, this.exportTemplateFilePath);
            CacheManager.addCache(EXPORT_TEMPLATE_FILE_CACHE_KEY, recordConfigs);
        }
        catch (Exception e) {
            logger.error("Failed to export template file to cache!", (Throwable)e);
        }
        loadEnd = true;
    }

    @Override
    public List<Record> getTemplateRecords(String name) throws Exception {
        return (List)CacheManager.getCacheObject(EXPORT_TEMPLATE_FILE_CACHE_KEY, name);
    }

    private static final class ExportFileConfigHandler {
        private static final ExportFileConfig INSTANCE = new ExportFileConfig();

        private ExportFileConfigHandler() {
        }

        static /* synthetic */ ExportFileConfig access$000() {
            return INSTANCE;
        }
    }
}

