/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.text;

import cn.com.yusys.yusp.commons.util.BeanUtil;
import java.util.Objects;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class W3CDocumentUtil {
    public static final String getNodeAttrValue(NamedNodeMap nodeMap, String name) {
        String str = null;
        Node node = nodeMap.getNamedItem(name);
        if (Objects.nonNull(node)) {
            str = node.getNodeValue();
        }
        return str;
    }

    public static final String getNodeAttrValue(Node node, String name) {
        if (Objects.nonNull(node)) {
            return W3CDocumentUtil.getNodeAttrValue(node.getAttributes(), name);
        }
        return null;
    }

    public static final <T> T nodeAttr2Bean(Node node, T bean) throws Exception {
        if (Objects.nonNull(node) && Objects.nonNull(bean)) {
            NamedNodeMap nodeMap = node.getAttributes();
            for (int i = 0; i < nodeMap.getLength(); ++i) {
                Node attrNode = nodeMap.item(i);
                String name = attrNode.getNodeName();
                String value = attrNode.getNodeValue();
                BeanUtil.setProptery(bean, (String)name, (Object)value);
            }
        }
        return bean;
    }

    public static final <T> T nodeAttr2Bean(Node node, Class<T> clazz) throws Exception {
        return W3CDocumentUtil.nodeAttr2Bean(node, clazz.newInstance());
    }

    public static final Document loadXMLDocument(Resource resource) throws Exception {
        try {
            Document document;
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            InputSource inputSource = new InputSource();
            inputSource.setByteStream(resource.getInputStream());
            Document document2 = document = builder.parse(inputSource);
            return document2;
        }
        catch (Exception e) {
            LoggerFactory.getLogger(W3CDocumentUtil.class).error("Exception reading XML file:" + resource.getFilename(), (Throwable)e);
            throw e;
        }
    }
}

