/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.excel;

import cn.com.yusys.yusp.commons.domain.ExcelColumnDomain;
import cn.com.yusys.yusp.commons.excel.ExcelPrimaryId;
import cn.com.yusys.yusp.commons.excel.ExcelRemoteCall;
import cn.com.yusys.yusp.commons.excel.annotation.ExcelColumn;
import cn.com.yusys.yusp.commons.excel.annotation.ExcelColumnDateformat;
import cn.com.yusys.yusp.commons.excel.annotation.ExcelColumnDictCode;
import cn.com.yusys.yusp.commons.excel.annotation.ExcelColumnPrecision;
import cn.com.yusys.yusp.commons.excel.annotation.ExcelColumnPricision;
import cn.com.yusys.yusp.commons.excel.annotation.ExcelId;
import cn.com.yusys.yusp.commons.util.BeanUtils;
import cn.com.yusys.yusp.commons.util.StringUtil;
import java.beans.IntrospectionException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class ExcelImportExportUtil {
    private static Logger logger = LoggerFactory.getLogger(ExcelImportExportUtil.class);
    private static Map<String, Map<String, String>> dictCodeMap = new HashMap<String, Map<String, String>>();

    public static String addRedisTaskInfo(String taskType, StringRedisTemplate stringRedisTemplate, long timeout) {
        String taskId = UUID.randomUUID().toString().toLowerCase().replace("-", "");
        JSONObject jo = new JSONObject();
        try {
            jo.put("taskType", (Object)taskType);
            jo.put("percent", 0);
        }
        catch (JSONException e) {
            logger.error("addRedisTaskInfo Error: " + e.getMessage(), (Throwable)e);
        }
        stringRedisTemplate.opsForValue().set((Object)ExcelImportExportUtil.getAsyncExcelExportTaskId(taskId), (Object)jo.toString(), timeout, TimeUnit.MINUTES);
        return taskId;
    }

    public static void updateRedisTaskInfo(String taskId, String taskType, Integer percent, String fileName, String fastDFSUuid, StringRedisTemplate stringRedisTemplate, long timeout) {
        JSONObject jo = new JSONObject();
        try {
            jo.put("taskType", (Object)taskType);
            jo.put("percent", (Object)percent);
            jo.put("fileName", (Object)fileName);
            if (!StringUtils.isEmpty((Object)fastDFSUuid)) {
                jo.put("fastDFSUuid", (Object)fastDFSUuid);
            }
        }
        catch (JSONException e) {
            logger.error("updateRedisTaskInfo Error: " + e.getMessage(), (Throwable)e);
        }
        stringRedisTemplate.opsForValue().set((Object)ExcelImportExportUtil.getAsyncExcelExportTaskId(taskId), (Object)jo.toString(), timeout, TimeUnit.MINUTES);
    }

    private static String getAsyncExcelExportTaskId(String taskId) {
        return StringUtil.builder((int)100, (Object[])new Object[]{"AsyncExcelExport:", taskId});
    }

    public static JSONObject getRedisTaskInfo(String taskId, StringRedisTemplate stringRedisTemplate) {
        String result = (String)stringRedisTemplate.opsForValue().get((Object)ExcelImportExportUtil.getAsyncExcelExportTaskId(taskId));
        JSONObject jo = new JSONObject();
        try {
            if (!StringUtils.isEmpty((Object)result)) {
                jo = new JSONObject(result);
            }
        }
        catch (JSONException e) {
            logger.error("getRedisTaskInfo Error: " + e.getMessage(), (Throwable)e);
        }
        return jo;
    }

    public static SXSSFWorkbook exportTemplate(Class<?> clazz) {
        SXSSFWorkbook wb = null;
        Map<String, ExcelColumnDomain> columnMap = ExcelImportExportUtil.getColumnMap(clazz);
        wb = new SXSSFWorkbook(100);
        SXSSFSheet sh = wb.createSheet();
        Row titleRow = sh.createRow(0);
        CellStyle cellStyle = wb.createCellStyle();
        cellStyle.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.index);
        cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        cellStyle.setBorderBottom(BorderStyle.THIN);
        cellStyle.setBorderLeft(BorderStyle.THIN);
        cellStyle.setBorderRight(BorderStyle.THIN);
        cellStyle.setBorderTop(BorderStyle.THIN);
        cellStyle.setAlignment(HorizontalAlignment.CENTER);
        Font font = wb.createFont();
        font.setFontHeightInPoints((short)12);
        cellStyle.setFont(font);
        ExcelImportExportUtil.assembleTitle(titleRow, cellStyle, columnMap);
        return wb;
    }

    public static Map<Integer, Field> getColumnIndexMap(Class<?> clazz) {
        Field[] declaredFields;
        HashMap<Integer, Field> columnMap = new HashMap<Integer, Field>();
        for (Field field : declaredFields = clazz.getDeclaredFields()) {
            if (!field.isAnnotationPresent(ExcelColumn.class)) continue;
            ExcelColumn column = field.getAnnotation(ExcelColumn.class);
            columnMap.put(column.index(), field);
        }
        return columnMap;
    }

    public static Map<String, ExcelColumnDomain> getColumnMap(Class<?> clazz) {
        Field[] declaredFields;
        HashMap<String, ExcelColumnDomain> columnMap = new HashMap<String, ExcelColumnDomain>();
        for (Field field : declaredFields = clazz.getDeclaredFields()) {
            ExcelColumnDomain columnDomain = new ExcelColumnDomain();
            if (!field.isAnnotationPresent(ExcelColumn.class)) continue;
            ExcelColumn column = field.getAnnotation(ExcelColumn.class);
            columnDomain.setColumnTitle(column.title());
            columnDomain.setColumnIndex(column.index());
            if (field.isAnnotationPresent(ExcelColumnDateformat.class)) {
                ExcelColumnDateformat dateFormatAnno = field.getAnnotation(ExcelColumnDateformat.class);
                columnDomain.setDateFormat(dateFormatAnno.value());
            }
            if (field.isAnnotationPresent(ExcelColumnDictCode.class)) {
                ExcelColumnDictCode dictCodeAnno = field.getAnnotation(ExcelColumnDictCode.class);
                columnDomain.setDictCode(dictCodeAnno.value());
            }
            if (field.isAnnotationPresent(ExcelColumnPricision.class)) {
                ExcelColumnPricision pricisionAnno = field.getAnnotation(ExcelColumnPricision.class);
                columnDomain.setPricision(pricisionAnno.value());
            }
            columnMap.put(field.getName(), columnDomain);
        }
        return columnMap;
    }

    public static void assembleTitle(Row titleRow, CellStyle cellStyle, Map<String, ExcelColumnDomain> columnMap) {
        for (String key : columnMap.keySet()) {
            ExcelColumnDomain columnDomain = columnMap.get(key);
            Cell cell = titleRow.createCell(columnDomain.getColumnIndex().intValue());
            cell.setCellStyle(cellStyle);
            cell.setCellValue(columnDomain.getColumnTitle());
        }
    }

    public static void assembleData(List<?> dataList, Sheet sh, int currentRowIndex, Integer fetchSize, Map<String, ExcelColumnDomain> columnMap, Class<?> clazz, ExcelRemoteCall excelRemoteCall) {
        if (!CollectionUtils.isEmpty(dataList)) {
            try {
                for (int index = 0; index < dataList.size(); ++index) {
                    Row dataRow = sh.createRow(currentRowIndex + index + 1);
                    for (String fieldNameKey : columnMap.keySet()) {
                        ExcelColumnDomain columnDomain = columnMap.get(fieldNameKey);
                        Cell dataCell = dataRow.createCell(columnDomain.getColumnIndex().intValue());
                        Field field = clazz.getDeclaredField(fieldNameKey);
                        field.setAccessible(true);
                        Object fieldValue = null;
                        Object pojoORMap = dataList.get(index);
                        if (null == pojoORMap) continue;
                        if (pojoORMap instanceof Map) {
                            Map objMap = (Map)dataList.get(index);
                            fieldValue = objMap.get(fieldNameKey);
                        } else if (pojoORMap.getClass().equals(clazz)) {
                            fieldValue = field.get(pojoORMap);
                        }
                        if (null == fieldValue) continue;
                        ExcelImportExportUtil.setCellValue(columnDomain, dataCell, fieldValue, excelRemoteCall);
                    }
                    if (null == fetchSize || sh.getPhysicalNumberOfRows() - 1 != fetchSize) continue;
                    return;
                }
            }
            catch (Exception e) {
                logger.error("assembleData Error: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public static void setCellValue(ExcelColumnDomain columnDomain, Cell dataCell, Object fieldValue, ExcelRemoteCall excelRemoteCall) {
        if (null != columnDomain.getDictCode()) {
            String textValue = ExcelImportExportUtil.convertDictValueTextByCode(columnDomain.getDictCode(), String.valueOf(fieldValue), true, excelRemoteCall);
            dataCell.setCellValue(textValue);
        } else if (fieldValue instanceof Date) {
            String formatStr = "yyyy-MM-dd HH:mm:ss";
            if (null != columnDomain.getDateFormat()) {
                formatStr = columnDomain.getDateFormat();
            }
            SimpleDateFormat sdf = new SimpleDateFormat(formatStr);
            dataCell.setCellValue(sdf.format(fieldValue));
        } else if (fieldValue instanceof Double || fieldValue instanceof Float) {
            if (null != columnDomain.getPricision()) {
                BigDecimal bg = new BigDecimal(String.valueOf(fieldValue));
                Double tempNumber = bg.setScale((int)columnDomain.getPricision(), 4).doubleValue();
                dataCell.setCellValue(tempNumber.doubleValue());
            } else {
                dataCell.setCellValue(String.valueOf(fieldValue));
            }
        } else if (null != columnDomain.getPricision()) {
            BigDecimal bg = BigDecimal.valueOf(Double.parseDouble(String.valueOf(fieldValue)));
            Double tempNumber = bg.setScale((int)columnDomain.getPricision(), 4).doubleValue();
            dataCell.setCellValue(tempNumber.doubleValue());
        } else {
            dataCell.setCellValue(String.valueOf(fieldValue));
        }
    }

    public static void setFieldValue(Cell cell, Field field, Object obj, ExcelRemoteCall excelRemoteCall, ExcelPrimaryId excelPrimaryId) {
        if (null != cell) {
            try {
                if (cell.getCellTypeEnum() != CellType.STRING && HSSFDateUtil.isCellDateFormatted((Cell)cell)) {
                    if (null != cell.getDateCellValue()) {
                        String formatStr = "yyyy-MM-dd HH:mm:ss";
                        if (field.isAnnotationPresent(ExcelColumnDateformat.class)) {
                            formatStr = field.getAnnotation(ExcelColumnDateformat.class).value();
                        }
                        Date cellDate = cell.getDateCellValue();
                        SimpleDateFormat sdf = new SimpleDateFormat(formatStr);
                        if (field.getType().equals(Date.class)) {
                            ExcelImportExportUtil.setValue(field, obj, cellDate);
                        } else {
                            ExcelImportExportUtil.setValue(field, obj, sdf.format(cellDate));
                        }
                    }
                } else if (field.isAnnotationPresent(ExcelColumnDictCode.class)) {
                    String dictCode = field.getAnnotation(ExcelColumnDictCode.class).value();
                    String dictText = cell.getStringCellValue();
                    String dictValue = ExcelImportExportUtil.convertDictValueTextByCode(dictCode, dictText, false, excelRemoteCall);
                    ExcelImportExportUtil.setValue(field, obj, dictValue);
                } else if (field.isAnnotationPresent(ExcelId.class)) {
                    String idType = field.getAnnotation(ExcelId.class).value();
                    String id = ExcelImportExportUtil.createIdByIdType(idType, excelPrimaryId);
                    ExcelImportExportUtil.setValue(field, obj, id);
                } else if (field.isAnnotationPresent(ExcelColumnPrecision.class)) {
                    ExcelColumnPrecision precision = field.getAnnotation(ExcelColumnPrecision.class);
                    BigDecimal bigDecimal = new BigDecimal(cell.getStringCellValue());
                    ExcelImportExportUtil.setFiledValue(field, obj, (Object)bigDecimal.setScale(precision.accept(), precision.mode()));
                } else {
                    ExcelImportExportUtil.setFiledValue(cell, field, obj);
                }
            }
            catch (Exception e) {
                logger.error("setFieldValue Error: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    private static void setValue(Field field, Object obj, Object value) throws IllegalAccessException, IntrospectionException, InvocationTargetException {
        BeanUtils.getInstance().setFieldValueByWriteMethod(obj, field.getName(), value);
    }

    private static void setFiledValue(Cell cell, Field field, Object obj) throws IllegalAccessException, ParseException, IntrospectionException, InvocationTargetException {
        if (field.getType().equals(Double.class)) {
            BigDecimal bg = new BigDecimal(Double.parseDouble(cell.getStringCellValue()));
            ExcelImportExportUtil.setValue(field, obj, bg.doubleValue());
        } else if (field.getType().equals(Integer.class)) {
            BigDecimal bg = new BigDecimal(Double.parseDouble(cell.getStringCellValue()));
            ExcelImportExportUtil.setValue(field, obj, bg.intValue());
        } else if (field.getType().equals(BigDecimal.class)) {
            BigDecimal bg = new BigDecimal(cell.getStringCellValue());
            ExcelImportExportUtil.setValue(field, obj, bg);
        } else if (field.getType().equals(Date.class)) {
            String formatStr = "yyyy-MM-dd HH:mm:ss";
            if (field.isAnnotationPresent(ExcelColumnDateformat.class)) {
                formatStr = field.getAnnotation(ExcelColumnDateformat.class).value();
            }
            SimpleDateFormat sdf = new SimpleDateFormat(formatStr);
            ExcelImportExportUtil.setValue(field, obj, sdf.parse(cell.getStringCellValue()));
        } else {
            ExcelImportExportUtil.setValue(field, obj, cell.getStringCellValue());
        }
    }

    private static void setFiledValue(Field field, Object obj, Object value) throws IllegalAccessException, IntrospectionException, InvocationTargetException {
        Class<?> fieldType = field.getType();
        if (String.class.equals(fieldType)) {
            ExcelImportExportUtil.setValue(field, obj, String.valueOf(value));
        } else if (BigDecimal.class.equals(fieldType)) {
            if (value instanceof String) {
                ExcelImportExportUtil.setValue(field, obj, new BigDecimal((String)String.class.cast(value)));
            } else if (value instanceof BigDecimal) {
                ExcelImportExportUtil.setValue(field, obj, value);
            }
        } else if (Double.class.equals(fieldType)) {
            if (value instanceof String) {
                ExcelImportExportUtil.setValue(field, obj, Double.parseDouble((String)String.class.cast(value)));
            } else if (value instanceof BigDecimal) {
                ExcelImportExportUtil.setValue(field, obj, ((BigDecimal)value).doubleValue());
            }
        } else if (Integer.class.equals(fieldType)) {
            if (value instanceof String) {
                ExcelImportExportUtil.setValue(field, obj, Integer.parseInt((String)String.class.cast(value)));
            } else if (value instanceof BigDecimal) {
                ExcelImportExportUtil.setValue(field, obj, ((BigDecimal)value).intValue());
            }
        } else {
            ExcelImportExportUtil.setValue(field, obj, value);
            field.set(obj, value);
        }
    }

    private static String convertDictValueTextByCode(String dictCode, String key, Boolean valueToText, ExcelRemoteCall excelRemoteCall) {
        if (null != excelRemoteCall) {
            try {
                Map<String, String> itemMap = null;
                if (!dictCodeMap.containsKey(dictCode)) {
                    itemMap = excelRemoteCall.getItemListBylookupcode(dictCode);
                    dictCodeMap.put(dictCode, itemMap);
                } else {
                    itemMap = dictCodeMap.get(dictCode);
                }
                if (null != itemMap && !itemMap.isEmpty()) {
                    if (valueToText.booleanValue()) {
                        if (itemMap.containsKey(key)) {
                            return itemMap.get(key);
                        }
                    } else {
                        for (Map.Entry<String, String> entry : itemMap.entrySet()) {
                            if (!key.equals(entry.getValue())) continue;
                            return entry.getKey();
                        }
                    }
                }
            }
            catch (Exception e) {
                logger.error("convertDictValueTextByCode Error: " + e.getMessage(), (Throwable)e);
            }
        }
        return key;
    }

    public static Integer getPercentInt(int a, int b) {
        if (0 == b) {
            return 0;
        }
        double result = (double)a * 1.0 / ((double)b * 1.0);
        DecimalFormat decimalFormat = new DecimalFormat("#%");
        String percent = decimalFormat.format(result);
        return Integer.parseInt(percent.replace("%", ""));
    }

    private static String createIdByIdType(String idType, ExcelPrimaryId excelPrimaryId) {
        String result = "";
        if (null != excelPrimaryId) {
            String id = excelPrimaryId.getExcelPrimaryId(idType);
            if (null == id) {
                logger.error("Unsupported primary key type [" + idType + "]");
            } else {
                result = id;
            }
        }
        return result;
    }
}

