/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.excel;

import cn.com.yusys.yusp.commons.domain.ExcelColumnDomain;
import cn.com.yusys.yusp.commons.excel.ExcelImportExportUtil;
import cn.com.yusys.yusp.commons.excel.annotation.ExcelName;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelUtil {
    private static final Pattern ZH_PATTERN = Pattern.compile("[\\u4e00-\\u9fa5]");
    private static final Logger log = LoggerFactory.getLogger(ExcelUtil.class);

    public static Workbook createWorkBook(List<?> data, int pageSize, String pojoClassName, StringBuffer fileName, Boolean version, Boolean autoSize) {
        SXSSFWorkbook workbook = new SXSSFWorkbook();
        try {
            if (data == null) {
                return workbook;
            }
            Class<?> clazz = Class.forName(pojoClassName);
            String sheetName = "log";
            if (clazz.isAnnotationPresent(ExcelName.class)) {
                ExcelName classAnnotation = clazz.getDeclaredAnnotation(ExcelName.class);
                sheetName = classAnnotation.sheet();
                fileName.append(classAnnotation.value());
            }
            Map<String, ExcelColumnDomain> columnMap = ExcelImportExportUtil.getColumnMap(clazz);
            if (!version.booleanValue()) {
                workbook = new HSSFWorkbook();
            }
            CellStyle cellStyle = ExcelUtil.generateCellStyle((Workbook)workbook);
            if (data.size() > 0) {
                Object obj = data.get(0);
                if (!obj.getClass().equals(clazz) && !(obj instanceof Map)) {
                    if (clazz.getName().endsWith("Pojo")) {
                        String entityName = clazz.getName().substring(0, clazz.getName().length() - 4);
                        clazz = Class.forName(entityName);
                    } else {
                        log.warn("{} \u5fc5\u987b\u4ee5Pojo\u7ed3\u5c3e", clazz);
                    }
                }
                int i = 0;
                while (i * pageSize < data.size()) {
                    Sheet sheet = workbook.createSheet(sheetName + "_" + i);
                    ExcelUtil.writeSheet(clazz, data, pageSize, i * pageSize, sheet, cellStyle, columnMap, autoSize);
                    ++i;
                }
            } else {
                Sheet sheet = workbook.createSheet(sheetName);
                int[] maxColumnWidth = new int[columnMap.size()];
                ExcelUtil.writeTitle(sheet, cellStyle, columnMap, maxColumnWidth, autoSize);
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return workbook;
    }

    private static void writeSheet(Class<?> clazz, List data, int pageSize, int startSize, Sheet sheet, CellStyle cellStyle, Map<String, ExcelColumnDomain> columnMap, boolean autoSize) {
        int size = data.size() - startSize < pageSize ? data.size() - startSize : pageSize;
        int[] maxColumnWidth = new int[columnMap.size()];
        ExcelUtil.writeTitle(sheet, cellStyle, columnMap, maxColumnWidth, autoSize);
        for (int j = 0; j < size; ++j) {
            Row rowTemp = sheet.createRow(j + 1);
            ExcelUtil.writeRow(clazz, data.get(j + startSize), rowTemp, columnMap, null, maxColumnWidth, autoSize);
        }
        if (autoSize) {
            for (int i = 0; i < maxColumnWidth.length; ++i) {
                sheet.setColumnWidth(i, (maxColumnWidth[i] + 4) * 256);
            }
        }
    }

    private static void writeTitle(Sheet sheet, CellStyle cellStyle, Map<String, ExcelColumnDomain> columnMap, int[] maxColumnWidth, Boolean autoSize) {
        Row titleRow = sheet.createRow(0);
        ExcelUtil.writeRow(null, null, titleRow, columnMap, cellStyle, maxColumnWidth, autoSize);
    }

    private static void writeRow(Class<?> clazz, Object data, Row row, Map<String, ExcelColumnDomain> columnMap, CellStyle cellStyle, int[] maxColumnWidth, Boolean autoSize) {
        for (Map.Entry<String, ExcelColumnDomain> domain : columnMap.entrySet()) {
            Integer index = domain.getValue().getColumnIndex();
            Object value = "";
            if (data != null) {
                if (data instanceof Map) {
                    Map temp = (Map)data;
                    if (temp.get(domain.getKey()) != null) {
                        value = temp.get(domain.getKey()).toString();
                    }
                } else {
                    try {
                        Field field = clazz.getDeclaredField(domain.getKey());
                        field.setAccessible(true);
                        value = field.get(data);
                    }
                    catch (NoSuchFieldException e) {
                        e.printStackTrace();
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                }
            } else if (domain.getValue().getColumnTitle() != null) {
                value = domain.getValue().getColumnTitle();
            }
            Cell cell = row.createCell(index.intValue());
            if (cellStyle != null) {
                cell.setCellStyle(cellStyle);
            }
            if (value == null) continue;
            if (autoSize.booleanValue()) {
                maxColumnWidth[index.intValue()] = Math.max(maxColumnWidth[index], ExcelUtil.getStringWidth(value.toString()));
                if (maxColumnWidth[index] > 255) {
                    maxColumnWidth[index.intValue()] = 255;
                }
            }
            cell.setCellValue(value.toString());
        }
    }

    public static int getStringWidth(String s) {
        int width = s.length();
        Matcher m = ZH_PATTERN.matcher(s);
        while (m.find()) {
            ++width;
        }
        return width;
    }

    private static CellStyle generateCellStyle(Workbook workbook) {
        CellStyle cellStyle = workbook.createCellStyle();
        cellStyle.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.index);
        cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        cellStyle.setBorderBottom(BorderStyle.THIN);
        cellStyle.setBorderLeft(BorderStyle.THIN);
        cellStyle.setBorderRight(BorderStyle.THIN);
        cellStyle.setBorderTop(BorderStyle.THIN);
        cellStyle.setAlignment(HorizontalAlignment.CENTER);
        return cellStyle;
    }
}

