/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.util;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.ref.SoftReference;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.lang.NonNull;

public final class BeanUtils {
    private SoftReference<Map<Class<?>, Map<String, PropertyDescriptor>>> propertyDescriptorCache = new SoftReference(new ConcurrentHashMap());

    private BeanUtils() {
    }

    public BeanInfo getBeanInfo(Class<?> clz) throws IntrospectionException {
        return Introspector.getBeanInfo(clz);
    }

    public static <T> T newInstance(Class<T> clz) throws IllegalAccessException, InstantiationException {
        return clz.newInstance();
    }

    public PropertyDescriptor getFieldProperty(Class<?> clz, @NonNull String fieldName) throws IntrospectionException {
        Map<Class<?>, Map<String, PropertyDescriptor>> cache = this.propertyDescriptorCache.get();
        Map<String, PropertyDescriptor> descriptorMap = cache.get(clz);
        if (descriptorMap == null || descriptorMap.get(fieldName) == null) {
            descriptorMap = new ConcurrentHashMap<String, PropertyDescriptor>();
            PropertyDescriptor[] propertyDescriptors = this.getBeanInfo(clz).getPropertyDescriptors();
            Map<String, PropertyDescriptor> finalDescriptorMap = descriptorMap;
            Arrays.stream(propertyDescriptors).forEach(descriptor -> finalDescriptorMap.put(descriptor.getName(), (PropertyDescriptor)descriptor));
        }
        return descriptorMap.get(fieldName);
    }

    public void setFieldValueByWriteMethod(Object obj, @NonNull String fieldName, Object value) throws IntrospectionException, InvocationTargetException, IllegalAccessException {
        PropertyDescriptor propertyDescriptor = this.getFieldProperty(obj.getClass(), fieldName);
        propertyDescriptor.getWriteMethod().invoke(obj, value);
    }

    public static BeanUtils getInstance() {
        return BeanUtilsHolder.instance;
    }

    private static class BeanUtilsHolder {
        private static BeanUtils instance = new BeanUtils();

        private BeanUtilsHolder() {
        }
    }
}

