/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.util;

import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyRep;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;
import org.apache.commons.codec.binary.Base64;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.LoggerFactory;

public final class BCRSAUtil {
    private static RSAPublicKey pubKey = null;
    private static RSAPrivateKey priKey = null;
    private static final String DEFAULT_RSA_ALGORITHM = "RSA/None/PKCS1Padding";

    private static Key readKey(String keyName) throws Exception {
        ObjectInputStream keyIn = new ObjectInputStream(BCRSAUtil.class.getClassLoader().getResourceAsStream(keyName));
        Key key = (Key)keyIn.readObject();
        keyIn.close();
        return key;
    }

    public static String decryptByPrivate(String content) throws Exception {
        return new String(BCRSAUtil.decrypt(priKey, Base64.decodeBase64((String)content)));
    }

    public static String encryptByPub(String key) throws Exception {
        return Base64.encodeBase64String((byte[])BCRSAUtil.encryptByPub(key.getBytes(), pubKey.getEncoded()));
    }

    public static byte[] decrypt(Key key, byte[] content) throws Exception {
        Cipher cipher = Cipher.getInstance(DEFAULT_RSA_ALGORITHM, "BC");
        cipher.init(2, key);
        return cipher.doFinal(content);
    }

    public static byte[] encryptByPub(byte[] data, byte[] keyByte) throws Exception {
        try {
            KeyFactory mykeyFactory = KeyFactory.getInstance("RSA");
            X509EncodedKeySpec pub_spec = new X509EncodedKeySpec(keyByte);
            PublicKey publicKey = mykeyFactory.generatePublic(pub_spec);
            Cipher cipher = Cipher.getInstance(DEFAULT_RSA_ALGORITHM, "BC");
            cipher.init(1, publicKey);
            return cipher.doFinal(data);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw ex;
        }
    }

    public static byte[] encryptByPub(byte[] data, String key) throws Exception {
        return BCRSAUtil.encryptByPub(data, Base64.decodeBase64((String)key));
    }

    public static String encryptByPrivate(String password) throws Exception {
        return Base64.encodeBase64String((byte[])BCRSAUtil.encryptByPrivate(password.getBytes(), priKey.getEncoded()));
    }

    public static byte[] encryptByPrivate(byte[] data, byte[] keyByte) throws Exception {
        try {
            KeyFactory mykeyFactory = KeyFactory.getInstance("RSA");
            PKCS8EncodedKeySpec private_spec = new PKCS8EncodedKeySpec(keyByte);
            PrivateKey privateKey = mykeyFactory.generatePrivate(private_spec);
            Cipher cipher = Cipher.getInstance(DEFAULT_RSA_ALGORITHM, "BC");
            cipher.init(1, privateKey);
            return cipher.doFinal(data);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw ex;
        }
    }

    public static byte[] encryptByPrivate(byte[] data, String key) throws Exception {
        return BCRSAUtil.encryptByPrivate(data, Base64.decodeBase64((String)key));
    }

    public static void createPublicKeyFile(PublicKey key, String filePath) throws Exception {
        KeyRep pubKeyRep = new KeyRep(KeyRep.Type.PUBLIC, key.getAlgorithm(), key.getFormat(), key.getEncoded());
        try (FileOutputStream fos = new FileOutputStream(filePath);
             ObjectOutputStream oos = new ObjectOutputStream(fos);){
            oos.writeObject(pubKeyRep);
            oos.flush();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw ex;
        }
    }

    public static void createPrivateKeyFile(PrivateKey key, String filePath) throws Exception {
        KeyRep priKeyRep = new KeyRep(KeyRep.Type.PRIVATE, key.getAlgorithm(), key.getFormat(), key.getEncoded());
        try (FileOutputStream fos = new FileOutputStream(filePath);
             ObjectOutputStream oos = new ObjectOutputStream(fos);){
            oos.writeObject(priKeyRep);
            oos.flush();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw ex;
        }
    }

    static {
        try {
            Security.addProvider((Provider)new BouncyCastleProvider());
            priKey = (RSAPrivateKey)BCRSAUtil.readKey("cert/pwd_private.key");
            pubKey = (RSAPublicKey)BCRSAUtil.readKey("cert/pwd_public.key");
        }
        catch (Exception err) {
            LoggerFactory.getLogger(BCRSAUtil.class).error(err.getMessage());
        }
    }
}

