/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.util;

import cn.com.yusys.yusp.commons.exception.YuspException;
import cn.com.yusys.yusp.commons.util.CommonUtil;
import cn.com.yusys.yusp.commons.util.StringUtil;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Asserts {
    private static final Logger logger = LoggerFactory.getLogger(Asserts.class);

    public static final void assertTrue(boolean expression, String messagePattern, Object ... argArray) throws YuspException {
        Asserts.assertTrue(expression, "99999999", CommonUtil.formatMessage(messagePattern, argArray), new Object[0]);
    }

    public static final void assertTrue(boolean expression, String code, String messagePattern, Object ... argArray) throws YuspException {
        if (!expression) {
            String message = CommonUtil.formatMessage(messagePattern, argArray);
            logger.error(message);
            throw new YuspException(code, message);
        }
    }

    public static final void assertFalse(boolean expression, String messagePattern, Object ... argArray) throws YuspException {
        Asserts.assertFalse(expression, "99999999", messagePattern, argArray);
    }

    public static final void assertFalse(boolean expression, String code, String messagePattern, Object ... argArray) throws YuspException {
        if (expression) {
            String message = CommonUtil.formatMessage(messagePattern, argArray);
            logger.error(message);
            throw new YuspException(code, message);
        }
    }

    public static final void assertNull(String str, String messagePattern, Object ... argArray) throws YuspException {
        Asserts.assertNull(str, "99999999", messagePattern, argArray);
    }

    public static final void assertNull(String str, String code, String messagePattern, Object ... argArray) throws YuspException {
        if (StringUtil.isNotEmpty(str)) {
            String message = CommonUtil.formatMessage(messagePattern, argArray);
            logger.error(message);
            throw new YuspException(code, message);
        }
    }

    public static final void assertNull(Object object, String messagePattern, Object ... argArray) throws YuspException {
        Asserts.assertNull(object, "99999999", messagePattern, argArray);
    }

    public static final void assertNull(Object object, String code, String messagePattern, Object ... argArray) throws YuspException {
        if (Objects.nonNull(object)) {
            String message = CommonUtil.formatMessage(messagePattern, argArray);
            logger.error(message);
            throw new YuspException(code, message);
        }
    }

    public static final void assertNonNull(String str, String messagePattern, Object ... argArray) throws YuspException {
        Asserts.assertNonNull(str, "99999999", messagePattern, argArray);
    }

    public static final void assertNonNull(String str, String code, String messagePattern, Object ... argArray) throws YuspException {
        if (StringUtil.isEmpty(str)) {
            String message = CommonUtil.formatMessage(messagePattern, argArray);
            logger.error(message);
            throw new YuspException(code, message);
        }
    }

    public static final void assertNonNull(Object object, String messagePattern, Object ... argArray) throws YuspException {
        Asserts.assertNonNull(object, "99999999", messagePattern, argArray);
    }

    public static final void assertNonNull(Object object, String code, String messagePattern, Object ... argArray) throws YuspException {
        if (Objects.isNull(object)) {
            String message = CommonUtil.formatMessage(messagePattern, argArray);
            logger.error(message);
            throw new YuspException(code, message);
        }
    }

    public static final void assertNullOrEmpty(Collection<?> collection, String messagePattern, Object ... argArray) throws YuspException {
        Asserts.assertNullOrEmpty(collection, "99999999", messagePattern, argArray);
    }

    public static final void assertNullOrEmpty(Collection<?> collection, String code, String messagePattern, Object ... argArray) throws YuspException {
        if (CommonUtil.nonNullOrEmpty(collection)) {
            String message = CommonUtil.formatMessage(messagePattern, argArray);
            logger.error(message);
            throw new YuspException(code, message);
        }
    }

    public static final void assertNonNullOrEmpty(Collection<?> collection, String messagePattern, Object ... argArray) throws YuspException {
        Asserts.assertNonNullOrEmpty(collection, "99999999", messagePattern, argArray);
    }

    public static final void assertNonNullOrEmpty(Collection<?> collection, String code, String messagePattern, Object ... argArray) throws YuspException {
        if (CommonUtil.isNullOrEmpty(collection)) {
            String message = CommonUtil.formatMessage(messagePattern, argArray);
            logger.error(message);
            throw new YuspException(code, message);
        }
    }

    public static final void assertNullOrEmpty(Map<?, ?> map, String messagePattern, Object ... argArray) throws YuspException {
        Asserts.assertNullOrEmpty(map, "99999999", messagePattern, argArray);
    }

    public static final void assertNullOrEmpty(Map<?, ?> map, String code, String messagePattern, Object ... argArray) throws YuspException {
        if (CommonUtil.nonNullOrEmpty(map)) {
            String message = CommonUtil.formatMessage(messagePattern, argArray);
            logger.error(message);
            throw new YuspException(code, message);
        }
    }

    public static final void assertNonNullOrEmpty(Map<?, ?> map, String messagePattern, Object ... argArray) throws YuspException {
        Asserts.assertNonNullOrEmpty(map, "99999999", messagePattern, argArray);
    }

    public static final void assertNonNullOrEmpty(Map<?, ?> map, String code, String messagePattern, Object ... argArray) throws YuspException {
        if (CommonUtil.isNullOrEmpty(map)) {
            String message = CommonUtil.formatMessage(messagePattern, argArray);
            logger.error(message);
            throw new YuspException(code, message);
        }
    }

    public static final void assertMinNumber(Number value, Number minVal, String messagePattern, Object ... argArray) throws YuspException {
        if (minVal.doubleValue() > value.doubleValue()) {
            String message = CommonUtil.formatMessage(messagePattern, argArray);
            logger.error(message);
            throw new YuspException("99999999", message);
        }
    }

    public static final void assertMaxNumber(Number value, Number maxVal, String messagePattern, Object ... argArray) throws YuspException {
        if (maxVal.doubleValue() < value.doubleValue()) {
            String message = CommonUtil.formatMessage(messagePattern, argArray);
            logger.error(message);
            throw new YuspException("99999999", message);
        }
    }

    public static final void assertEquals(Object obj1, Object obj2, String messagePattern, Object ... argArray) throws YuspException {
        if (!Objects.equals(obj1, obj2)) {
            String message = CommonUtil.formatMessage(messagePattern, argArray);
            logger.error(message);
            throw new YuspException("99999999", message);
        }
    }

    public static final void assertNonEquals(Object obj1, Object obj2, String messagePattern, Object ... argArray) throws YuspException {
        if (Objects.equals(obj1, obj2)) {
            String message = CommonUtil.formatMessage(messagePattern, argArray);
            logger.error(message);
            throw new YuspException("99999999", message);
        }
    }

    public static final void assertEquals(Object[] objs, Object obj2, String messagePattern, Object ... argArray) throws YuspException {
        if (CommonUtil.nonNullOrEmpty(objs)) {
            for (Object obj : objs) {
                Asserts.assertEquals(obj, obj2, messagePattern, argArray);
            }
        }
    }

    public static final void assertNonEquals(Object[] objs, Object obj2, String messagePattern, Object ... argArray) throws YuspException {
        if (CommonUtil.nonNullOrEmpty(objs)) {
            for (Object obj : objs) {
                Asserts.assertNonEquals(obj, obj2, messagePattern, argArray);
            }
        }
    }

    public static final void assertEquals(Collection<?> objs, Object obj2, String messagePattern, Object ... argArray) throws YuspException {
        if (CommonUtil.nonNullOrEmpty(objs)) {
            for (Object obj : objs) {
                Asserts.assertEquals(obj, obj2, messagePattern, argArray);
            }
        }
    }

    public static final void assertNonEquals(Collection<?> objs, Object obj2, String messagePattern, Object ... argArray) throws YuspException {
        if (CommonUtil.nonNullOrEmpty(objs)) {
            for (Object obj : objs) {
                Asserts.assertNonEquals(obj, obj2, messagePattern, argArray);
            }
        }
    }
}

