/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.mapper;

import cn.com.yusys.yusp.commons.mapper.QueryModel;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import feign.RequestTemplate;
import feign.Util;
import feign.codec.EncodeException;
import io.swagger.annotations.ApiModelProperty;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.boot.autoconfigure.http.HttpMessageConverters;
import org.springframework.cloud.openfeign.support.SpringEncoder;

public class YuspSpringEncoder
extends SpringEncoder {
    private Logger logger = LoggerFactory.getLogger(YuspSpringEncoder.class);
    private final Map<Class<?>, ObjectParamMetadata> classToMetadata = new HashMap();
    private ObjectMapper om = new ObjectMapper();

    public YuspSpringEncoder(ObjectFactory<HttpMessageConverters> messageConverters) {
        super(messageConverters);
    }

    public void encode(Object requestBody, Type bodyType, RequestTemplate request) throws EncodeException {
        if (requestBody instanceof QueryModel) {
            this.logger.info("Special handling: {}", requestBody);
            try {
                requestBody = new QueryModelWrapper((QueryModel)QueryModel.class.cast(requestBody));
            }
            catch (JsonProcessingException e) {
                this.logger.error("Conversion error: {}", (Throwable)e);
            }
        }
        if ("GET".equals(request.method())) {
            try {
                ObjectParamMetadata metadata = this.getMetadata(requestBody.getClass());
                for (PropertyDescriptor pd : metadata.objectProperties) {
                    Object value = pd.getReadMethod().invoke(requestBody, new Object[0]);
                    if (value == null || value == requestBody) continue;
                    request.query(true, pd.getName(), new String[]{URLEncoder.encode(String.valueOf(value), Util.UTF_8.name())});
                }
                return;
            }
            catch (IntrospectionException | UnsupportedEncodingException | IllegalAccessException | InvocationTargetException e) {
                throw new EncodeException("Failure encoding object into query map", (Throwable)e);
            }
        }
        super.encode(requestBody, bodyType, request);
    }

    private ObjectParamMetadata getMetadata(Class<?> objectType) throws IntrospectionException {
        ObjectParamMetadata metadata = this.classToMetadata.get(objectType);
        if (metadata == null) {
            metadata = ObjectParamMetadata.parseObjectType(objectType);
            this.classToMetadata.put(objectType, metadata);
        }
        return metadata;
    }

    class QueryModelWrapper {
        private String condition;
        private int page;
        private int size = 10;
        private String sort;
        @ApiModelProperty(hidden=true)
        private String dataAuth;

        public QueryModelWrapper(QueryModel model) throws JsonProcessingException {
            this.page = model.getPage();
            this.size = model.getSize();
            this.sort = model.getSort();
            this.dataAuth = model.getDataAuth();
            this.sort = model.getSort();
            this.condition = YuspSpringEncoder.this.om.writeValueAsString(model.getCondition());
        }

        public String getCondition() {
            return this.condition;
        }

        public void setCondition(String condition) {
            this.condition = condition;
        }

        public int getPage() {
            return this.page;
        }

        public void setPage(int page) {
            this.page = page;
        }

        public int getSize() {
            return this.size;
        }

        public void setSize(int size) {
            this.size = size;
        }

        public String getSort() {
            return this.sort;
        }

        public void setSort(String sort) {
            this.sort = sort;
        }

        public String getDataAuth() {
            return this.dataAuth;
        }

        public void setDataAuth(String dataAuth) {
            this.dataAuth = dataAuth;
        }
    }

    private static class ObjectParamMetadata {
        private final List<PropertyDescriptor> objectProperties;

        private ObjectParamMetadata(List<PropertyDescriptor> objectProperties) {
            this.objectProperties = Collections.unmodifiableList(objectProperties);
        }

        private static ObjectParamMetadata parseObjectType(Class<?> type) throws IntrospectionException {
            ArrayList<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>();
            for (PropertyDescriptor pd : Introspector.getBeanInfo(type).getPropertyDescriptors()) {
                boolean isGetterMethod;
                boolean bl = isGetterMethod = pd.getReadMethod() != null && !"class".equals(pd.getName());
                if (!isGetterMethod) continue;
                properties.add(pd);
            }
            return new ObjectParamMetadata(properties);
        }
    }
}

