/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.exception;

import cn.com.yusys.yusp.commons.exception.Message;
import cn.com.yusys.yusp.commons.util.CommonUtil;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class YuspException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private int direct;
    private String level;
    private String code;
    private String message;
    private String errorPage;
    private List<Object> i18nData;

    public YuspException(int direct, String level, String code, String message, String errorPage, Throwable cause, Object ... args) {
        super(CommonUtil.formatMessage(message, args), cause);
        this.message = CommonUtil.formatMessage(message, args);
        this.direct = direct;
        this.level = level;
        this.code = code;
        this.errorPage = errorPage;
        this.i18nData = Arrays.asList(args);
    }

    public YuspException(String errorCode, String errorMessage) {
        this(errorCode, errorMessage, null);
    }

    public YuspException(String errorCode, Throwable e) {
        this(errorCode, Objects.nonNull(e) ? e.getMessage() : null, e);
    }

    public YuspException(String errorCode, String errorMessage, Throwable e) {
        this(1, "error", errorCode, errorMessage, null, e, new Object[0]);
    }

    public YuspException(String level, String code, String message, Object ... args) {
        this(1, level, code, message, null, null, args);
    }

    public YuspException(Throwable cause, String level, String code, String message) {
        this(1, level, code, message, null, cause, new Object[0]);
    }

    public YuspException(Message message, Object ... args) {
        this(1, "error", message.getCode(), message.getMessage(), null, null, args);
    }

    public int getDirect() {
        return this.direct;
    }

    public String getLevel() {
        return this.level;
    }

    public String getCode() {
        return this.code;
    }

    public String getMsg() {
        String fullMsg = "";
        for (Throwable tmp = this; tmp != null; tmp = tmp.getCause()) {
            if (!(tmp instanceof YuspException)) continue;
            YuspException b = tmp;
            fullMsg = fullMsg + b.message + "\r\n";
        }
        return fullMsg;
    }

    public String getErrorPage() {
        return this.errorPage;
    }

    public List<Object> getI18nData() {
        return this.i18nData;
    }
}

