/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.common.dataauth;

import cn.com.yusys.yusp.common.dataauth.AbstractDataAuthHandler;
import cn.com.yusys.yusp.common.dataauth.DataAuthHandler;
import cn.com.yusys.yusp.common.util.BeanUtil;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDataAuthHandler
extends AbstractDataAuthHandler {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public String getTemplate(String sqlId) {
        String dataAuthTemplate = DataAuthHandler.dataAuthTemplate.get();
        return dataAuthTemplate;
    }

    @Override
    public Map<String, Object> getParams(String sqlId) {
        Map<String, Object> params = DataAuthHandler.dataAuthParams.get();
        if (params == null) {
            params = new HashMap<String, Object>();
        }
        return params;
    }

    @Override
    public String replaceTemplateParams(String sqlId, String template, Map<String, Object> params) {
        String newTemplate = template;
        String reg = "\\$\\{[a-zA-Z0-9_]+\\}";
        Pattern pattern = Pattern.compile(reg);
        Matcher matcher = pattern.matcher(template);
        block0: while (matcher.find()) {
            String matchWord = matcher.group(0);
            String key = matchWord.substring(2, matchWord.length() - 1);
            Object value = params.get(key);
            if (value == null) continue;
            if (!(value instanceof String) && !(value instanceof Character)) {
                if (value instanceof List) {
                    StringBuilder authValue = new StringBuilder();
                    List values = (List)value;
                    int i = 0;
                    while (true) {
                        if (i >= values.size()) continue block0;
                        if (i == 0) {
                            authValue.append(this.getSqlParam(values.get(i)));
                        } else {
                            authValue.append(",").append(this.getSqlParam(values.get(i)));
                        }
                        ++i;
                    }
                }
                newTemplate = newTemplate.replace(matchWord, this.getSqlParam(value));
                continue;
            }
            newTemplate = newTemplate.replace(matchWord, this.getSqlParam(value));
        }
        return newTemplate;
    }

    private String getSqlParam(Object value) {
        return !(value instanceof String) && !(value instanceof Character) ? value.toString() : "'" + value + "'";
    }

    @Override
    public boolean setDataAuthParams(Object queryParameter, String dataAuth) {
        boolean setSuccess = false;
        if (queryParameter instanceof Map) {
            Map mapParamter = (Map)queryParameter;
            mapParamter.put("dataAuth", dataAuth);
            setSuccess = true;
        } else {
            try {
                Field field = BeanUtil.findFieldWithParent(queryParameter.getClass(), "dataAuth");
                if (field != null) {
                    BeanUtil.setFieldValue(queryParameter, field, dataAuth);
                    setSuccess = true;
                } else {
                    this.logger.warn("Unable to set recordset permission in parameterdataAuth");
                }
            }
            catch (Exception var5) {
                this.logger.error("Recordset permission setting error", (Throwable)var5);
            }
        }
        return setSuccess;
    }

    @Override
    public boolean clearDataAuthField(Object queryParameter) {
        boolean setSuccess = false;
        if (queryParameter instanceof Map) {
            Map mapParamter = (Map)queryParameter;
            mapParamter.put("dataAuth", null);
            setSuccess = true;
        } else {
            try {
                Field field = BeanUtil.findFieldWithParent(queryParameter.getClass(), "dataAuth");
                if (field != null) {
                    BeanUtil.setFieldValue(queryParameter, field, null);
                    setSuccess = true;
                }
            }
            catch (Exception var4) {
                this.logger.debug("Error clearing recordset permission field" + var4.toString());
            }
        }
        return setSuccess;
    }
}

