/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.common.util;

import cn.com.yusys.yusp.common.dto.def.DataContr;
import cn.com.yusys.yusp.common.dto.def.User;
import cn.com.yusys.yusp.common.session.IcspSessionService;
import cn.com.yusys.yusp.commons.session.util.SessionUtils;
import cn.com.yusys.yusp.commons.util.SpringContextUtils;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class IcspSessionUtils {
    private static IcspSessionService sessionService;

    private static void check() {
        if (sessionService == null) {
            IcspSessionUtils.init();
        }
    }

    private static synchronized void init() {
        if (sessionService == null) {
            sessionService = (IcspSessionService)SpringContextUtils.getBean((String)"icspCacheSessionService");
        }
    }

    public static String getUserId() {
        return SessionUtils.getUserId();
    }

    public static String getLoginCode() {
        return SessionUtils.getLoginCode();
    }

    public static String getClientId() {
        return SessionUtils.getClientId();
    }

    public static String getCurrentOrgId() {
        return IcspSessionUtils.getUserInfo().getCurrentOrg().getOrgId();
    }

    public static User getUserInfo() {
        IcspSessionUtils.check();
        String clientId = SessionUtils.getClientId();
        String userId = SessionUtils.getUserId();
        return sessionService.getUserInfo(clientId, userId);
    }

    public static <T extends DataContr> List<T> getDataControl(String sysId) {
        IcspSessionUtils.check();
        String clientId = SessionUtils.getClientId();
        String userId = SessionUtils.getUserId();
        return sessionService != null && sysId != null ? sessionService.getDataContr(sysId, clientId, userId) : null;
    }
}

