/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.admin.service;

import cn.com.yusys.yusp.admin.service.UserProviderServiceHystrix;
import cn.com.yusys.yusp.commons.dto.Contr;
import cn.com.yusys.yusp.commons.dto.DataContr;
import cn.com.yusys.yusp.commons.dto.MenuContr;
import cn.com.yusys.yusp.commons.dto.User;
import java.util.List;
import java.util.Map;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(fallback=UserProviderServiceHystrix.class, name="yusp-app-oca", path="/api")
public interface UserProviderService {
    @RequestMapping(method={RequestMethod.GET}, value={"/contr/url"})
    public List<Contr> getAllContrUrl();

    @RequestMapping(method={RequestMethod.GET}, value={"/user/usercode"})
    public String getUserCode();

    @RequestMapping(method={RequestMethod.GET}, value={"/session/info"})
    public User getUserInfo(@RequestParam(value="loginCode") String var1, @RequestParam(value="sysId") String var2);

    @RequestMapping(method={RequestMethod.GET}, value={"/account/menuandcontr"})
    public MenuContr getMenuandContr(@RequestParam(value="loginCode") String var1, @RequestParam(value="sysId") String var2);

    @RequestMapping(method={RequestMethod.GET}, value={"/account/dataauth"})
    public List<DataContr> getDataAuth(@RequestParam(value="loginCode") String var1, @RequestParam(value="sysId") String var2);

    @RequestMapping(method={RequestMethod.GET}, value={"/contr/clearUrl"})
    public void cleanAllContrUrlCache();

    @RequestMapping(method={RequestMethod.GET}, value={"/cleanUserInfoCache"})
    public void cleanUserInfoCache();

    @RequestMapping(method={RequestMethod.GET}, value={"/cleanMenuAndContrCache"})
    public void cleanMenuAndContrCache();

    @RequestMapping(method={RequestMethod.GET}, value={"/cleanDataContrCache"})
    public void cleanDataContrCache();

    @GetMapping(value={"/user/org/{orgId}"})
    public List<String> queryUserByOrgId(@PathVariable(value="orgId") String var1);

    @PostMapping(value={"/user/orgs"})
    public List<String> queryUserByOrgIds(@RequestBody List<String> var1);

    @GetMapping(value={"/user/role/{roleId}"})
    public List<String> queryUserByRoleId(@PathVariable(value="roleId") String var1);

    @GetMapping(value={"/user/duty/{dutyId}"})
    public List<String> queryUserByDutyId(@PathVariable(value="dutyId") String var1);

    @GetMapping(value={"/org/user/{userId}"})
    public List<String> queryOrgsByUserId(@PathVariable(value="userId") String var1);

    @GetMapping(value={"/org/uporg/{upOrgId}"})
    public List<String> queryOrgsByUpOrgId(@PathVariable(value="upOrgId") String var1);

    @GetMapping(value={"/uporg/org/{orgId}"})
    public List<String> queryUpOrgByOrgId(@PathVariable(value="orgId") String var1);

    @GetMapping(value={"/user/{userId}"})
    public Map<String, Object> queryUserInfoByUserId(@PathVariable(value="userId") String var1);
}

