/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.service;

import cn.com.yusys.yusp.app.oca.dto.UserDTO;
import cn.com.yusys.yusp.commons.dto.def.ContrBean;
import cn.com.yusys.yusp.commons.dto.def.DataContrDTO;
import cn.com.yusys.yusp.commons.dto.def.MenuContrDTO;
import cn.com.yusys.yusp.commons.dto.def.UserInfoDTO;
import cn.com.yusys.yusp.service.UserProviderServiceHystrix;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(fallback=UserProviderServiceHystrix.class, name="sp-app-oca", path="/api")
public interface UserProviderService {
    @RequestMapping(method={RequestMethod.GET}, value={"/contr/url"})
    public List<ContrBean> getAllContrUrl();

    @RequestMapping(method={RequestMethod.GET}, value={"/user/usercode"})
    public String getUserCode();

    @RequestMapping(method={RequestMethod.GET}, value={"/session/info"})
    public UserInfoDTO getUserInfo(@RequestParam(value="loginCode") String var1, @RequestParam(value="sysId") String var2);

    @RequestMapping(method={RequestMethod.GET}, value={"/user/menuandcontr"})
    public MenuContrDTO getMenuandContr(@RequestParam(value="loginCode") String var1, @RequestParam(value="sysId") String var2);

    @RequestMapping(method={RequestMethod.GET}, value={"/user/dataauth"})
    public List<DataContrDTO> getDataAuth(@RequestParam(value="loginCode") String var1, @RequestParam(value="sysId") String var2);

    @RequestMapping(method={RequestMethod.GET}, value={"/contr/clearUrl"})
    public void cleanAllContrUrlCache();

    @RequestMapping(method={RequestMethod.GET}, value={"/cleanUserInfoCache"})
    public void cleanUserInfoCache();

    @RequestMapping(method={RequestMethod.GET}, value={"/cleanMenuAndContrCache"})
    public void cleanMenuAndContrCache();

    @RequestMapping(method={RequestMethod.GET}, value={"/cleanDataContrCache"})
    public void cleanDataContrCache();

    @GetMapping(value={"/user/org/{orgId}"})
    public List<String> queryUserByOrgId(@PathVariable(value="orgId") String var1);

    @PostMapping(value={"/user/orgs"})
    public List<String> queryUserByOrgIds(@RequestBody List<String> var1);

    @GetMapping(value={"/user/role/{roleId}"})
    public List<String> queryUserByRoleId(@PathVariable(value="roleId") String var1);

    @GetMapping(value={"/user/duty/{dutyId}"})
    public List<String> queryUserByDutyId(@PathVariable(value="dutyId") String var1);

    @GetMapping(value={"/org/user/{userId}"})
    public List<String> queryOrgsByUserId(@PathVariable(value="userId") String var1);

    @GetMapping(value={"/org/logincode/{loginCode}"})
    public List<String> queryOrgsByLoginCode(@PathVariable(value="loginCode") String var1);

    @GetMapping(value={"/org/uporg/{upOrgId}"})
    public List<String> queryOrgsByUpOrgId(@PathVariable(value="upOrgId") String var1);

    @GetMapping(value={"/uporg/org/{orgId}"})
    public List<String> queryUpOrgByOrgId(@PathVariable(value="orgId") String var1);

    @GetMapping(value={"/user/{userId}"})
    public UserDTO queryUserInfoByUserId(@PathVariable(value="userId") String var1);

    @GetMapping(value={"/user/role/query/{roleCode}"})
    public List<String> queryUserByRoleCode(@PathVariable(value="roleCode") String var1);

    @GetMapping(value={"/user/duty/query/{dutyCode}"})
    public List<String> queryUserByDutyCode(@PathVariable(value="dutyCode") String var1);

    @GetMapping(value={"/user/query/{orgId}"})
    public List<String> queryUserCodeByOrgId(@PathVariable(value="orgId") String var1);

    @GetMapping(value={"/user/uporg/query/{orgId}"})
    public List<String> queryUpOrgUserByOrg(@PathVariable(value="orgId") String var1);
}

