/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.service.aspect;

import cn.com.yusys.yusp.service.dto.FoxReq;
import cn.com.yusys.yusp.service.dto.FoxResp;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class FoxLoggerAspect {
    private static final Logger logger = LoggerFactory.getLogger(FoxLoggerAspect.class);

    @Pointcut(value="execution(* cn.com.yusys.yusp.service.IFoxFeign.call(..))")
    public void log() {
    }

    @Before(value="log()")
    public void doBefore(JoinPoint joinPoint) {
        Object[] obj = joinPoint.getArgs();
        if (obj != null && obj.length > 0 && obj[0] instanceof FoxReq) {
            FoxReq req = (FoxReq)obj[0];
            logger.info(String.format("Fox\u8bf7\u6c42\u62a5\u6587\uff1aserviceCode[%s]", req.getHeaderServiceCode()));
            logger.debug("\u8bf7\u6c42\u62a5\u6587\n" + req.toString());
        }
    }

    @AfterReturning(pointcut="log()", returning="foxResp")
    public void doAfterReturning(FoxResp foxResp) {
        if (foxResp != null) {
            logger.info(String.format("Fox\u8fd4\u56de\u62a5\u6587\uff1aserviceCode[%s] code[%s] msg[%s] ", foxResp.getServiceCode(), foxResp.getCode(), foxResp.getMsg()));
            logger.debug("\u8fd4\u56de\u62a5\u6587\n" + foxResp.toString());
        }
    }
}

