/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.service.aspect;

import cn.com.yusys.yusp.service.dto.ESBReq;
import cn.com.yusys.yusp.service.dto.ESBResp;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class EsbLoggerAspect {
    private static final Logger logger = LoggerFactory.getLogger(EsbLoggerAspect.class);

    @Pointcut(value="execution(* cn.com.yusys.yusp.service.IESBFeign.call(..))")
    public void log() {
    }

    @Before(value="log()")
    public void doBefore(JoinPoint joinPoint) {
        Object[] obj = joinPoint.getArgs();
        if (obj != null && obj.length > 0 && obj[0] instanceof ESBReq) {
            ESBReq req = (ESBReq)obj[0];
            logger.info(String.format("ESB\u8bf7\u6c42\u62a5\u6587\uff1aserviceCode[%s] tranSeqNo[%s]", req.getServiceCode(), req.getTranSeqNo()));
            logger.debug("\u8bf7\u6c42\u62a5\u6587\n" + req.toString());
        }
    }

    @AfterReturning(pointcut="log()", returning="esbResp")
    public void doAfterReturning(ESBResp esbResp) {
        if (esbResp != null) {
            logger.info(String.format("ESB\u8fd4\u56de\u62a5\u6587\uff1aserviceCode[%s] tranSeqNo[%s]  retCode[%s] retMsg[%s] ", esbResp.getServiceCode(), esbResp.getTranSeqNo(), esbResp.getRetCode(), esbResp.getRetMsg()));
            logger.debug("\u8fd4\u56de\u62a5\u6587\n" + esbResp.toString());
        }
    }
}

