/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.pay.router.application.service;

import cn.com.yusys.yusp.pay.router.application.dto.RtPPaychnlRspDto;
import cn.com.yusys.yusp.pay.router.application.dto.UpPBankinfoextReqDto;
import cn.com.yusys.yusp.pay.router.application.dto.UpPBankinfoextRspDto;
import cn.com.yusys.yusp.pay.router.application.service.RouterDimensionService;
import cn.com.yusys.yusp.pay.router.application.service.RtPPaychnlService;
import cn.com.yusys.yusp.pay.router.application.service.UpPBankinfoextService;
import cn.com.yusys.yusp.payment.common.base.dto.assembly.JavaDict;
import cn.com.yusys.yusp.payment.common.base.dto.exception.YuinException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RouterFilterService {
    @Autowired
    private RouterDimensionService routerDimensionService;
    @Autowired
    private RtPPaychnlService rtPPaychnlService;
    @Autowired
    private UpPBankinfoextService upPBankinfoextService;

    public String filterByBankno(JavaDict routerDict) throws Exception {
        String bankno = routerDict.getString("recvbank");
        if (StringUtils.isEmpty((String)bankno)) {
            throw new YuinException("\u63a5\u6536\u884c\u884c\u53f7recvbank\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        UpPBankinfoextReqDto upPBankinfoextReqDto = new UpPBankinfoextReqDto();
        upPBankinfoextReqDto.setBankno(bankno);
        upPBankinfoextReqDto.setEffectflag("1");
        upPBankinfoextReqDto.setDisabled("0");
        List<UpPBankinfoextRspDto> upPBankinfoextRspDtoList = this.upPBankinfoextService.list(upPBankinfoextReqDto);
        if (CollectionUtils.isEmpty(upPBankinfoextRspDtoList)) {
            throw new YuinException(String.format("\u884c\u53f7\u3010%s\u3011\u65e0\u53ef\u7528\u652f\u4ed8\u901a\u9053\u914d\u7f6e\uff01", bankno));
        }
        String initPaychnl = routerDict.getString("initPaychnl");
        ArrayList<String> paychnlcodeList = new ArrayList<String>();
        if (StringUtils.isEmpty((String)initPaychnl)) {
            for (UpPBankinfoextRspDto upPBankinfoextRspDto : upPBankinfoextRspDtoList) {
                paychnlcodeList.add(upPBankinfoextRspDto.getAppid());
            }
        } else {
            for (UpPBankinfoextRspDto upPBankinfoextRspDto : upPBankinfoextRspDtoList) {
                if (!initPaychnl.contains(upPBankinfoextRspDto.getAppid())) continue;
                paychnlcodeList.add(upPBankinfoextRspDto.getAppid());
            }
        }
        return StringUtils.join(paychnlcodeList, (String)",");
    }

    public List<RtPPaychnlRspDto> listPaychnl(String paychnlcodes) throws Exception {
        return this.rtPPaychnlService.listByPaychnlcode(paychnlcodes);
    }

    public void filterDimension(JavaDict routerDict, List<RtPPaychnlRspDto> rtPPaychnlRspDtoList) throws Exception {
        String routeprodcode = routerDict.getString("routeprodcode");
        if (StringUtils.isEmpty((String)routeprodcode)) {
            throw new YuinException("\u8def\u7531\u4ea7\u54c1\u4ee3\u7801\u4e3a\u7a7a\uff01");
        }
        HashMap<String, String> fixedOrderMap = new HashMap<String, String>();
        Map<String, List<String>> routecodeMap = this.routerDimensionService.getDimensionMap(routerDict, routeprodcode);
        List<String> paychnlcodeList = rtPPaychnlRspDtoList.stream().map(RtPPaychnlRspDto::getPaychnlcode).collect(Collectors.toList());
        if (routecodeMap.containsKey("1")) {
            Set<String> paychnlSet = this.routerDimensionService.listPaychnlByFixedroute(StringUtils.join((Collection)routecodeMap.get("1"), (String)","), fixedOrderMap);
            this.routerDimensionService.routeFilter(rtPPaychnlRspDtoList, paychnlSet, "1");
            if (CollectionUtils.isEmpty(rtPPaychnlRspDtoList)) {
                throw new YuinException("\u65e0\u53ef\u7528\u652f\u4ed8\u901a\u9053\uff01");
            }
            for (RtPPaychnlRspDto rtPPaychnlRspDto : rtPPaychnlRspDtoList) {
                rtPPaychnlRspDto.setPriority((String)fixedOrderMap.get(rtPPaychnlRspDto.getPaychnlcode()));
            }
            rtPPaychnlRspDtoList.sort(Comparator.comparingInt(x -> Integer.valueOf(x.getPriority())));
        } else {
            String[] filtermethod = routerDict.getOrDefault((Object)"filtermethod", (Object)"").toString().split(",");
            for (String routetype : filtermethod) {
                if (CollectionUtils.isEmpty(paychnlcodeList)) {
                    throw new YuinException("\u65e0\u53ef\u7528\u652f\u4ed8\u901a\u9053\uff01");
                }
                if ("2".equals(routetype) && routecodeMap.containsKey(routetype)) {
                    this.routerDimensionService.listPaychnlByChnlroute(routerDict, StringUtils.join((Collection)routecodeMap.get(routetype), (String)","), paychnlcodeList);
                    continue;
                }
                if ("3".equals(routetype) && routecodeMap.containsKey(routetype)) {
                    this.routerDimensionService.listPaychnlByBusiroute(routerDict, StringUtils.join((Collection)routecodeMap.get(routetype), (String)","), paychnlcodeList);
                    continue;
                }
                if ("4".equals(routetype) && routecodeMap.containsKey(routetype)) {
                    this.routerDimensionService.listPaychnlByCcyroute(routerDict, StringUtils.join((Collection)routecodeMap.get(routetype), (String)","), paychnlcodeList);
                    continue;
                }
                if ("5".equals(routetype) && routecodeMap.containsKey(routetype)) {
                    this.routerDimensionService.listPaychnlByAmtroute(routerDict, StringUtils.join((Collection)routecodeMap.get(routetype), (String)","), paychnlcodeList);
                    continue;
                }
                if ("6".equals(routetype) && routecodeMap.containsKey(routetype)) {
                    this.routerDimensionService.listPaychnlByEffectroute(routerDict, StringUtils.join((Collection)routecodeMap.get(routetype), (String)","), paychnlcodeList);
                    continue;
                }
                if (!"7".equals(routetype) || !routecodeMap.containsKey(routetype)) continue;
                this.routerDimensionService.listPaychnlByTimeroute(routerDict, StringUtils.join((Collection)routecodeMap.get(routetype), (String)","), paychnlcodeList);
            }
            if (CollectionUtils.isEmpty(paychnlcodeList)) {
                throw new YuinException("\u65e0\u53ef\u7528\u652f\u4ed8\u901a\u9053\uff01");
            }
            this.routerDimensionService.routeFilter(rtPPaychnlRspDtoList, paychnlcodeList, "1");
            this.routerDimensionService.routeOrder(rtPPaychnlRspDtoList, routeprodcode, routerDict);
        }
        ArrayList<String> routeList = new ArrayList<String>();
        for (RtPPaychnlRspDto rtPPaychnlRspDto : rtPPaychnlRspDtoList) {
            routeList.add(rtPPaychnlRspDto.getPaychnlcode());
        }
        routerDict.set("routeList", (Object)StringUtils.join(routeList, (String)","));
    }
}

