/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.pay.router.application.service;

import cn.com.yusys.yusp.commons.util.date.DateUtils;
import cn.com.yusys.yusp.pay.router.application.dto.RtPAmtrouteReqDto;
import cn.com.yusys.yusp.pay.router.application.dto.RtPAmtrouteRspDto;
import cn.com.yusys.yusp.pay.router.application.dto.RtPBusirouteReqDto;
import cn.com.yusys.yusp.pay.router.application.dto.RtPBusirouteRspDto;
import cn.com.yusys.yusp.pay.router.application.dto.RtPCcyrouteReqDto;
import cn.com.yusys.yusp.pay.router.application.dto.RtPCcyrouteRspDto;
import cn.com.yusys.yusp.pay.router.application.dto.RtPChnlrouteReqDto;
import cn.com.yusys.yusp.pay.router.application.dto.RtPChnlrouteRspDto;
import cn.com.yusys.yusp.pay.router.application.dto.RtPEffectrouteReqDto;
import cn.com.yusys.yusp.pay.router.application.dto.RtPEffectrouteRspDto;
import cn.com.yusys.yusp.pay.router.application.dto.RtPFixedrouteReqDto;
import cn.com.yusys.yusp.pay.router.application.dto.RtPFixedrouteRspDto;
import cn.com.yusys.yusp.pay.router.application.dto.RtPPaychnlRspDto;
import cn.com.yusys.yusp.pay.router.application.dto.RtPRouteorderReqDto;
import cn.com.yusys.yusp.pay.router.application.dto.RtPRouteorderRspDto;
import cn.com.yusys.yusp.pay.router.application.dto.RtPRouteprodmapReqDto;
import cn.com.yusys.yusp.pay.router.application.dto.RtPRouteprodmapRspDto;
import cn.com.yusys.yusp.pay.router.application.dto.RtPTimerouteReqDto;
import cn.com.yusys.yusp.pay.router.application.dto.RtPTimerouteRspDto;
import cn.com.yusys.yusp.pay.router.application.service.RtPAmtrouteService;
import cn.com.yusys.yusp.pay.router.application.service.RtPBusirouteService;
import cn.com.yusys.yusp.pay.router.application.service.RtPCcyrouteService;
import cn.com.yusys.yusp.pay.router.application.service.RtPChnlrouteService;
import cn.com.yusys.yusp.pay.router.application.service.RtPEffectrouteService;
import cn.com.yusys.yusp.pay.router.application.service.RtPFixedrouteService;
import cn.com.yusys.yusp.pay.router.application.service.RtPRouteorderService;
import cn.com.yusys.yusp.pay.router.application.service.RtPRouteprodmapService;
import cn.com.yusys.yusp.pay.router.application.service.RtPTimerouteService;
import cn.com.yusys.yusp.payment.common.base.dto.assembly.JavaDict;
import cn.com.yusys.yusp.payment.common.base.dto.exception.YuinException;
import cn.hutool.core.date.DateUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RouterDimensionService {
    @Autowired
    private RtPRouteprodmapService rtPRouteprodmapService;
    @Autowired
    private RtPFixedrouteService rtPFixedrouteService;
    @Autowired
    private RtPChnlrouteService rtPChnlrouteService;
    @Autowired
    private RtPBusirouteService rtPBusirouteService;
    @Autowired
    private RtPCcyrouteService rtPCcyrouteService;
    @Autowired
    private RtPAmtrouteService rtPAmtrouteService;
    @Autowired
    private RtPEffectrouteService rtPEffectrouteService;
    @Autowired
    private RtPTimerouteService rtPTimerouteService;
    @Autowired
    private RtPRouteorderService rtPRouteorderService;

    public Map<String, List<String>> getDimensionMap(JavaDict routerDict, String routeprodcode) {
        RtPRouteprodmapReqDto rtPRouteprodmapReqDto = new RtPRouteprodmapReqDto();
        rtPRouteprodmapReqDto.setRouteprodcode(routeprodcode);
        rtPRouteprodmapReqDto.setDisabled("0");
        List<RtPRouteprodmapRspDto> rtPRouteprodmapRspDtoList = this.rtPRouteprodmapService.list(rtPRouteprodmapReqDto);
        if (CollectionUtils.isEmpty(rtPRouteprodmapRspDtoList)) {
            throw new YuinException("\u65e0\u53ef\u7528\u8def\u7531\u6620\u5c04\u5173\u7cfb\uff01");
        }
        HashMap<String, List<String>> routecodeMap = new HashMap<String, List<String>>();
        for (RtPRouteprodmapRspDto rtPRouteprodmapRspDto : rtPRouteprodmapRspDtoList) {
            ArrayList<String> routecodeList;
            if ("5".equals(rtPRouteprodmapRspDto.getRoutetype()) && !routecodeMap.containsKey("5")) {
                routecodeList = new ArrayList<String>();
                String urgentflg = routerDict.getString("urgentflg");
                if (!StringUtils.isEmpty((String)urgentflg) && "1".equals(urgentflg)) {
                    routecodeList.add("XPD");
                } else {
                    routecodeList.add("PUB");
                }
                routecodeMap.put("5", routecodeList);
                continue;
            }
            if (routecodeMap.containsKey(rtPRouteprodmapRspDto.getRoutetype())) {
                ((List)routecodeMap.get(rtPRouteprodmapRspDto.getRoutetype())).add(rtPRouteprodmapRspDto.getRoutecode());
                continue;
            }
            routecodeList = new ArrayList();
            routecodeList.add(rtPRouteprodmapRspDto.getRoutecode());
            routecodeMap.put(rtPRouteprodmapRspDto.getRoutetype(), routecodeList);
        }
        return routecodeMap;
    }

    public Set<String> listPaychnlByFixedroute(String routecode, Map<String, String> orderMap) {
        RtPFixedrouteReqDto rtPFixedrouteReqDto = new RtPFixedrouteReqDto();
        rtPFixedrouteReqDto.setRoutecode(routecode);
        rtPFixedrouteReqDto.setDisabled("0");
        rtPFixedrouteReqDto.setEffectdate(DateUtils.formatDate((String)"yyyyMMdd"));
        List<RtPFixedrouteRspDto> rtPFixedrouteRspDtoList = this.rtPFixedrouteService.list(rtPFixedrouteReqDto);
        if (CollectionUtils.isEmpty(rtPFixedrouteRspDtoList)) {
            throw new YuinException(String.format("\u65e0\u53ef\u7528\u56fa\u5b9a\u8def\u7531\u914d\u7f6e\uff01", new Object[0]));
        }
        HashSet<String> set = new HashSet<String>();
        for (RtPFixedrouteRspDto rtPFixedrouteRspDto : rtPFixedrouteRspDtoList) {
            set.add(rtPFixedrouteRspDto.getPaychnlcode());
            orderMap.put(rtPFixedrouteRspDto.getPaychnlcode(), rtPFixedrouteRspDto.getPriority());
        }
        return set;
    }

    public void listPaychnlByChnlroute(JavaDict routerDict, String routecode, List<String> paychnlcodeList) {
        String chnlcode = routerDict.getString("chnlcode");
        if (StringUtils.isEmpty((String)chnlcode)) {
            throw new YuinException("\u6e20\u9053\u7ef4\u5ea6\uff0c\u4ea4\u6613\u6e20\u9053\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        RtPChnlrouteReqDto rtPChnlrouteReqDto = new RtPChnlrouteReqDto();
        rtPChnlrouteReqDto.setRoutecode(routecode);
        rtPChnlrouteReqDto.setPaychnlcode(StringUtils.join(paychnlcodeList, (String)","));
        rtPChnlrouteReqDto.setDisabled("0");
        rtPChnlrouteReqDto.setEffectdate(DateUtils.formatDate((String)"yyyyMMdd"));
        List<RtPChnlrouteRspDto> rtPChnlrouteRspDtoList = this.rtPChnlrouteService.list(rtPChnlrouteReqDto);
        if (CollectionUtils.isEmpty(rtPChnlrouteRspDtoList)) {
            return;
        }
        for (int i = 0; i < paychnlcodeList.size(); ++i) {
            String paychnlcode = paychnlcodeList.get(i);
            List newlist = rtPChnlrouteRspDtoList.stream().filter(obj -> paychnlcode.equals(obj.getPaychnlcode())).collect(Collectors.toList());
            if (!CollectionUtils.isNotEmpty(newlist)) continue;
            boolean pass = false;
            for (RtPChnlrouteRspDto rtPChnlrouteRspDto : newlist) {
                if (!chnlcode.equals(rtPChnlrouteRspDto.getChnlcode())) continue;
                pass = true;
                break;
            }
            if (pass) continue;
            paychnlcodeList.remove(i);
            --i;
        }
    }

    public void listPaychnlByBusiroute(JavaDict routerDict, String routecode, List<String> paychnlcodeList) {
        String busitype = routerDict.getString("busitype");
        String busikind = routerDict.getString("busikind");
        if (StringUtils.isEmpty((String)busitype) || StringUtils.isEmpty((String)busikind)) {
            throw new YuinException("\u4e1a\u52a1\u7ef4\u5ea6\uff0c\u4e1a\u52a1\u7c7b\u578b\u3001\u4e1a\u52a1\u79cd\u7c7b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        RtPBusirouteReqDto rtPBusirouteReqDto = new RtPBusirouteReqDto();
        rtPBusirouteReqDto.setRoutecode(routecode);
        rtPBusirouteReqDto.setPaychnlcode(StringUtils.join(paychnlcodeList, (String)","));
        rtPBusirouteReqDto.setDisabled("0");
        rtPBusirouteReqDto.setEffectdate(DateUtils.formatDate((String)"yyyyMMdd"));
        List<RtPBusirouteRspDto> rtPBusirouteRspDtoList = this.rtPBusirouteService.list(rtPBusirouteReqDto);
        if (CollectionUtils.isEmpty(rtPBusirouteRspDtoList)) {
            return;
        }
        for (int i = 0; i < paychnlcodeList.size(); ++i) {
            String paychnlcode = paychnlcodeList.get(i);
            List newlist = rtPBusirouteRspDtoList.stream().filter(obj -> paychnlcode.equals(obj.getPaychnlcode())).collect(Collectors.toList());
            if (!CollectionUtils.isNotEmpty(newlist)) continue;
            boolean pass = false;
            for (RtPBusirouteRspDto rtPBusirouteRspDto : newlist) {
                if (!busitype.equals(rtPBusirouteRspDto.getBusitype()) || !busikind.equals(rtPBusirouteRspDto.getBusikind())) continue;
                pass = true;
                break;
            }
            if (pass) continue;
            paychnlcodeList.remove(i);
            --i;
        }
    }

    public void listPaychnlByCcyroute(JavaDict routerDict, String routecode, List<String> paychnlcodeList) {
        String ccy = routerDict.getString("ccy");
        if (StringUtils.isEmpty((String)ccy)) {
            throw new YuinException("\u5e01\u79cd\u7ef4\u5ea6\uff0c\u652f\u4ed8\u5e01\u79cd\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        RtPCcyrouteReqDto rtPCcyrouteReqDto = new RtPCcyrouteReqDto();
        rtPCcyrouteReqDto.setRoutecode(routecode);
        rtPCcyrouteReqDto.setPaychnlcode(StringUtils.join(paychnlcodeList, (String)","));
        rtPCcyrouteReqDto.setDisabled("0");
        rtPCcyrouteReqDto.setEffectdate(DateUtils.formatDate((String)"yyyyMMdd"));
        List<RtPCcyrouteRspDto> rtPCcyrouteRspDtoList = this.rtPCcyrouteService.list(rtPCcyrouteReqDto);
        if (CollectionUtils.isEmpty(rtPCcyrouteRspDtoList)) {
            return;
        }
        for (int i = 0; i < paychnlcodeList.size(); ++i) {
            String paychnlcode = paychnlcodeList.get(i);
            List newlist = rtPCcyrouteRspDtoList.stream().filter(obj -> paychnlcode.equals(obj.getPaychnlcode())).collect(Collectors.toList());
            if (!CollectionUtils.isNotEmpty(newlist)) continue;
            boolean pass = false;
            for (RtPCcyrouteRspDto rtPCcyrouteRspDto : newlist) {
                if (!ccy.equals(rtPCcyrouteRspDto.getCcy())) continue;
                pass = true;
                break;
            }
            if (pass) continue;
            paychnlcodeList.remove(i);
            --i;
        }
    }

    public void listPaychnlByAmtroute(JavaDict routerDict, String routecode, List<String> paychnlcodeList) {
        String ccy = routerDict.getString("ccy");
        String amt = routerDict.getString("amt");
        if (StringUtils.isEmpty((String)ccy) || StringUtils.isEmpty((String)amt)) {
            throw new YuinException("\u9650\u989d\u7ef4\u5ea6\uff0c\u652f\u4ed8\u5e01\u79cd\u3001\u652f\u4ed8\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        RtPAmtrouteReqDto rtPAmtrouteReqDto = new RtPAmtrouteReqDto();
        rtPAmtrouteReqDto.setRoutecode(routecode);
        rtPAmtrouteReqDto.setPaychnlcode(StringUtils.join(paychnlcodeList, (String)","));
        rtPAmtrouteReqDto.setCcy(ccy);
        rtPAmtrouteReqDto.setDisabled("0");
        rtPAmtrouteReqDto.setEffectdate(DateUtils.formatDate((String)"yyyyMMdd"));
        List<RtPAmtrouteRspDto> rtPAmtrouteRspDtoList = this.rtPAmtrouteService.list(rtPAmtrouteReqDto);
        if (CollectionUtils.isEmpty(rtPAmtrouteRspDtoList)) {
            return;
        }
        for (int i = 0; i < paychnlcodeList.size(); ++i) {
            String paychnlcode = paychnlcodeList.get(i);
            List newlist = rtPAmtrouteRspDtoList.stream().filter(obj -> paychnlcode.equals(obj.getPaychnlcode())).collect(Collectors.toList());
            if (!CollectionUtils.isNotEmpty(newlist)) continue;
            boolean pass = false;
            for (RtPAmtrouteRspDto rtPAmtrouteRspDto : newlist) {
                if (!(Double.valueOf(amt) > Double.valueOf(rtPAmtrouteRspDto.getLoweramt())) || !(Double.valueOf(amt) < Double.valueOf(rtPAmtrouteRspDto.getUpamt()))) continue;
                pass = true;
                break;
            }
            if (pass) continue;
            paychnlcodeList.remove(i);
            --i;
        }
    }

    public void listPaychnlByEffectroute(JavaDict routerDict, String routecode, List<String> paychnlcodeList) {
        String timeeffect = routerDict.getString("timeeffect");
        if (StringUtils.isEmpty((String)timeeffect)) {
            throw new YuinException("\u65f6\u6548\u7ef4\u5ea6\uff0c\u652f\u4ed8\u65f6\u6548\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        RtPEffectrouteReqDto rtPEffectrouteReqDto = new RtPEffectrouteReqDto();
        rtPEffectrouteReqDto.setRoutecode(routecode);
        rtPEffectrouteReqDto.setPaychnlcode(StringUtils.join(paychnlcodeList, (String)","));
        rtPEffectrouteReqDto.setDisabled("0");
        rtPEffectrouteReqDto.setEffectdate(DateUtils.formatDate((String)"yyyyMMdd"));
        List<RtPEffectrouteRspDto> rtPEffectrouteRspDtoList = this.rtPEffectrouteService.list(rtPEffectrouteReqDto);
        if (CollectionUtils.isEmpty(rtPEffectrouteRspDtoList)) {
            return;
        }
        for (int i = 0; i < paychnlcodeList.size(); ++i) {
            String paychnlcode = paychnlcodeList.get(i);
            List newlist = rtPEffectrouteRspDtoList.stream().filter(obj -> paychnlcode.equals(obj.getPaychnlcode())).collect(Collectors.toList());
            if (!CollectionUtils.isNotEmpty(newlist)) continue;
            boolean pass = false;
            for (RtPEffectrouteRspDto rtPEffectrouteRspDto : newlist) {
                if (!timeeffect.equals(rtPEffectrouteRspDto.getTimeeffect())) continue;
                pass = true;
                break;
            }
            if (pass) continue;
            paychnlcodeList.remove(i);
            --i;
        }
    }

    public void listPaychnlByTimeroute(JavaDict routerDict, String routecode, List<String> paychnlcodeList) {
        int week = DateUtil.dayOfWeek((Date)new Date()) - 1;
        RtPTimerouteReqDto rtPTimerouteReqDto = new RtPTimerouteReqDto();
        rtPTimerouteReqDto.setRoutecode(routecode);
        rtPTimerouteReqDto.setPaychnlcode(StringUtils.join(paychnlcodeList, (String)","));
        rtPTimerouteReqDto.setWeek(String.valueOf(week));
        rtPTimerouteReqDto.setDisabled("0");
        rtPTimerouteReqDto.setEffectdate(DateUtils.formatDate((String)"yyyyMMdd"));
        List<RtPTimerouteRspDto> rtPTimerouteRspDtoList = this.rtPTimerouteService.list(rtPTimerouteReqDto);
        if (CollectionUtils.isEmpty(rtPTimerouteRspDtoList)) {
            throw new YuinException("\u672a\u83b7\u53d6\u5230\u661f\u671f\u65f6\u95f4\u7ef4\u5ea6\u914d\u7f6e\uff0c\u65e0\u53ef\u7528\u652f\u4ed8\u901a\u9053\uff01");
        }
        String nowTime = DateUtils.formatDate((Date)new Date(), (String)"HH:mm:ss");
        for (int i = 0; i < paychnlcodeList.size(); ++i) {
            String paychnlcode = paychnlcodeList.get(i);
            List newlist = rtPTimerouteRspDtoList.stream().filter(obj -> paychnlcode.equals(obj.getPaychnlcode())).collect(Collectors.toList());
            boolean pass = false;
            for (RtPTimerouteRspDto RtPTimerouteRspDto2 : newlist) {
                if (nowTime.compareTo(RtPTimerouteRspDto2.getStarttime()) <= 0 || nowTime.compareTo(RtPTimerouteRspDto2.getEndtime()) >= 0) continue;
                pass = true;
                break;
            }
            if (pass) continue;
            paychnlcodeList.remove(i);
            --i;
        }
    }

    public void routeFilter(List<RtPPaychnlRspDto> rtPPaychnlRspDtoList, Collection<String> paychnlList, String flag) throws Exception {
        if (CollectionUtils.isNotEmpty(paychnlList)) {
            for (int i = 0; i < rtPPaychnlRspDtoList.size(); ++i) {
                if ("1".equals(flag) && !paychnlList.contains(rtPPaychnlRspDtoList.get(i).getPaychnlcode())) {
                    rtPPaychnlRspDtoList.remove(i);
                    --i;
                    continue;
                }
                if (!paychnlList.contains(rtPPaychnlRspDtoList.get(i).getPaychnlcode())) continue;
                rtPPaychnlRspDtoList.remove(i);
                --i;
            }
        }
    }

    public void routeOrder(List<RtPPaychnlRspDto> rtPPaychnlRspDtoList, String routeprodcode, JavaDict routerDict) throws Exception {
        String ordermethod = routerDict.getString("ordermethod");
        if (StringUtils.isEmpty((String)ordermethod)) {
            throw new YuinException("\u7ef4\u5ea6\u8def\u7531\u6392\u5e8f\uff0c\u672a\u83b7\u53d6\u5230\u6392\u5e8f\u65b9\u6cd5\uff01");
        }
        RtPRouteorderReqDto rtPRouteorderReqDto = new RtPRouteorderReqDto();
        rtPRouteorderReqDto.setRouteprodcode(routeprodcode);
        rtPRouteorderReqDto.setOrderflag(ordermethod);
        List<RtPRouteorderRspDto> rtPRouteorderRspDtoList = this.rtPRouteorderService.list(rtPRouteorderReqDto);
        HashMap<String, String> weightMap = new HashMap<String, String>();
        for (RtPRouteorderRspDto rtPRouteorderRspDto : rtPRouteorderRspDtoList) {
            weightMap.put(rtPRouteorderRspDto.getPaychnlcode(), rtPRouteorderRspDto.getWeight());
        }
        ArrayList<String> routeList = new ArrayList<String>();
        Iterator<RtPPaychnlRspDto> iterator = rtPPaychnlRspDtoList.iterator();
        while (iterator.hasNext()) {
            RtPPaychnlRspDto rtPPaychnlRspDto;
            String weight = (String)weightMap.get((rtPPaychnlRspDto = iterator.next()).getPaychnlcode());
            rtPPaychnlRspDto.setWeight(StringUtils.isEmpty((String)weight) ? "999999" : weight);
            routeList.add(rtPPaychnlRspDto.getPaychnlcode());
        }
        routerDict.set("routeList", (Object)StringUtils.join(routeList, (String)","));
        rtPPaychnlRspDtoList.sort(Comparator.comparingInt(x -> Integer.valueOf(x.getWeight())));
    }
}

