/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.pay.position.domain.service;

import cn.com.yusys.yusp.commons.sequence.util.SequenceUtils;
import cn.com.yusys.yusp.commons.util.date.DateFormatEnum;
import cn.com.yusys.yusp.commons.util.date.DateUtils;
import cn.com.yusys.yusp.pay.position.domain.util.CommonUtil;
import cn.com.yusys.yusp.pay.position.domain.util.PSEsbConfigurationMsg;
import cn.com.yusys.yusp.pay.position.domain.vo.esb.EsbReqMsgVo;
import cn.com.yusys.yusp.pay.position.domain.vo.esb.HostCbsstdReqVo;
import cn.com.yusys.yusp.pay.position.domain.vo.esb.SVS110ReqBody;
import cn.com.yusys.yusp.pay.position.domain.vo.esb.SVS110ReqVo;
import cn.com.yusys.yusp.payment.common.base.dto.ReqCommInfo;
import com.alibaba.fastjson.JSON;
import java.net.UnknownHostException;
import java.util.Map;
import net.sf.cglib.beans.BeanMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
public class SVS110DomainService {
    private static final Logger log = LoggerFactory.getLogger(SVS110DomainService.class);
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private PSEsbConfigurationMsg psEsbConfigurationMsg;

    public ResponseEntity<String> svs110191(String filename, String brahcNm, String acctNbr) throws UnknownHostException {
        ReqCommInfo reqCommInfo = this.createHostReqCommInfo(filename, brahcNm, acctNbr);
        log.info(String.format("SVS110-191\u751f\u6210\u62a5\u6587\u6210\u529f%s", JSON.toJSONString((Object)reqCommInfo)));
        String url = this.psEsbConfigurationMsg.getUrl();
        log.info(String.format("SVS110-191\u53d1\u8d77\u8bf7\u6c42\uff1a\u8bf7\u6c42\u8def\u5f84%s ", url));
        ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)reqCommInfo, String.class, new Object[0]);
        log.info(String.format("SVS110-191\u5e94\u7b54\u62a5\u6587%s ", JSON.toJSONString((Object)responseEntity)));
        return responseEntity;
    }

    private ReqCommInfo createHostReqCommInfo(String filename, String brahcNm, String acctNbr) throws UnknownHostException {
        log.info("SVS110-191\u751f\u6210\u62a5\u6587\u5f00\u59cb---");
        ReqCommInfo reqCommInfo = new ReqCommInfo();
        reqCommInfo.setSysid("FXPS");
        reqCommInfo.setAppid("FXPS");
        reqCommInfo.setHostcommid("FXPS");
        EsbReqMsgVo esbReqMsgVo = new EsbReqMsgVo();
        esbReqMsgVo.setMsgCd("CBS.00SVS1100.01");
        esbReqMsgVo.setSeqNb(SequenceUtils.getSequence((String)"esbseqid"));
        log.info(String.format("seqNb\uff1a%s", esbReqMsgVo.getSeqNb()));
        esbReqMsgVo.setSndAppCd(this.psEsbConfigurationMsg.getAppcd());
        esbReqMsgVo.setSndDt(DateUtils.getCurrentDate((DateFormatEnum)DateFormatEnum.DATE_COMPACT));
        esbReqMsgVo.setSndTm(DateUtils.getCurrentDate((DateFormatEnum)DateFormatEnum.TIME_COMPACT));
        esbReqMsgVo.setCallTyp("SYN");
        esbReqMsgVo.setRcvAppCd("CBS");
        HostCbsstdReqVo hostCbsstdreqVo = new HostCbsstdReqVo();
        String time = DateUtils.getCurrentDate((DateFormatEnum)DateFormatEnum.TIME).replace(':', '.');
        String date = DateUtils.getCurrentDate((DateFormatEnum)DateFormatEnum.DEFAULT);
        String seqid = SequenceUtils.getSequence((String)"hostseqid");
        log.info(String.format("hostseqid\uff1a%s", seqid));
        hostCbsstdreqVo.setInfTp("RQ");
        hostCbsstdreqVo.setSvcCd("SVS110");
        hostCbsstdreqVo.setBsnTxDt(date);
        hostCbsstdreqVo.setSysDt(date);
        hostCbsstdreqVo.setSysTm(time);
        hostCbsstdreqVo.setBrNbr("01101");
        hostCbsstdreqVo.setSecFlg("0");
        hostCbsstdreqVo.setTlrNbr("888888");
        hostCbsstdreqVo.setTxFlg("0");
        hostCbsstdreqVo.setTxSeqNbr(seqid);
        hostCbsstdreqVo.setAuthInfFlg("0");
        hostCbsstdreqVo.setInptWordFlg("0");
        hostCbsstdreqVo.setSignInfFlg("0");
        hostCbsstdreqVo.setRmtAhrAplFlg("0");
        hostCbsstdreqVo.setChkTlrNbr("000000");
        hostCbsstdreqVo.setBranchTmlNbr("          ");
        hostCbsstdreqVo.setUpldFldNmLen("0000");
        hostCbsstdreqVo.setUpldFldSecVal("        ");
        hostCbsstdreqVo.setAhrInf("");
        hostCbsstdreqVo.setKeyWords("");
        hostCbsstdreqVo.setSgnFld("00000000000000000000000000000000000000000000000000000000000");
        hostCbsstdreqVo.setCnlCd(this.psEsbConfigurationMsg.getAppcd());
        hostCbsstdreqVo.setEqmtTpCd("");
        hostCbsstdreqVo.setPtTxCd("SVS110");
        hostCbsstdreqVo.setPtTxDt(date);
        hostCbsstdreqVo.setPtTxTm(time);
        hostCbsstdreqVo.setPtSeqNbr(seqid);
        hostCbsstdreqVo.setExprTxCd("SVS110");
        hostCbsstdreqVo.setExprDt(date);
        hostCbsstdreqVo.setExprTm(time);
        hostCbsstdreqVo.setExprSeqNbr(seqid);
        hostCbsstdreqVo.setReqIP(CommonUtil.getLinuxLocalIp());
        hostCbsstdreqVo.setTmlNbr("0000000000");
        hostCbsstdreqVo.setSvcPblcCtlrTp("11111");
        hostCbsstdreqVo.setSvcInptCtrlTp("110000");
        SVS110ReqBody svs110ReqBody = new SVS110ReqBody();
        svs110ReqBody.setBrNbr("01101");
        svs110ReqBody.setBtchNbr(brahcNm);
        svs110ReqBody.setFileTp("191");
        svs110ReqBody.setAcctNbr(acctNbr);
        svs110ReqBody.setDivAcctNbr("-00001");
        svs110ReqBody.setCcy("01");
        svs110ReqBody.setCshRmtTp("");
        svs110ReqBody.setLoanTp("");
        svs110ReqBody.setTotCnt("1");
        svs110ReqBody.setTtlAmt("1.00");
        svs110ReqBody.setAbsCd("");
        svs110ReqBody.setAbs("");
        svs110ReqBody.setCtrlTp("1011");
        svs110ReqBody.setSchdDt(date);
        svs110ReqBody.setSchdTm(time);
        svs110ReqBody.setChrgs("0.00");
        svs110ReqBody.setAcctNm("");
        svs110ReqBody.setUpldDataMbrNm(filename);
        svs110ReqBody.setCstmFld("");
        SVS110ReqVo svs110ReqVo = new SVS110ReqVo();
        svs110ReqVo.setMsg(esbReqMsgVo);
        svs110ReqVo.setCBSSTDREQ(hostCbsstdreqVo);
        svs110ReqVo.setRequest(svs110ReqBody);
        BeanMap sender = BeanMap.create((Object)svs110ReqVo);
        reqCommInfo.setSender((Map)sender);
        return reqCommInfo;
    }
}

