/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.pay.position.domain.service;

import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.commons.util.collection.CollectionUtils;
import cn.com.yusys.yusp.commons.util.date.DateUtils;
import cn.com.yusys.yusp.pay.position.domain.repo.PsSSysautobakRepo;
import cn.com.yusys.yusp.pay.position.domain.vo.PsSSysautobakVo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.ibatis.jdbc.SQL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PsSSysautobakDomainService {
    private static final Logger log = LoggerFactory.getLogger(PsSSysautobakDomainService.class);
    @Autowired
    private PsSSysautobakRepo psSSysautobakRepo;

    public void TaskExecution() {
        log.info(String.format("%s \u5f00\u59cb\u6267\u884cPS10401\u6570\u636e\u6e05\u7406\u5b9a\u65f6\u4efb\u52a1", DateUtils.getCurrDateTimeStr()));
        List<PsSSysautobakVo> psSSysautobakVos = this.psSSysautobakRepo.getall();
        log.info("\u5f85\u6267\u884c\u6e05\u7406\u8868\uff1a" + psSSysautobakVos.size());
        if (CollectionUtils.isEmpty(psSSysautobakVos)) {
            log.info("\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u7ed3\u675f");
            return;
        }
        try {
            for (PsSSysautobakVo vo : psSSysautobakVos) {
                boolean vili = this.validateRequestDto(vo);
                if (!vili) continue;
                String whString = DateUtils.formatDate((Date)DateUtils.getYesterday((Date)DateUtils.getCurrDate(), (String)vo.getDatasaveday()), (String)"yyyyMMdd");
                int totalNum = this.psSSysautobakRepo.getTotalDataPro(vo.getNowtable(), vo.getCondrow(), whString);
                List<Map<String, String>> dataDetail = null;
                log.info(String.format("%s\u8868\u9700\u5904\u7406\u6570\u636e%s-\u5904\u7406\u7c7b\u578b%s", vo.getNowtable(), totalNum, "0".equals(vo.getBakstyle()) ? "\u5220\u9664" : "\u5907\u4efd"));
                if (totalNum <= 0) continue;
                if (NumberUtils.compare((double)totalNum, (double)Double.parseDouble(vo.getDealcnt())) == 1) {
                    dataDetail = this.psSSysautobakRepo.getDataDetali(vo.getNowtable(), vo.getCondrow(), whString, vo.getPkcolumn());
                }
                Map<String, List<String>> bakDeleteSql = this.getBakDeleteSql(vo.getBakstyle(), vo.getNowtable(), vo.getHistable(), vo.getCondrow(), whString, Integer.parseInt(vo.getDealcnt()), totalNum, dataDetail);
                this.psSSysautobakRepo.execSql(bakDeleteSql.get("deleteSql"), bakDeleteSql.get("bakSql"), vo);
                log.info("\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u7ed3\u675f");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        log.info("\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u7ed3\u675f");
    }

    private boolean validateRequestDto(PsSSysautobakVo vo) {
        if (StringUtils.isBlank((CharSequence)vo.getDealcnt())) {
            log.info("\u6bcf\u7b14\u5904\u7406\u7b14\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            return false;
        }
        if ("1".equals(vo.getBakstyle()) && StringUtils.isBlank((CharSequence)vo.getHistable())) {
            log.info("\u6e05\u7406\u7b56\u7565\u4e3a\u5220\u9664\u65f6\u5386\u53f2\u8868\u4e0d\u80fd\u4e3a\u7a7a");
            return false;
        }
        return true;
    }

    private Map<String, List<String>> getBakDeleteSql(String bakstyle, final String nowtable, final String histable, final String condrow, final String whString, int dealcnt, int totalNum, List<Map<String, String>> dataDetail) {
        ArrayList<String> bakLlist = new ArrayList<String>(13);
        List<Object> deleteList = new ArrayList(13);
        if (NumberUtils.compare((float)totalNum, (float)dealcnt) == 1) {
            Map<String, List<String>> listMap = this.dataCoverListToMap(dataDetail);
            int num = this.partValue(totalNum, dealcnt);
            for (int i = 0; i < num; ++i) {
                Iterator<String> iter = listMap.keySet().iterator();
                final StringBuffer stringBuffer = new StringBuffer();
                while (iter.hasNext()) {
                    String key = String.valueOf(iter.next());
                    int begin = i * dealcnt;
                    int end = i == num - 1 ? totalNum : i * dealcnt + dealcnt;
                    List<String> value = listMap.get(key).subList(begin, end);
                    String sqlIn = this.listCoverSqlIn(value);
                    stringBuffer.append(key).append(" in ").append(sqlIn);
                    if (!iter.hasNext()) continue;
                    stringBuffer.append(" and ");
                }
                String sql = new SQL(){
                    {
                        this.DELETE_FROM(nowtable);
                        this.WHERE(stringBuffer.toString());
                    }
                }.toString();
                deleteList.add(sql);
                if (!"1".equals(bakstyle)) continue;
                String bak = new SQL(){
                    {
                        this.INSERT_INTO(histable);
                    }
                }.toString();
                String sel = new SQL(){
                    {
                        this.SELECT("*");
                        this.FROM(nowtable);
                        this.WHERE(stringBuffer.toString());
                    }
                }.toString();
                bakLlist.add(bak.concat(" ").concat(sel));
            }
        } else {
            String sql = new SQL(){
                {
                    this.DELETE_FROM(nowtable);
                    this.WHERE(condrow + "< " + whString);
                }
            }.toString();
            deleteList = Arrays.asList(sql);
            if ("1".equals(bakstyle)) {
                String bak = new SQL(){
                    {
                        this.INSERT_INTO(histable);
                    }
                }.toString();
                String sel = new SQL(){
                    {
                        this.SELECT("*");
                        this.FROM(nowtable);
                        this.WHERE(condrow + "< " + whString);
                    }
                }.toString();
                bakLlist.add(bak.concat(" ").concat(sel));
            }
        }
        HashMap<String, List<String>> stringListMap = new HashMap<String, List<String>>(2);
        stringListMap.put("deleteSql", deleteList);
        stringListMap.put("bakSql", bakLlist);
        return stringListMap;
    }

    private Map<String, List<String>> dataCoverListToMap(List<Map<String, String>> dataDetail) {
        HashMap<String, List<String>> listMap = new HashMap<String, List<String>>(13);
        for (int i = 0; i < dataDetail.size(); ++i) {
            String value;
            String key;
            Iterator<String> iter;
            Map<String, String> map = dataDetail.get(i);
            if (i == 0) {
                iter = map.keySet().iterator();
                while (iter.hasNext()) {
                    key = String.valueOf(iter.next());
                    value = map.get(key);
                    ArrayList<String> stringList = new ArrayList<String>(){
                        {
                            this.add(value);
                        }
                    };
                    listMap.put(key, (List<String>)stringList);
                }
                continue;
            }
            iter = map.keySet().iterator();
            while (iter.hasNext()) {
                key = String.valueOf(iter.next());
                value = map.get(key);
                List list1 = (List)listMap.get(key);
                list1.add(value);
                listMap.put(key, list1);
            }
        }
        return listMap;
    }

    private int partValue(int total, int partCount) {
        int partValue = total / partCount;
        if (total % partCount > 0) {
            ++partValue;
        }
        return partValue;
    }

    private String listCoverSqlIn(List<String> value) {
        StringBuilder idsStr = new StringBuilder();
        idsStr.append("(");
        for (int i = 0; i < value.size(); ++i) {
            if (i > 0) {
                idsStr.append(",");
            }
            idsStr.append("'").append(value.get(i)).append("'");
        }
        idsStr.append(")");
        return idsStr.toString();
    }
}

