/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.pay.position.domain.service;

import cn.com.yusys.yusp.commons.sequence.util.SequenceUtils;
import cn.com.yusys.yusp.commons.util.NumberUtils;
import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.commons.util.collection.CollectionUtils;
import cn.com.yusys.yusp.pay.position.domain.repo.PsDCorpaccbookRepo;
import cn.com.yusys.yusp.pay.position.domain.repo.PsDIndicatorruleRepo;
import cn.com.yusys.yusp.pay.position.domain.repo.PsMCorpwarnjnlRepo;
import cn.com.yusys.yusp.pay.position.domain.service.PsSMSDomainService;
import cn.com.yusys.yusp.pay.position.domain.util.PSDateUtil;
import cn.com.yusys.yusp.pay.position.domain.vo.PsDCorpaccbookVo;
import cn.com.yusys.yusp.pay.position.domain.vo.PsDIndicatorruleVo;
import cn.com.yusys.yusp.pay.position.domain.vo.PsMCorpwarnjnlVo;
import cn.com.yusys.yusp.pay.position.domain.vo.PsMPostcaljnlVo;
import cn.com.yusys.yusp.pay.position.domain.vo.service.CorpWarnJnlFormVo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PsCorpWarnJnlDomainService {
    private static final Logger log = LoggerFactory.getLogger(PsCorpWarnJnlDomainService.class);
    @Autowired
    private PsDIndicatorruleRepo psDIndicatorruleRepo;
    @Autowired
    private PsMCorpwarnjnlRepo psMCorpwarnjnlRepo;
    @Autowired
    private PsDCorpaccbookRepo psDCorpaccbookRepo;
    @Autowired
    private PsSMSDomainService smsService;

    public void invokeCorpWarnJnlHandlerWithSynAmt(CorpWarnJnlFormVo corpWarnJnlFormVo) {
        String brNo = corpWarnJnlFormVo.getBrNo();
        String postType = corpWarnJnlFormVo.getPostType();
        String postAccNo = corpWarnJnlFormVo.getPostAccNo();
        String balAmt = corpWarnJnlFormVo.getBalAmt();
        log.info("\u6536\u5230\u7b2c\u4e09\u65b9\u5934\u5bf8\u4f59\u989d\u6700\u65b0\u901a\u77e5,postAccNo=" + postAccNo);
        this.corpWarnJnlHandler(brNo, postAccNo, balAmt, "02");
    }

    public void invokeCorpWarnJnlHandlerWithCalculate(PsMPostcaljnlVo psMPostcaljnlVo) {
        String brNo = psMPostcaljnlVo.getBrno();
        String postAccNo = psMPostcaljnlVo.getPostaccno();
        String balAmt = NumberUtils.nullDefaultZero((Number)psMPostcaljnlVo.getPostbal()).toString();
        log.info("\u6536\u5230\u5934\u5bf8\u5321\u7b97\u6700\u65b0\u901a\u77e5,postAccNo=" + postAccNo);
        this.corpWarnJnlHandler(brNo, postAccNo, balAmt, "01");
    }

    private void corpWarnJnlHandler(String brNo, String postAccNo, String balAmt, String warnType) {
        HashMap<String, String> map;
        String workSeqId;
        PsMCorpwarnjnlVo corpwarnjnlVo;
        BigDecimal amt = new BigDecimal(balAmt);
        String postName = "";
        String postType = "";
        PsDCorpaccbookVo psDCorpaccbookVo = this.psDCorpaccbookRepo.getCorpaccbookInfoByBrNoAndPostAccNo(brNo, postAccNo);
        if (CollectionUtils.nonNull((Object)((Object)psDCorpaccbookVo))) {
            postName = psDCorpaccbookVo.getPosname();
            postType = psDCorpaccbookVo.getPostype();
        }
        BigDecimal limitAmt = new BigDecimal("0");
        boolean isMonitorLimit = false;
        boolean isAlarmLimit = false;
        String limitMsgCode = "";
        String limitMsgReceiverGroupCode = "";
        BigDecimal warnAmt = new BigDecimal("0");
        boolean isMonitorWarn = false;
        boolean isAlarmWarn = false;
        String warnMsgCode = "";
        String warnMsgReceiverGroupCode = "";
        ArrayList<String> codeList = new ArrayList<String>();
        codeList.add("04003");
        codeList.add("04004");
        List<PsDIndicatorruleVo> indicatorruleVoList = this.psDIndicatorruleRepo.getIndicatorRuleInfo(postAccNo, codeList);
        if (CollectionUtils.isEmpty(indicatorruleVoList)) {
            log.info(postAccNo + "\u672a\u914d\u7f6e\u6307\u6807\u9650\u989d,\u5ffd\u7565\u901a\u77e5");
            return;
        }
        for (PsDIndicatorruleVo vo : indicatorruleVoList) {
            if ("04003".equals(vo.getIndicatorcode())) {
                limitAmt = vo.getIndicatorval();
                if ("1".equals(vo.getMonitorflag())) {
                    isMonitorLimit = true;
                }
                if ("1".equals(vo.getAlarmflag())) {
                    isAlarmLimit = true;
                }
                limitMsgCode = vo.getMsgcode();
                limitMsgReceiverGroupCode = vo.getMsggroupcode();
            }
            if (!"04004".equals(vo.getIndicatorcode())) continue;
            warnAmt = vo.getIndicatorval();
            if ("1".equals(vo.getMonitorflag())) {
                isMonitorWarn = true;
            }
            if ("1".equals(vo.getAlarmflag())) {
                isAlarmWarn = true;
            }
            warnMsgCode = vo.getMsgcode();
            warnMsgReceiverGroupCode = vo.getMsggroupcode();
        }
        if (isMonitorLimit && amt.compareTo(limitAmt) == 1) {
            log.info("\u8d85\u8fc7\u7b2c\u4e09\u65b9\u8d85\u9650\u91d1\u989d,\u4e0b\u9762\u9884\u8b66\u4fe1\u606f\u5165\u5e93");
            corpwarnjnlVo = new PsMCorpwarnjnlVo();
            workSeqId = SequenceUtils.getSequence((String)"corpwarnjnlworkseqid");
            corpwarnjnlVo.setAppid("PS");
            corpwarnjnlVo.setLimitamt(limitAmt);
            corpwarnjnlVo.setPostaccno(postAccNo);
            corpwarnjnlVo.setPostbal(amt);
            corpwarnjnlVo.setPostname(postName);
            corpwarnjnlVo.setPosttype(postType);
            corpwarnjnlVo.setSysid("PS");
            corpwarnjnlVo.setWarnamt(warnAmt);
            corpwarnjnlVo.setWarntype(warnType);
            corpwarnjnlVo.setWorkdate(PSDateUtil.getCurrentDate());
            corpwarnjnlVo.setWorkseqid(workSeqId);
            corpwarnjnlVo.setWorktime(PSDateUtil.getCurrentTime());
            this.psMCorpwarnjnlRepo.save(corpwarnjnlVo);
            if (isAlarmLimit && StringUtils.nonBlank((CharSequence)limitMsgCode) && StringUtils.nonBlank((CharSequence)limitMsgReceiverGroupCode)) {
                log.info("\u8d85\u8fc7\u7b2c\u4e09\u65b9\u8d85\u9650\u91d1\u989d,\u4e0b\u9762\u9884\u8b66\u4fe1\u606f\u53d1\u77ed\u4fe1");
                map = new HashMap<String, String>();
                this.smsService.sendSmsByGroup(limitMsgCode, map, limitMsgReceiverGroupCode);
            }
        }
        if (isMonitorWarn && amt.compareTo(warnAmt) == -1) {
            log.info("\u4f4e\u4e8e\u7b2c\u4e09\u65b9\u9884\u8b66\u91d1\u989d,\u4e0b\u9762\u9884\u8b66\u4fe1\u606f\u5165\u5e93");
            corpwarnjnlVo = new PsMCorpwarnjnlVo();
            workSeqId = SequenceUtils.getSequence((String)"corpwarnjnlworkseqid");
            corpwarnjnlVo.setAppid("PS");
            corpwarnjnlVo.setLimitamt(limitAmt);
            corpwarnjnlVo.setPostaccno(postAccNo);
            corpwarnjnlVo.setPostbal(amt);
            corpwarnjnlVo.setPostname(postName);
            corpwarnjnlVo.setPosttype(postType);
            corpwarnjnlVo.setSysid("PS");
            corpwarnjnlVo.setWarnamt(warnAmt);
            corpwarnjnlVo.setWarntype(warnType);
            corpwarnjnlVo.setWorkdate(PSDateUtil.getCurrentDate());
            corpwarnjnlVo.setWorkseqid(workSeqId);
            corpwarnjnlVo.setWorktime(PSDateUtil.getCurrentTime());
            this.psMCorpwarnjnlRepo.save(corpwarnjnlVo);
            if (isAlarmWarn && StringUtils.nonBlank((CharSequence)warnMsgCode) && StringUtils.nonBlank((CharSequence)warnMsgReceiverGroupCode)) {
                log.info("\u4f4e\u4e8e\u7b2c\u4e09\u65b9\u9884\u8b66\u91d1\u989d,\u4e0b\u9762\u9884\u8b66\u4fe1\u606f\u53d1\u77ed\u4fe1");
                map = new HashMap();
                this.smsService.sendSmsByGroup(warnMsgCode, map, warnMsgReceiverGroupCode);
            }
        }
    }
}

