/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.pay.position.domain.service;

import cn.com.yusys.yusp.commons.sequence.util.SequenceUtils;
import cn.com.yusys.yusp.commons.util.NumberUtils;
import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.commons.util.collection.CollectionUtils;
import cn.com.yusys.yusp.pay.position.domain.repo.PsDBranchadmRepo;
import cn.com.yusys.yusp.pay.position.domain.repo.PsDIndicatorruleRepo;
import cn.com.yusys.yusp.pay.position.domain.repo.PsMBankwarnjnlRepo;
import cn.com.yusys.yusp.pay.position.domain.service.PsSMSDomainService;
import cn.com.yusys.yusp.pay.position.domain.util.PSDateUtil;
import cn.com.yusys.yusp.pay.position.domain.vo.PsDBranchadmVo;
import cn.com.yusys.yusp.pay.position.domain.vo.PsDIndicatorruleVo;
import cn.com.yusys.yusp.pay.position.domain.vo.PsMBankwarnjnlVo;
import cn.com.yusys.yusp.pay.position.domain.vo.service.BankWarnJnlFormVo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PsBankWarnJnlDomainService {
    private static final Logger log = LoggerFactory.getLogger(PsBankWarnJnlDomainService.class);
    @Autowired
    private PsDIndicatorruleRepo psDIndicatorruleRepo;
    @Autowired
    private PsMBankwarnjnlRepo psMBankwarnjnlRepo;
    @Autowired
    private PsDBranchadmRepo psDBranchadmRepo;
    @Autowired
    private PsSMSDomainService smsService;

    public void invokeBankWarnJnlHandler(BankWarnJnlFormVo bankWarnJnlFormVo) {
        HashMap<String, String> map;
        String workSeqId;
        PsMBankwarnjnlVo bankwarnjnlVo;
        String brNo = bankWarnJnlFormVo.getBrNo();
        String balAmt = bankWarnJnlFormVo.getBalAmt();
        BigDecimal amt = NumberUtils.toBigDecimal((Object)balAmt);
        log.info("\u6536\u5230\u6838\u5fc3\u5934\u5bf8\u4f59\u989d\u6700\u65b0\u901a\u77e5,brNo=" + brNo);
        String brName = "";
        PsDBranchadmVo psDBranchadmVo = this.psDBranchadmRepo.getBranchInfoByBrNo(brNo);
        if (CollectionUtils.nonNull((Object)psDBranchadmVo)) {
            brName = psDBranchadmVo.getBrname();
        }
        BigDecimal limitAmt = new BigDecimal("0");
        boolean isMonitorLimit = false;
        boolean isAlarmLimit = false;
        String limitMsgCode = "";
        String limitMsgReceiverGroupCode = "";
        BigDecimal warnAmt = new BigDecimal("0");
        boolean isMonitorWarn = false;
        boolean isAlarmWarn = false;
        String warnMsgCode = "";
        String warnMsgReceiverGroupCode = "";
        ArrayList<String> codeList = new ArrayList<String>();
        codeList.add("04001");
        codeList.add("04002");
        List<PsDIndicatorruleVo> indicatorruleVoList = this.psDIndicatorruleRepo.getIndicatorRuleInfo(brNo, codeList);
        if (CollectionUtils.isEmpty(indicatorruleVoList)) {
            log.info(brNo + "\u672a\u914d\u7f6e\u6307\u6807\u9650\u989d,\u5ffd\u7565\u901a\u77e5");
            return;
        }
        for (PsDIndicatorruleVo vo : indicatorruleVoList) {
            if ("04001".equals(vo.getIndicatorcode())) {
                limitAmt = vo.getIndicatorval();
                if ("1".equals(vo.getMonitorflag())) {
                    isMonitorLimit = true;
                }
                if ("1".equals(vo.getAlarmflag())) {
                    isAlarmLimit = true;
                }
                limitMsgCode = vo.getMsgcode();
                limitMsgReceiverGroupCode = vo.getMsggroupcode();
            }
            if (!"04002".equals(vo.getIndicatorcode())) continue;
            warnAmt = vo.getIndicatorval();
            if ("1".equals(vo.getMonitorflag())) {
                isMonitorWarn = true;
            }
            if ("1".equals(vo.getAlarmflag())) {
                isAlarmWarn = true;
            }
            warnMsgCode = vo.getMsgcode();
            warnMsgReceiverGroupCode = vo.getMsggroupcode();
        }
        if (isMonitorLimit && amt.compareTo(limitAmt) == 1) {
            log.info("\u8d85\u8fc7\u884c\u5185\u8d85\u9650\u91d1\u989d,\u4e0b\u9762\u9884\u8b66\u4fe1\u606f\u5165\u5e93");
            bankwarnjnlVo = new PsMBankwarnjnlVo();
            workSeqId = SequenceUtils.getSequence((String)"bankwarnjnlworkseqid");
            bankwarnjnlVo.setAppid("PS");
            bankwarnjnlVo.setClearbrname(brName);
            bankwarnjnlVo.setClearbrno(brNo);
            bankwarnjnlVo.setLimitamt(limitAmt);
            bankwarnjnlVo.setPostbal(amt);
            bankwarnjnlVo.setSysid("PS");
            bankwarnjnlVo.setWarnamt(warnAmt);
            bankwarnjnlVo.setWorkdate(PSDateUtil.getCurrentDate());
            bankwarnjnlVo.setWorkseqid(workSeqId);
            bankwarnjnlVo.setWorktime(PSDateUtil.getCurrentTime());
            this.psMBankwarnjnlRepo.save(bankwarnjnlVo);
            if (isAlarmLimit && StringUtils.nonBlank((CharSequence)limitMsgCode) && StringUtils.nonBlank((CharSequence)limitMsgReceiverGroupCode)) {
                log.info("\u8d85\u8fc7\u884c\u5185\u8d85\u9650\u91d1\u989d,\u4e0b\u9762\u9884\u8b66\u4fe1\u606f\u53d1\u77ed\u4fe1");
                map = new HashMap<String, String>();
                this.smsService.sendSmsByGroup(limitMsgCode, map, limitMsgReceiverGroupCode);
            }
        }
        if (isMonitorWarn && amt.compareTo(warnAmt) == -1) {
            log.info("\u4f4e\u4e8e\u884c\u5185\u9884\u8b66\u91d1\u989d,\u4e0b\u9762\u9884\u8b66\u4fe1\u606f\u5165\u5e93");
            bankwarnjnlVo = new PsMBankwarnjnlVo();
            workSeqId = SequenceUtils.getSequence((String)"bankwarnjnlworkseqid");
            bankwarnjnlVo.setAppid("PS");
            bankwarnjnlVo.setClearbrname(brName);
            bankwarnjnlVo.setClearbrno(brNo);
            bankwarnjnlVo.setLimitamt(limitAmt);
            bankwarnjnlVo.setPostbal(amt);
            bankwarnjnlVo.setSysid("PS");
            bankwarnjnlVo.setWarnamt(warnAmt);
            bankwarnjnlVo.setWorkdate(PSDateUtil.getCurrentDate());
            bankwarnjnlVo.setWorkseqid(workSeqId);
            bankwarnjnlVo.setWorktime(PSDateUtil.getCurrentTime());
            this.psMBankwarnjnlRepo.save(bankwarnjnlVo);
            if (isAlarmWarn && StringUtils.nonBlank((CharSequence)warnMsgCode) && StringUtils.nonBlank((CharSequence)warnMsgReceiverGroupCode)) {
                log.info("\u4f4e\u4e8e\u884c\u5185\u9884\u8b66\u91d1\u989d,\u4e0b\u9762\u9884\u8b66\u4fe1\u606f\u53d1\u77ed\u4fe1");
                map = new HashMap();
                this.smsService.sendSmsByGroup(warnMsgCode, map, warnMsgReceiverGroupCode);
            }
        }
    }
}

