/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.pay.position.domain.service;

import cn.com.yusys.yusp.commons.sequence.util.SequenceUtils;
import cn.com.yusys.yusp.commons.util.date.DateFormatEnum;
import cn.com.yusys.yusp.commons.util.date.DateUtils;
import cn.com.yusys.yusp.pay.position.domain.util.CommonUtil;
import cn.com.yusys.yusp.pay.position.domain.util.PSEsbConfigurationMsg;
import cn.com.yusys.yusp.pay.position.domain.vo.esb.EsbReqMsgVo;
import cn.com.yusys.yusp.pay.position.domain.vo.esb.HostCbsstdReqVo;
import cn.com.yusys.yusp.pay.position.domain.vo.esb.UPS003ReqBody;
import cn.com.yusys.yusp.pay.position.domain.vo.esb.UPS003ReqVo;
import cn.com.yusys.yusp.payment.common.base.dto.ReqCommInfo;
import com.alibaba.fastjson.JSON;
import java.net.UnknownHostException;
import java.util.Map;
import net.sf.cglib.beans.BeanMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
public class UPS003DomainService {
    private static final Logger log = LoggerFactory.getLogger(UPS003DomainService.class);
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private PSEsbConfigurationMsg psEsbConfigurationMsg;

    public ResponseEntity<String> ups003(String postaccno) throws UnknownHostException {
        ReqCommInfo reqCommInfo = this.createHostReqCommInfo(postaccno);
        log.info(String.format("UPS003\u751f\u6210\u62a5\u6587\u6210\u529f%s", JSON.toJSONString((Object)reqCommInfo)));
        String url = this.psEsbConfigurationMsg.getUrl();
        log.info(String.format("UPS003\u53d1\u8d77\u8bf7\u6c42\uff1a\u8bf7\u6c42\u8def\u5f84%s ", url));
        ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)reqCommInfo, String.class, new Object[0]);
        log.info(String.format("UPS003\u5e94\u7b54\u62a5\u6587%s ", JSON.toJSONString((Object)responseEntity)));
        return responseEntity;
    }

    private ReqCommInfo createHostReqCommInfo(String postaccno) throws UnknownHostException {
        log.info("UPS003\u751f\u6210\u62a5\u6587\u5f00\u59cb---");
        ReqCommInfo reqCommInfo = new ReqCommInfo();
        reqCommInfo.setSysid("FXPS");
        reqCommInfo.setAppid("FXPS");
        reqCommInfo.setHostcommid("FXPS");
        log.info(String.format("UPS003\u5185\u8054\u8bf7\u6c42\u516c\u5171\u4fe1\u606f---", reqCommInfo.toString()));
        EsbReqMsgVo esbReqMsgVo = new EsbReqMsgVo();
        esbReqMsgVo.setMsgCd("CBS.00UPS0030.01");
        esbReqMsgVo.setSeqNb(SequenceUtils.getSequence((String)"esbseqid"));
        log.info(String.format("seqNb\uff1a%s", esbReqMsgVo.getSeqNb()));
        esbReqMsgVo.setSndAppCd(this.psEsbConfigurationMsg.getAppcd());
        esbReqMsgVo.setSndDt(DateUtils.getCurrentDate((DateFormatEnum)DateFormatEnum.DATE_COMPACT));
        esbReqMsgVo.setSndTm(DateUtils.getCurrentDate((DateFormatEnum)DateFormatEnum.TIME_COMPACT));
        esbReqMsgVo.setCallTyp("SYN");
        esbReqMsgVo.setRcvAppCd("CBS");
        HostCbsstdReqVo hostCbsstdreqVo = new HostCbsstdReqVo();
        String time = DateUtils.getCurrentDate((DateFormatEnum)DateFormatEnum.TIME).replace(':', '.');
        String date = DateUtils.getCurrentDate((DateFormatEnum)DateFormatEnum.DEFAULT);
        String seqid = SequenceUtils.getSequence((String)"hostseqid");
        log.info(String.format("hostseqid\uff1a%s", seqid));
        hostCbsstdreqVo.setInfTp("RQ");
        hostCbsstdreqVo.setSvcCd("CB1015");
        hostCbsstdreqVo.setBsnTxDt(date);
        hostCbsstdreqVo.setSysDt(date);
        hostCbsstdreqVo.setSysTm(time);
        hostCbsstdreqVo.setBrNbr("01101");
        hostCbsstdreqVo.setSecFlg("");
        hostCbsstdreqVo.setTlrNbr("888888");
        hostCbsstdreqVo.setTxFlg("0");
        hostCbsstdreqVo.setTxSeqNbr(seqid);
        hostCbsstdreqVo.setAuthInfFlg("0");
        hostCbsstdreqVo.setInptWordFlg("0");
        hostCbsstdreqVo.setSignInfFlg("0");
        hostCbsstdreqVo.setRmtAhrAplFlg("0");
        hostCbsstdreqVo.setChkTlrNbr("");
        hostCbsstdreqVo.setBranchTmlNbr("");
        hostCbsstdreqVo.setUpldFldNmLen("0000");
        hostCbsstdreqVo.setUpldFldSecVal("");
        hostCbsstdreqVo.setSgnFld("000000000000000000000000");
        hostCbsstdreqVo.setCnlCd(this.psEsbConfigurationMsg.getAppcd());
        hostCbsstdreqVo.setEqmtTpCd("01");
        hostCbsstdreqVo.setPtTxCd("");
        hostCbsstdreqVo.setPtTxDt(date);
        hostCbsstdreqVo.setPtTxTm(time);
        hostCbsstdreqVo.setPtSeqNbr(seqid);
        hostCbsstdreqVo.setExprTxCd("");
        hostCbsstdreqVo.setExprDt(date);
        hostCbsstdreqVo.setExprTm(time);
        hostCbsstdreqVo.setExprSeqNbr(seqid);
        hostCbsstdreqVo.setReqIP(CommonUtil.getLinuxLocalIp());
        hostCbsstdreqVo.setTmlNbr("0000000000");
        hostCbsstdreqVo.setSvcInptCtrlTp("00000000000000000000");
        UPS003ReqBody ups003ReqBody = new UPS003ReqBody();
        ups003ReqBody.setAcctNbr(postaccno);
        UPS003ReqVo ups003ReqVo = new UPS003ReqVo();
        ups003ReqVo.setMsg(esbReqMsgVo);
        ups003ReqVo.setCBSSTDREQ(hostCbsstdreqVo);
        ups003ReqVo.setRequest(ups003ReqBody);
        BeanMap sender = BeanMap.create((Object)ups003ReqVo);
        reqCommInfo.setSender((Map)sender);
        return reqCommInfo;
    }
}

