/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.pay.position.application.service;

import cn.com.yusys.yusp.commons.sequence.util.SequenceUtils;
import cn.com.yusys.yusp.commons.util.BeanUtils;
import cn.com.yusys.yusp.commons.util.date.DateUtils;
import cn.com.yusys.yusp.pay.position.application.dto.ps11001.Ps11001ReqDto;
import cn.com.yusys.yusp.pay.position.application.dto.ps11001.Ps11001RspDto;
import cn.com.yusys.yusp.pay.position.application.dto.ps11001.Ps11001RspListDto;
import cn.com.yusys.yusp.pay.position.domain.repo.PsBFundallocationjnlRepo;
import cn.com.yusys.yusp.pay.position.domain.repo.PsDBranchadmRepo;
import cn.com.yusys.yusp.pay.position.domain.service.PsDBranchadmDomainService;
import cn.com.yusys.yusp.pay.position.domain.util.PSErrorMsg;
import cn.com.yusys.yusp.pay.position.domain.vo.PsBFundallocationjnlVo;
import cn.com.yusys.yusp.pay.position.domain.vo.PsDBranchadmVo;
import cn.com.yusys.yusp.payment.common.base.dto.YuinRequestDto;
import cn.com.yusys.yusp.payment.common.base.dto.YuinRequestHead;
import cn.com.yusys.yusp.payment.common.base.dto.YuinResultDto;
import cn.com.yusys.yusp.payment.common.base.dto.YuinResultHead;
import com.baomidou.mybatisplus.core.metadata.IPage;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PS11001Service {
    private static final Logger log = LoggerFactory.getLogger(PS11001Service.class);
    @Autowired
    private PsDBranchadmRepo psDBranchadmRepo;
    @Autowired
    private PsBFundallocationjnlRepo psBFundallocationjnlRepo;
    @Autowired
    private PsDBranchadmDomainService psDBranchadmDomainService;

    public YuinResultDto<Ps11001RspDto> ps11001(YuinRequestDto<Ps11001ReqDto> yuinRequestDto) {
        YuinRequestDto request = new YuinRequestDto();
        request.setSysHead(yuinRequestDto.getSysHead());
        Ps11001ReqDto ps11001ReqDto = (Ps11001ReqDto)yuinRequestDto.getBody();
        request.setBody(BeanUtils.beanCopy((Object)yuinRequestDto.getBody(), PsBFundallocationjnlVo.class));
        YuinResultDto yuinResultDto = new YuinResultDto();
        YuinResultHead resultHead = new YuinResultHead();
        resultHead.setResponseCode("200");
        resultHead.setResponseMsg("\u901a\u8baf\u6210\u529f");
        yuinResultDto.setHead(resultHead);
        Optional<Object> optional = Optional.ofNullable(request.getBody());
        PsBFundallocationjnlVo psBFundallocationjnlVo = (PsBFundallocationjnlVo)optional.get();
        psBFundallocationjnlVo.setPage(Long.valueOf(request.getSysHead().getPageNum().intValue()));
        psBFundallocationjnlVo.setSize(Long.valueOf(request.getSysHead().getPageSize().intValue()));
        psBFundallocationjnlVo.setAppid(request.getSysHead().getAppid());
        psBFundallocationjnlVo.setSysid(request.getSysHead().getSysid());
        try {
            switch (StringUtils.isBlank((CharSequence)psBFundallocationjnlVo.getFuncType()) ? "9999" : psBFundallocationjnlVo.getFuncType()) {
                case "1": {
                    yuinResultDto.setBody((Object)this.doInsert(psBFundallocationjnlVo, request.getSysHead()));
                    break;
                }
                case "2": {
                    yuinResultDto.setBody((Object)this.doUpdate(psBFundallocationjnlVo, request.getSysHead()));
                    break;
                }
                case "3": {
                    yuinResultDto.setBody((Object)this.doDelete(psBFundallocationjnlVo));
                    break;
                }
                case "4": {
                    yuinResultDto.setBody((Object)this.doQuery(psBFundallocationjnlVo, resultHead, ps11001ReqDto, request.getSysHead()));
                    break;
                }
                default: {
                    yuinResultDto.setBody((Object)new Ps11001RspDto("0", PSErrorMsg.PS000002.getErrCode(), PSErrorMsg.PS000002.getErrMsg()));
                    break;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info(e.toString());
            yuinResultDto.setBody((Object)new Ps11001RspDto("0", PSErrorMsg.PS000001.getErrCode(), PSErrorMsg.PS000001.getErrMsg()));
        }
        return yuinResultDto;
    }

    private Ps11001RspDto doQuery(PsBFundallocationjnlVo psBFundallocationjnlVo, YuinResultHead resultHead, Ps11001ReqDto ps11001ReqDto, YuinRequestHead requestHead) {
        boolean isSuperBrno;
        String fatherBrno = requestHead.getBrno();
        String qryBrno = ps11001ReqDto.getBrNo();
        if (StringUtils.isNotBlank((CharSequence)qryBrno) && !(isSuperBrno = this.psDBranchadmDomainService.juageSuperBrno(fatherBrno, qryBrno).booleanValue())) {
            return new Ps11001RspDto("0", PSErrorMsg.PS000007.getErrCode(), PSErrorMsg.PS000007.getErrMsg() + "\u8f93\u5165\u7684\u673a\u6784\u53f7\u5fc5\u987b\u4e3a\u8f96\u5185\u673a\u6784");
        }
        ArrayList<String> orgTypeList = new ArrayList<String>();
        orgTypeList.add(ps11001ReqDto.getBranchType());
        ArrayList<String> brnoList = new ArrayList<String>();
        brnoList.add(qryBrno);
        List brnoBranchList = this.psDBranchadmRepo.getOrgInfoByOrgZoneBrno(orgTypeList, null, brnoList);
        ArrayList<String> queryBrnoList = new ArrayList<String>();
        for (PsDBranchadmVo vo2 : brnoBranchList) {
            queryBrnoList.add(vo2.getBrno());
        }
        psBFundallocationjnlVo.setQueryBrnoList(queryBrnoList);
        IPage rspDtoIPage = this.psBFundallocationjnlRepo.doQuery(psBFundallocationjnlVo).convert(vo -> (Ps11001RspListDto)BeanUtils.beanCopy((Object)vo, Ps11001RspListDto.class));
        resultHead.setTotalSize(rspDtoIPage.getTotal());
        Ps11001RspDto ps11001RspDto = new Ps11001RspDto("1", "", "");
        ps11001RspDto.setList(rspDtoIPage.getRecords());
        return ps11001RspDto;
    }

    private Ps11001RspDto doDelete(PsBFundallocationjnlVo psBFundallocationjnlVo) {
        if (StringUtils.isBlank((CharSequence)psBFundallocationjnlVo.getWorkdate())) {
            return new Ps11001RspDto("0", PSErrorMsg.PS000002.getErrCode(), PSErrorMsg.PS000004.getErrMsg() + "\u8bf7\u68c0\u67e5\u53c2\u6570\u4e0d\u53ef\u7f3a\u5c11\u5220\u9664\u4e3b\u952e:workdate-\u5e73\u53f0\u65e5\u671f");
        }
        if (StringUtils.isBlank((CharSequence)psBFundallocationjnlVo.getWorkseqid())) {
            return new Ps11001RspDto("0", PSErrorMsg.PS000002.getErrCode(), PSErrorMsg.PS000004.getErrMsg() + "\u8bf7\u68c0\u67e5\u53c2\u6570\u4e0d\u53ef\u7f3a\u5c11\u5220\u9664\u4e3b\u952e:workseqid-\u5e73\u53f0\u6d41\u6c34");
        }
        this.psBFundallocationjnlRepo.doDelete(psBFundallocationjnlVo);
        return new Ps11001RspDto("1", "", "");
    }

    private Ps11001RspDto doUpdate(PsBFundallocationjnlVo psBFundallocationjnlVo, YuinRequestHead requestHead) {
        if (StringUtils.isBlank((CharSequence)psBFundallocationjnlVo.getWorkdate())) {
            return new Ps11001RspDto("0", PSErrorMsg.PS000002.getErrCode(), PSErrorMsg.PS000004.getErrMsg() + "\u8bf7\u68c0\u67e5\u53c2\u6570\u4e0d\u53ef\u7f3a\u5c11\u5220\u9664\u4e3b\u952e:workdate-\u5e73\u53f0\u65e5\u671f");
        }
        if (StringUtils.isBlank((CharSequence)psBFundallocationjnlVo.getWorkseqid())) {
            return new Ps11001RspDto("0", PSErrorMsg.PS000002.getErrCode(), PSErrorMsg.PS000004.getErrMsg() + "\u8bf7\u68c0\u67e5\u53c2\u6570\u4e0d\u53ef\u7f3a\u5c11\u5220\u9664\u4e3b\u952e:workseqid-\u5e73\u53f0\u6d41\u6c34");
        }
        this.psBFundallocationjnlRepo.doUpdate(psBFundallocationjnlVo);
        return new Ps11001RspDto("1", "", "");
    }

    private Ps11001RspDto doInsert(PsBFundallocationjnlVo psBFundallocationjnlVo, YuinRequestHead requestHead) {
        psBFundallocationjnlVo.setBrno(requestHead.getBrno());
        psBFundallocationjnlVo.setTellerno(requestHead.getTellerno());
        psBFundallocationjnlVo.setWorkdate(DateUtils.formatDate((String)DateUtils.PATTERN_DATE_COMPACT));
        psBFundallocationjnlVo.setWorkseqid(SequenceUtils.getSequence((String)"msgid"));
        this.psBFundallocationjnlRepo.doInsert(psBFundallocationjnlVo);
        return new Ps11001RspDto("1", "", "");
    }
}

