/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.pay.position.application.service;

import cn.com.yusys.yusp.commons.sequence.util.SequenceUtils;
import cn.com.yusys.yusp.pay.position.application.dto.ps06004.Ps06004ReqDto;
import cn.com.yusys.yusp.pay.position.application.dto.ps06004.Ps06004RspDto;
import cn.com.yusys.yusp.pay.position.domain.repo.PsMMessagetobesentRepo;
import cn.com.yusys.yusp.pay.position.domain.service.PsSMSDomainService;
import cn.com.yusys.yusp.pay.position.domain.util.PSErrorMsg;
import cn.com.yusys.yusp.pay.position.domain.vo.PsMMessagetobesentVo;
import cn.com.yusys.yusp.payment.common.base.dto.YuinRequestDto;
import cn.com.yusys.yusp.payment.common.base.dto.YuinResultDto;
import cn.com.yusys.yusp.payment.common.base.dto.YuinResultHead;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class PS06004Service {
    private static final Logger log = LoggerFactory.getLogger(PS06004Service.class);
    @Autowired
    private PsSMSDomainService psSMSDomainService;
    @Autowired
    private RedisTemplate<String, String> redisTemplate;
    @Autowired
    private PsMMessagetobesentRepo psMMessagetobesentRepo;

    public YuinResultDto getVerificationCode(YuinRequestDto<Ps06004ReqDto> yuinRequestDto) {
        YuinResultDto yuinResultDto = new YuinResultDto();
        YuinResultHead resultHead = new YuinResultHead();
        resultHead.setResponseCode("200");
        resultHead.setResponseMsg("\u901a\u8baf\u6210\u529f");
        yuinResultDto.setHead(resultHead);
        Ps06004RspDto rspDto = null;
        String linkmobile = ((Ps06004ReqDto)yuinRequestDto.getBody()).getLinkmobile();
        if (StringUtils.isBlank((CharSequence)linkmobile)) {
            rspDto = new Ps06004RspDto("0", PSErrorMsg.PS000002.getErrCode(), PSErrorMsg.PS000004.getErrMsg() + "\u8bf7\u68c0\u67e5\u53c2\u6570\u4e0d\u53ef\u7f3a\u5c11:linkmobile-\u624b\u673a\u53f7");
            yuinResultDto.setBody((Object)rspDto);
            return yuinResultDto;
        }
        String code = this.psSMSDomainService.sendSmsVerificationCode(linkmobile);
        if (StringUtils.isBlank((CharSequence)code)) {
            rspDto = new Ps06004RspDto("0", PSErrorMsg.PS000001.getErrCode(), PSErrorMsg.PS000001.getErrMsg() + "\u77ed\u4fe1\u53d1\u9001\u5f02\u5e38");
            yuinResultDto.setBody((Object)rspDto);
            return yuinResultDto;
        }
        this.redisTemplate.opsForValue().set((Object)("PS06003" + linkmobile), (Object)code, 600L, TimeUnit.SECONDS);
        rspDto = new Ps06004RspDto("1", "", "");
        rspDto.setVerificationCode(code);
        yuinResultDto.setBody((Object)rspDto);
        return yuinResultDto;
    }

    public void sendMsgTask(int nums) {
        PsMMessagetobesentVo psMMessagetobesentVo = new PsMMessagetobesentVo();
        psMMessagetobesentVo.setBatchseqno(SequenceUtils.getSequence((String)"msgid"));
        psMMessagetobesentVo.setStatus("0");
        this.psMMessagetobesentRepo.doUpdate(psMMessagetobesentVo, nums);
        List psMMessagetobesentVoList = this.psMMessagetobesentRepo.getToBeSentMessage(psMMessagetobesentVo, nums);
        for (PsMMessagetobesentVo vo : psMMessagetobesentVoList) {
            boolean sendResult = this.psSMSDomainService.sendSms(vo.getMsgcontent(), vo.getLinkmobile());
            log.info("\u624b\u673a\u53f7" + vo.getLinkmobile() + "\u53d1\u9001\u77ed\u4fe1" + (sendResult ? "\u6210\u529f" : "\u5931\u8d25"));
            PsMMessagetobesentVo updateVo = new PsMMessagetobesentVo();
            updateVo.setBatchseqno("");
            updateVo.setStatus(sendResult ? "1" : "9");
            updateVo.setWorkseqid(vo.getWorkseqid());
            updateVo.setWorkdate(vo.getWorkdate());
            this.psMMessagetobesentRepo.doUpdate(updateVo);
        }
    }
}

