/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.pay.position.application.resource;

import cn.com.yusys.yusp.commons.exception.BizBaseException;
import cn.com.yusys.yusp.commons.util.date.DateFormatEnum;
import cn.com.yusys.yusp.commons.util.date.DateUtils;
import cn.com.yusys.yusp.commons.validation.util.ValidatorUtils;
import cn.com.yusys.yusp.pay.position.application.dto.ps04005.Ps04005ReqDto;
import cn.com.yusys.yusp.pay.position.application.dto.ps04005.Ps04005RspDto;
import cn.com.yusys.yusp.pay.position.application.service.PS04005Service;
import cn.com.yusys.yusp.pay.position.domain.util.PSDateUtil;
import cn.com.yusys.yusp.pay.position.domain.util.PSErrorMsg;
import cn.com.yusys.yusp.payment.common.base.dto.YuinRequestDto;
import cn.com.yusys.yusp.payment.common.base.dto.YuinResultDto;
import cn.com.yusys.yusp.payment.common.base.dto.YuinResultHead;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"PS04005"})
@RestController
public class PS04005Resource {
    @Autowired
    private PS04005Service pS04005Service;

    @ApiOperation(value="\u6700\u65b0\u884c\u5185\u9884\u8b66\u4fe1\u606f")
    @PostMapping(value={"/api/payment/ps/ps04005"})
    public YuinResultDto<Ps04005RspDto> ps04005(@RequestBody YuinRequestDto<Ps04005ReqDto> yuinRequestDto) {
        try {
            this.validateRequestDto(yuinRequestDto);
        }
        catch (BizBaseException bizBaseException) {
            bizBaseException.printStackTrace();
            return this.handleException(bizBaseException.getCode(), bizBaseException.getMessage());
        }
        try {
            return this.pS04005Service.ps04005(yuinRequestDto);
        }
        catch (BizBaseException bizBaseException) {
            bizBaseException.printStackTrace();
            return this.handleException(bizBaseException.getCode(), bizBaseException.getMessage());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return this.handleException(PSErrorMsg.PS000001.getErrCode(), PSErrorMsg.PS000001.getErrMsg());
        }
    }

    private void validateRequestDto(YuinRequestDto<Ps04005ReqDto> requestDto) {
        try {
            ValidatorUtils.validate((Object)requestDto.getBody(), (Class[])new Class[0]);
        }
        catch (BizBaseException bizBaseException) {
            throw new BizBaseException(PSErrorMsg.PS000004.getErrCode(), bizBaseException.getCode(), new Object[0]);
        }
        String brType = ((Ps04005ReqDto)requestDto.getBody()).getBrType();
        String brNo = ((Ps04005ReqDto)requestDto.getBody()).getBrNo();
        if ("03".equals(brType) && StringUtils.isBlank((String)brNo)) {
            throw new BizBaseException(PSErrorMsg.PS000008.getErrCode(), "\u673a\u6784\u53f7" + PSErrorMsg.PS000008.getErrMsg(), new Object[0]);
        }
        String startDate = ((Ps04005ReqDto)requestDto.getBody()).getStartDate();
        String endDate = ((Ps04005ReqDto)requestDto.getBody()).getEndDate();
        String currentDate = DateUtils.getCurrentDate((DateFormatEnum)DateFormatEnum.DATE_COMPACT);
        if (PSDateUtil.isSecondDateIsGreaterThanFirstDate((String)currentDate, (String)startDate)) {
            throw new BizBaseException(PSErrorMsg.PS080001.getErrCode(), PSErrorMsg.PS080001.getErrMsg(), new Object[0]);
        }
        if (PSDateUtil.isSecondDateIsGreaterThanFirstDate((String)currentDate, (String)endDate)) {
            throw new BizBaseException(PSErrorMsg.PS080002.getErrCode(), PSErrorMsg.PS080002.getErrMsg(), new Object[0]);
        }
        if (PSDateUtil.isSecondDateIsGreaterThanFirstDate((String)endDate, (String)startDate)) {
            throw new BizBaseException(PSErrorMsg.PS080003.getErrCode(), PSErrorMsg.PS080003.getErrMsg(), new Object[0]);
        }
    }

    private YuinResultDto<Ps04005RspDto> handleException(String errCode, String errMsg) {
        YuinResultDto yuinResultDto = new YuinResultDto();
        YuinResultHead head = new YuinResultHead();
        yuinResultDto.setHead(head);
        Ps04005RspDto rspDto = new Ps04005RspDto("0", errCode, errMsg);
        yuinResultDto.setBody((Object)rspDto);
        head.setResponseCode(rspDto.getErrcode());
        head.setResponseMsg(rspDto.getErrmsg());
        head.setStatus(rspDto.getStatus());
        return yuinResultDto;
    }
}

